/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.enums.PromotionPlanActFormEnum;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeFormDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyLockService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.dto.TpmFreightChargeMaintenanceDto;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.service.TpmFreightChargeMaintenanceService;
import com.biz.crm.tpm.business.freight.charge.maintenance.sdk.vo.TpmFreightChargeMaintenanceVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthDeliveryEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthSaleEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.ExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.GeneralExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.OtherExpensesEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanResult;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PurchaseSale;
import com.biz.crm.tpm.business.promotion.plan.local.repository.CurrentMonthDeliveryRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.CurrentMonthSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.GeneralExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.OtherExpensesRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PurchaseSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthDeliveryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanSubmitDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.log.PromotionPlanLogEventDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.event.log.PromotionPlanLogEventListener;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthDeliveryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.OtherExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PurchaseSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanForEventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanResultVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanResultVoStr;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="promotionPlanService")
public class PromotionPlanServiceImpl
implements PromotionPlanService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanServiceImpl.class);
    @Autowired(required=false)
    private PromotionPlanRepository promotionPlanRepository;
    @Autowired(required=false)
    private GeneralExpensesRepository generalExpensesRepository;
    @Autowired(required=false)
    private CurrentMonthDeliveryRepository currentMonthDeliveryRepository;
    @Autowired(required=false)
    private CurrentMonthSaleRepository currentMonthSaleRepository;
    @Autowired(required=false)
    private PurchaseSaleRepository purchaseSaleRepository;
    @Autowired(required=false)
    private OtherExpensesRepository otherExpensesRepository;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;
    @Autowired(required=false)
    private CurrentMonthSaleService currentMonthSaleService;
    @Autowired(required=false)
    private OtherExpensesService otherExpensesService;
    @Autowired(required=false)
    private PurchaseSaleService purchaseSaleService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private BusinessPolicyLockService businessPolicyLockService;
    @Autowired(required=false)
    private PromotionPlanResultRepository promotionPlanResultRepository;
    @Autowired(required=false)
    private ActualProfitLossService actualProfitLossService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;
    @Autowired(required=false)
    private TpmFreightChargeMaintenanceService tpmFreightChargeMaintenanceService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Page<PromotionPlanVo> findByConditions(Pageable pageable, PromotionPlanDto promotionPlan) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(promotionPlan)) {
            promotionPlan = new PromotionPlanDto();
        }
        return this.promotionPlanRepository.findByConditions(pageable, promotionPlan);
    }

    public PromotionPlanVo findById(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PromotionPlanEntity plan = this.promotionPlanRepository.findByCode(code);
        Validate.notNull((Object)((Object)plan), (String)"\u672a\u627e\u5230\u67e5\u8be2\u7684\u6570\u636e", (Object[])new Object[0]);
        PromotionPlanVo planVo = (PromotionPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)plan, PromotionPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        return planVo;
    }

    public PromotionPlanVo findByCode(String promotionPlanCode) {
        List itemList4;
        List itemList3;
        List itemList2;
        if (StringUtils.isBlank((CharSequence)promotionPlanCode)) {
            return null;
        }
        PromotionPlanEntity plan = this.promotionPlanRepository.findByCode(promotionPlanCode);
        Validate.notNull((Object)((Object)plan), (String)"\u672a\u627e\u5230\u67e5\u8be2\u7684\u6570\u636e", (Object[])new Object[0]);
        PromotionPlanVo planVo = (PromotionPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)plan, PromotionPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.generalExpensesRepository.lambdaQuery().eq(ExpensesEntity::getPromotionPlanCode, (Object)promotionPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, GeneralExpensesEntity.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
            planVo.setGeneralExpensesVos((List)vos);
        }
        if (!CollectionUtils.isEmpty((Collection)(itemList2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.currentMonthDeliveryRepository.lambdaQuery().eq(ExpensesEntity::getPromotionPlanCode, (Object)promotionPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list()))) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList2, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
            planVo.setCurrentMonthDeliveryVos((List)vos);
        }
        if (!CollectionUtils.isEmpty((Collection)(itemList3 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.currentMonthSaleRepository.lambdaQuery().eq(ExpensesEntity::getPromotionPlanCode, (Object)promotionPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list()))) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList3, CurrentMonthSaleEntity.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
            planVo.setCurrentMonthSaleVos((List)vos);
        }
        if (!CollectionUtils.isEmpty((Collection)(itemList4 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.otherExpensesRepository.lambdaQuery().eq(OtherExpensesEntity::getPromotionPlanCode, (Object)promotionPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list()))) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList4, OtherExpensesEntity.class, OtherExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
            planVo.setOtherExpensesVos((List)vos);
        }
        return planVo;
    }

    public List<PromotionPlanVo> findByCodes(List<String> promotionPlanCodes) {
        if (CollectionUtils.isEmpty(promotionPlanCodes)) {
            return null;
        }
        List<PromotionPlanEntity> plans = this.promotionPlanRepository.findByCodes(promotionPlanCodes);
        Validate.notEmpty(plans, (String)"\u672a\u627e\u5230\u67e5\u8be2\u7684\u6570\u636e", (Object[])new Object[0]);
        List planVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(plans, PromotionPlanEntity.class, PromotionPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.generalExpensesRepository.lambdaQuery().in(ExpensesEntity::getPromotionPlanCode, promotionPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<Object, Object> generalExpensesVosMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, GeneralExpensesEntity.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
            generalExpensesVosMap = vos.stream().collect(Collectors.groupingBy(ExpensesVo::getPromotionPlanCode));
        }
        List itemList2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.currentMonthDeliveryRepository.lambdaQuery().in(ExpensesEntity::getPromotionPlanCode, promotionPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<Object, Object> deliveryVosMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)itemList2)) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList2, CurrentMonthDeliveryEntity.class, CurrentMonthDeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
            deliveryVosMap = vos.stream().collect(Collectors.groupingBy(ExpensesVo::getPromotionPlanCode));
        }
        List itemList3 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.currentMonthSaleRepository.lambdaQuery().in(ExpensesEntity::getPromotionPlanCode, promotionPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<Object, Object> saleVosMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)itemList3)) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList3, CurrentMonthSaleEntity.class, CurrentMonthSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
            saleVosMap = vos.stream().collect(Collectors.groupingBy(ExpensesVo::getPromotionPlanCode));
        }
        List itemList4 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.otherExpensesRepository.lambdaQuery().in(OtherExpensesEntity::getPromotionPlanCode, promotionPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<Object, Object> otherExpensesVosMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)itemList4)) {
            Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList4, OtherExpensesEntity.class, OtherExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
            otherExpensesVosMap = vos.stream().collect(Collectors.groupingBy(OtherExpensesVo::getPromotionPlanCode));
        }
        for (PromotionPlanVo e : planVos) {
            e.setGeneralExpensesVos((List)generalExpensesVosMap.get(e.getPromotionPlanCode()));
            e.setCurrentMonthDeliveryVos((List)deliveryVosMap.get(e.getPromotionPlanCode()));
            e.setCurrentMonthSaleVos((List)saleVosMap.get(e.getPromotionPlanCode()));
            e.setOtherExpensesVos((List)otherExpensesVosMap.get(e.getPromotionPlanCode()));
        }
        return planVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = this.createValidate(promotionPlan);
        this.createHandle(businessModel, promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, false);
        this.clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    public void createHandle(String businessModel, PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, boolean isSubmit) {
        promotionPlan.setId(null);
        this.getCacheList(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, isSubmit);
        if (isSubmit) {
            this.detailsValidate(promotionPlan, businessModel);
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthSaleDtos())) {
                this.monthSaleFee(promotionPlan);
            }
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthDeliveryDtos())) {
                this.monthDeliveryFee(promotionPlan);
            }
        }
        List codeList = this.generateCodeService.generateCode("PP" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"), 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        this.store(promotionPlan, businessModel, (String)codeList.get(0));
        PromotionPlanEntity promotionPlanEntity = (PromotionPlanEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPlan, PromotionPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
        promotionPlanEntity.setPromotionPlanCode((String)codeList.get(0));
        promotionPlanEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        promotionPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        promotionPlanEntity.setTenantCode(TenantUtils.getTenantCode());
        promotionPlanEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        promotionPlanEntity.setOrgCode(loginDetails.getOrgCode());
        promotionPlanEntity.setOrgName(loginDetails.getOrgName());
        promotionPlanEntity.setPositionCode(loginDetails.getPostCode());
        promotionPlanEntity.setPositionName(loginDetails.getPostName());
        this.promotionPlanRepository.saveOrUpdate((Object)promotionPlanEntity);
        promotionPlan.setId(promotionPlanEntity.getId());
        promotionPlan.setPromotionPlanCode((String)codeList.get(0));
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult1 = this.getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(), promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, "\u524d\u53f0");
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult2 = this.getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(), promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, "\u8d26\u9762");
        ArrayList<PromotionPlanResultVo> cahchResult = new ArrayList<PromotionPlanResultVo>();
        cahchResult.addAll(cahchResult1.values());
        cahchResult.addAll(cahchResult2.values());
        this.promotionPlanResultRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList(cahchResult, PromotionPlanResultVo.class, PromotionPlanResult.class, HashSet.class, ArrayList.class, new String[0]));
        PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(promotionPlan);
        SerializableBiConsumer & Serializable onCreate = PromotionPlanLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = this.updateValidate(promotionPlan);
        this.updateHandle(businessModel, promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, false);
        this.clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    public void updateHandle(String businessModel, PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, boolean isSubmit) {
        PromotionPlanEntity promotionPlanEntityOld = (PromotionPlanEntity)((Object)this.promotionPlanRepository.getById((Serializable)((Object)promotionPlan.getId())));
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(promotionPlanEntityOld.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(promotionPlanEntityOld.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(promotionPlanEntityOld.getProcessStatus()))) {
            throw new RuntimeException("\u53ea\u80fd\u7f16\u8f91\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\u7684\u6570\u636e\uff01");
        }
        this.getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        Validate.notNull((Object)((Object)promotionPlanEntityOld), (String)"\u672a\u627e\u5230\u4fee\u6539\u7684\u6570\u636e", (Object[])new Object[0]);
        if (isSubmit) {
            this.detailsValidate(promotionPlan, businessModel);
        }
        this.generalExpensesRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        this.currentMonthSaleRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        this.currentMonthDeliveryRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        this.purchaseSaleRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        this.otherExpensesRepository.deleteByPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        if (isSubmit) {
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthSaleDtos())) {
                this.monthSaleFee(promotionPlan);
            }
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthDeliveryDtos())) {
                this.monthDeliveryFee(promotionPlan);
            }
        }
        this.store(promotionPlan, businessModel, promotionPlanEntityOld.getPromotionPlanCode());
        PromotionPlanEntity promotionPlanEntity = (PromotionPlanEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPlan, PromotionPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
        promotionPlanEntity.setPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        promotionPlanEntity.setTenantCode(TenantUtils.getTenantCode());
        this.promotionPlanRepository.saveOrUpdate((Object)promotionPlanEntity);
        promotionPlan.setPromotionPlanCode(promotionPlanEntityOld.getPromotionPlanCode());
        this.promotionPlanResultRepository.removeByCode(promotionPlan.getPromotionPlanCode());
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult1 = this.getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(), promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, "\u524d\u53f0");
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult2 = this.getStoreResult(promotionPlan, promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPurchaseSaleDtos(), promotionPlan.getGeneralExpensesDtos(), promotionPlan.getOtherExpensesDtos(), businessModel, "\u8d26\u9762");
        ArrayList<PromotionPlanResultVo> cahchResult = new ArrayList<PromotionPlanResultVo>();
        cahchResult.addAll(cahchResult1.values());
        cahchResult.addAll(cahchResult2.values());
        this.promotionPlanResultRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList(cahchResult, PromotionPlanResultVo.class, PromotionPlanResult.class, HashSet.class, ArrayList.class, new String[0]));
        PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
        logEventDto.setOriginal((PromotionPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPlanEntityOld, PromotionPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        logEventDto.setNewest(promotionPlan);
        SerializableBiConsumer & Serializable onUpdate = PromotionPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private void getCacheList(PromotionPlanDto promotionPlan, String businessModel, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, boolean isSubmit) {
        if (isSubmit) {
            Validate.notBlank((CharSequence)cacheKeyGeneral, (String)"\u8d39\u7528\u7533\u8bf7\u7f13\u5b58\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        promotionPlan.setGeneralExpensesDtos(this.generalExpensesService.findCacheList(cacheKeyGeneral));
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            if (StringUtils.isNotBlank((CharSequence)cacheKeyDelivery)) {
                promotionPlan.setCurrentMonthDeliveryDtos(this.currentMonthDeliveryService.findCacheList(cacheKeyDelivery));
            }
            if (StringUtils.isNotBlank((CharSequence)cacheKeyPurchase)) {
                promotionPlan.setPurchaseSaleDtos(this.purchaseSaleService.findCacheList(cacheKeyPurchase));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeySale)) {
            promotionPlan.setCurrentMonthSaleDtos(this.currentMonthSaleService.findCacheList(cacheKeySale));
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeyOther)) {
            promotionPlan.setOtherExpensesDtos(this.otherExpensesService.findCacheList(cacheKeyOther));
        }
    }

    private void getCacheList2(PromotionPlanDto promotionPlan, String businessModel, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        List<CurrentMonthDeliveryDto> dtoList;
        String promotionPlanCode = promotionPlan.getPromotionPlanCode();
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            if (StringUtils.isNotBlank((CharSequence)cacheKeyDelivery)) {
                promotionPlan.setCurrentMonthDeliveryDtos(this.currentMonthDeliveryService.findCacheList(cacheKeyDelivery));
            } else if (StringUtils.isNotBlank((CharSequence)promotionPlan.getPromotionPlanCode())) {
                dtoList = this.currentMonthDeliveryRepository.findByPlanCode(promotionPlanCode);
                promotionPlan.setCurrentMonthDeliveryDtos(dtoList);
            }
            if (StringUtils.isNotBlank((CharSequence)cacheKeyPurchase)) {
                promotionPlan.setPurchaseSaleDtos(this.purchaseSaleService.findCacheList(cacheKeyPurchase));
            } else if (StringUtils.isNotBlank((CharSequence)promotionPlan.getPromotionPlanCode())) {
                dtoList = this.purchaseSaleRepository.findByPlanCode(promotionPlanCode);
                promotionPlan.setPurchaseSaleDtos(dtoList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeyOther)) {
            promotionPlan.setOtherExpensesDtos(this.otherExpensesService.findCacheList(cacheKeyOther));
        } else if (StringUtils.isNotBlank((CharSequence)promotionPlan.getPromotionPlanCode())) {
            dtoList = this.otherExpensesRepository.findByPlanCode(promotionPlanCode);
            promotionPlan.setOtherExpensesDtos(dtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeyGeneral)) {
            promotionPlan.setGeneralExpensesDtos(this.generalExpensesService.findCacheList(cacheKeyGeneral));
        } else if (StringUtils.isNotBlank((CharSequence)promotionPlan.getPromotionPlanCode())) {
            dtoList = this.generalExpensesRepository.findByPlanCode(promotionPlanCode);
            promotionPlan.setGeneralExpensesDtos(dtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeySale)) {
            promotionPlan.setCurrentMonthSaleDtos(this.currentMonthSaleService.findCacheList(cacheKeySale));
        } else if (StringUtils.isNotBlank((CharSequence)promotionPlan.getPromotionPlanCode())) {
            dtoList = this.currentMonthSaleRepository.findByPlanCode(promotionPlanCode);
            promotionPlan.setCurrentMonthSaleDtos(dtoList);
        }
    }

    private void clearCacheList(String businessModel, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            if (StringUtils.isNotBlank((CharSequence)cacheKeyDelivery)) {
                this.currentMonthDeliveryService.clearCache(cacheKeyDelivery);
            }
            if (StringUtils.isNotBlank((CharSequence)cacheKeyPurchase)) {
                this.purchaseSaleService.clearCache(cacheKeyPurchase);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeySale)) {
            this.currentMonthSaleService.clearCache(cacheKeySale);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeyOther)) {
            this.otherExpensesService.clearCache(cacheKeyOther);
        }
        this.generalExpensesService.clearCache(cacheKeyGeneral);
    }

    private void store(PromotionPlanDto promotionPlan, String businessModel, String promotionPlanCode) {
        List codeList = this.generateCodeService.generateCode("D", (CollectionUtils.isEmpty((Collection)promotionPlan.getGeneralExpensesDtos()) ? 0 : promotionPlan.getGeneralExpensesDtos().size()) + (CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthSaleDtos()) ? 0 : promotionPlan.getCurrentMonthSaleDtos().size()) + (CollectionUtils.isEmpty((Collection)promotionPlan.getOtherExpensesDtos()) ? 0 : promotionPlan.getOtherExpensesDtos().size()) + ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthDeliveryDtos()) ? 0 : promotionPlan.getCurrentMonthDeliveryDtos().size()) + (CollectionUtils.isEmpty((Collection)promotionPlan.getPurchaseSaleDtos()) ? 0 : promotionPlan.getPurchaseSaleDtos().size()) : 0), Integer.valueOf(9), 2L, TimeUnit.DAYS);
        int index = 0;
        BigDecimal totalApplyAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)promotionPlan.getGeneralExpensesDtos())) {
            Collection generalExpensesEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlan.getGeneralExpensesDtos(), GeneralExpensesDto.class, GeneralExpensesEntity.class, HashSet.class, ArrayList.class, new String[0]);
            for (TenantFlagOpEntity e : generalExpensesEntities) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode((String)codeList.get(index));
                e.setBalance(e.getApplyAmount());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if (Objects.isNull(e.getApplyAmount())) {
                    e.setApplyAmount(BigDecimal.ZERO);
                }
                totalApplyAmount = totalApplyAmount.add(e.getApplyAmount());
                ++index;
            }
            this.generalExpensesRepository.saveBatch(generalExpensesEntities);
            promotionPlan.setTotalApplyAmount(totalApplyAmount);
        }
        if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthSaleDtos())) {
            Collection currentMonthSaleEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlan.getCurrentMonthSaleDtos(), CurrentMonthSaleDto.class, CurrentMonthSaleEntity.class, HashSet.class, ArrayList.class, new String[0]);
            for (TenantFlagOpEntity e : currentMonthSaleEntities) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode((String)codeList.get(index));
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ++index;
            }
            this.currentMonthSaleRepository.saveBatch(currentMonthSaleEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)promotionPlan.getOtherExpensesDtos())) {
            Collection otherExpensesEntitys = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlan.getOtherExpensesDtos(), OtherExpensesDto.class, OtherExpensesEntity.class, HashSet.class, ArrayList.class, new String[0]);
            for (TenantFlagOpEntity e : otherExpensesEntitys) {
                e.setPromotionPlanCode(promotionPlanCode);
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setExpensesCode((String)codeList.get(index));
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ++index;
            }
            this.otherExpensesRepository.saveBatch(otherExpensesEntitys);
        }
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getCurrentMonthDeliveryDtos())) {
                Collection currentMonthDeliveryEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlan.getCurrentMonthDeliveryDtos(), CurrentMonthDeliveryDto.class, CurrentMonthDeliveryEntity.class, HashSet.class, ArrayList.class, new String[0]);
                for (TenantFlagOpEntity e : currentMonthDeliveryEntities) {
                    e.setPromotionPlanCode(promotionPlanCode);
                    e.setTenantCode(TenantUtils.getTenantCode());
                    e.setExpensesCode((String)codeList.get(index));
                    e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    ++index;
                }
                this.currentMonthDeliveryRepository.saveBatch(currentMonthDeliveryEntities);
            }
            if (!CollectionUtils.isEmpty((Collection)promotionPlan.getPurchaseSaleDtos())) {
                Collection purchaseSaleEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlan.getPurchaseSaleDtos(), PurchaseSaleDto.class, PurchaseSale.class, HashSet.class, ArrayList.class, new String[0]);
                for (TenantFlagOpEntity e : purchaseSaleEntities) {
                    e.setPromotionPlanCode(promotionPlanCode);
                    e.setTenantCode(TenantUtils.getTenantCode());
                    e.setExpensesCode((String)codeList.get(index));
                    e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    ++index;
                }
                this.purchaseSaleRepository.saveBatch(purchaseSaleEntities);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List planlist = this.promotionPlanRepository.listByIds(idList);
        Validate.notEmpty((Collection)planlist, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        for (PromotionPlanEntity entity : planlist) {
            if (ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) continue;
            throw new RuntimeException("[" + entity.getPromotionPlanCode() + "]\u672a\u5904\u4e8e\u3010\u5f85\u63d0\u4ea4\u3011\u3001\u3010\u9a73\u56de\u3011\u3001\u3010\u8ffd\u56de\u3011\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        List<String> codeList = planlist.stream().map(e -> e.getPromotionPlanCode()).collect(Collectors.toList());
        this.promotionPlanRepository.removePromotionPlanByIds(idList);
        this.generalExpensesRepository.removeByPromotionPlanCodeList(codeList);
        this.currentMonthDeliveryRepository.removeByPromotionPlanCodeList(codeList);
        this.currentMonthSaleRepository.removeByPromotionPlanCodeList(codeList);
        this.purchaseSaleRepository.removeByPromotionPlanCodeList(codeList);
        this.otherExpensesRepository.removeByPromotionPlanCodeList(codeList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planlist, PromotionPlanEntity.class, PromotionPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = PromotionPlanLogEventListener::onDelete;
        for (PromotionPlanDto dto : dtoList) {
            PromotionPlanLogEventDto logEventDto = new PromotionPlanLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPlanLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public Page<GeneralExpensesVo> findByConditionsGeneral(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page<GeneralExpensesVo> expensesVoPage;
        List records;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(promotionPlan)) {
            promotionPlan = new PromotionPlanDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(records = (expensesVoPage = this.generalExpensesRepository.findByConditionsGeneral(pageable, promotionPlan)).getRecords()))) {
            ArrayList<GeneralExpensesVo> list = new ArrayList<GeneralExpensesVo>(records.size());
            Set<String> set = records.stream().map(ExpensesVo::getExpensesCode).collect(Collectors.toSet());
            List<GeneralExpensesVo> expensesVos = this.generalExpensesRepository.findDataByExpensesCodes(set);
            Map voMap = expensesVos.stream().collect(Collectors.toMap(ExpensesVo::getExpensesCode, Function.identity(), (a, b) -> a));
            for (GeneralExpensesVo r : records) {
                if (Objects.nonNull(voMap)) {
                    GeneralExpensesVo expensesVo = (GeneralExpensesVo)voMap.get(r.getExpensesCode());
                    if (Objects.isNull(expensesVo)) continue;
                    r.setWithholdingAmount(expensesVo.getWithholdingAmount());
                    r.setEstimatedWriteOffAmount(expensesVo.getEstimatedWriteOffAmount());
                }
                list.add(r);
            }
            return expensesVoPage.setRecords(list);
        }
        return expensesVoPage;
    }

    public Page<PromotionPlanVo> findByConditionsWithGeneralExpenses(Pageable pageable, PromotionPlanDto promotionPlan) {
        Page<PromotionPlanVo> byConditions = this.findByConditions(pageable, promotionPlan);
        List promotionPlanVoList = byConditions.getRecords();
        promotionPlanVoList.forEach(promotionPlanVo -> {
            List<GeneralExpensesDto> GeneralExpensesDtoList = this.generalExpensesRepository.findByPlanCode(promotionPlanVo.getPromotionPlanCode());
            List GeneralExpensesVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(GeneralExpensesDtoList, GeneralExpensesDto.class, GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
            promotionPlanVo.setGeneralExpensesVos(GeneralExpensesVoList);
        });
        return byConditions;
    }

    public GeneralExpensesVo findByDetailCodeGeneral(String detailCode) {
        List<GeneralExpensesEntity> list = this.generalExpensesRepository.findByExpensesCode(detailCode);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u7533\u8bf7", (Object[])new Object[0]);
        return (GeneralExpensesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)list.get(0), GeneralExpensesVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<GeneralExpensesVo> findByDetailCodes(Set<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return this.generalExpensesRepository.findByExpensesCodes(detailCodes);
    }

    public void updateGeneral(GeneralExpensesVo vo) {
        GeneralExpensesEntity generalExpensesEntity = (GeneralExpensesEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, GeneralExpensesEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.generalExpensesRepository.saveOrUpdate((Object)generalExpensesEntity);
    }

    public void generateGeneralExpenses(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral) {
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("mdm_business_model", "promotion_plan_act_form", "promotion_plan_act_form2"));
        Validate.notEmpty((Map)dictDataMap, (String)"\u672a\u67e5\u627e\u5230\u4efb\u610f\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        DictDataVo dictDataVo = ((List)dictDataMap.get("mdm_business_model")).stream().filter(e -> promotionPlan.getBusinessModelCode().equals(e.getDictCode())).findFirst().orElse(null);
        Validate.notNull((Object)dictDataVo, (String)"\u6570\u636e\u5b57\u5178\uff1a\u4e1a\u52a1\u6a21\u5f0f\uff0c\u672a\u7ef4\u62a4", (Object[])new Object[0]);
        List dictDataTypeVos = (List)dictDataMap.get("promotion_plan_act_form");
        Validate.notEmpty((Collection)dictDataTypeVos, (String)"\u672a\u67e5\u627e\u5230\u4fc3\u9500\u89c4\u5212\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        Map typeMap = dictDataTypeVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        List dictDataFormVos = (List)dictDataMap.get("promotion_plan_act_form2");
        Validate.notEmpty((Collection)dictDataFormVos, (String)"\u672a\u67e5\u627e\u5230\u4fc3\u9500\u89c4\u5212\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        Map formMap = dictDataFormVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        ArrayList<GeneralExpensesDto> generateGeneralDtos = new ArrayList<GeneralExpensesDto>();
        if ("\u91c7\u9500\u6a21\u5f0f".equals(dictDataVo.getDictValue())) {
            if (StringUtils.isNotBlank((CharSequence)cacheKeyDelivery)) {
                BigDecimal channelPromotionFee = BigDecimal.ZERO;
                BigDecimal purchaseRebate = BigDecimal.ZERO;
                List deliveryList = this.currentMonthDeliveryService.findCacheList(cacheKeyDelivery);
                for (CurrentMonthDeliveryDto e2 : deliveryList) {
                    if (e2.getChannelPromotionFee() != null) {
                        channelPromotionFee = channelPromotionFee.add(e2.getChannelPromotionFee());
                    }
                    if (e2.getPurchaseRebate() == null) continue;
                    purchaseRebate = purchaseRebate.add(e2.getPurchaseRebate());
                }
                this.addGeneral(generateGeneralDtos, promotionPlan, channelPromotionFee, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                this.addGeneral(generateGeneralDtos, promotionPlan, purchaseRebate, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
            }
            if (StringUtils.isNotBlank((CharSequence)cacheKeyPurchase)) {
                List purchaseList = this.purchaseSaleService.findCacheList(cacheKeyPurchase);
                BigDecimal difference = BigDecimal.ZERO;
                BigDecimal saleCommission = BigDecimal.ZERO;
                BigDecimal put = BigDecimal.ZERO;
                BigDecimal purchaseRebate = BigDecimal.ZERO;
                BigDecimal grossProtection = BigDecimal.ZERO;
                for (PurchaseSaleDto purchase : purchaseList) {
                    if (purchase.getFeePoolDifference() != null) {
                        difference = difference.add(purchase.getFeePoolDifference());
                    }
                    if (purchase.getFeePoolSaleCommission() != null) {
                        saleCommission = saleCommission.add(purchase.getFeePoolSaleCommission());
                    }
                    if (purchase.getFeePoolPut() != null) {
                        put = put.add(purchase.getFeePoolPut());
                    }
                    if (purchase.getFeePoolPurchaseRebate() != null) {
                        purchaseRebate = purchaseRebate.add(purchase.getFeePoolPurchaseRebate());
                    }
                    if (purchase.getFeePoolGrossProtection() == null) continue;
                    grossProtection = grossProtection.add(purchase.getFeePoolGrossProtection());
                }
                this.addGeneral(generateGeneralDtos, promotionPlan, difference, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                this.addGeneral(generateGeneralDtos, promotionPlan, saleCommission, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                this.addGeneral(generateGeneralDtos, promotionPlan, put, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.FEE_POOL_PUT.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.FEE_POOL_PUT.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                this.addGeneral(generateGeneralDtos, promotionPlan, purchaseRebate, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
                this.addGeneral(generateGeneralDtos, promotionPlan, grossProtection, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION.getCode())).getDictValue(), promotionPlan.getCustomerCode(), promotionPlan.getCustomerName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeySale)) {
            List saleList = this.currentMonthSaleService.findCacheList(cacheKeySale);
            Map<String, List<CurrentMonthSaleDto>> customerMap = saleList.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode() + "|" + e.getCustomerName() + "|" + e.getChannelCode() + "|" + e.getChannelName()));
            customerMap.forEach((k, v) -> {
                BigDecimal productPromotion = BigDecimal.ZERO;
                BigDecimal largeDateProcess = BigDecimal.ZERO;
                BigDecimal newCustomer = BigDecimal.ZERO;
                BigDecimal oldCustomer = BigDecimal.ZERO;
                BigDecimal tiktokMaster = BigDecimal.ZERO;
                BigDecimal platformGrossProtection = BigDecimal.ZERO;
                BigDecimal platformService = BigDecimal.ZERO;
                BigDecimal platformRebate = BigDecimal.ZERO;
                BigDecimal platformCommission = BigDecimal.ZERO;
                BigDecimal saleCommission = BigDecimal.ZERO;
                BigDecimal uneven = BigDecimal.ZERO;
                BigDecimal highTurnover = BigDecimal.ZERO;
                BigDecimal jd = BigDecimal.ZERO;
                BigDecimal distributionBaseTen = BigDecimal.ZERO;
                BigDecimal distributionBaseMonth = BigDecimal.ZERO;
                BigDecimal monthGoalAchievement = BigDecimal.ZERO;
                BigDecimal prePack = BigDecimal.ZERO;
                BigDecimal staffFee = BigDecimal.ZERO;
                BigDecimal putFee = BigDecimal.ZERO;
                BigDecimal logisticsSupport = BigDecimal.ZERO;
                BigDecimal yearGoalAchievement = BigDecimal.ZERO;
                BigDecimal takeHomePricePolicyFee = BigDecimal.ZERO;
                for (CurrentMonthSaleDto e : v) {
                    if (e.getProductPromotion() != null) {
                        productPromotion = productPromotion.add(e.getProductPromotion());
                    }
                    if (e.getLargeDateProcess() != null) {
                        largeDateProcess = largeDateProcess.add(e.getLargeDateProcess());
                    }
                    if (e.getNewCustomer() != null) {
                        newCustomer = newCustomer.add(e.getNewCustomer());
                    }
                    if (e.getOldCustomer() != null) {
                        oldCustomer = oldCustomer.add(e.getOldCustomer());
                    }
                    if (e.getTiktokMaster() != null) {
                        tiktokMaster = tiktokMaster.add(e.getTiktokMaster());
                    }
                    if (e.getPlatformGrossProtection() != null) {
                        platformGrossProtection = platformGrossProtection.add(e.getPlatformGrossProtection());
                    }
                    if (e.getPlatformService() != null) {
                        platformService = platformService.add(e.getPlatformService());
                    }
                    if (e.getPlatformRebate() != null) {
                        platformRebate = platformRebate.add(e.getPlatformRebate());
                    }
                    if (e.getPlatformCommission() != null) {
                        platformCommission = platformCommission.add(e.getPlatformCommission());
                    }
                    if (e.getSaleCommission() != null) {
                        saleCommission = saleCommission.add(e.getSaleCommission());
                    }
                    if (e.getUneven() != null) {
                        uneven = uneven.add(e.getUneven());
                    }
                    if (e.getHighTurnover() != null) {
                        highTurnover = highTurnover.add(e.getHighTurnover());
                    }
                    if (e.getJd() != null) {
                        jd = jd.add(e.getJd());
                    }
                    if (e.getDistributionBaseTen() != null) {
                        distributionBaseTen = distributionBaseTen.add(e.getDistributionBaseTen());
                    }
                    if (e.getDistributionBaseMonth() != null) {
                        distributionBaseMonth = distributionBaseMonth.add(e.getDistributionBaseMonth());
                    }
                    if (e.getMonthGoalAchievement() != null) {
                        monthGoalAchievement = monthGoalAchievement.add(e.getMonthGoalAchievement());
                    }
                    if (e.getPrePack() != null) {
                        prePack = prePack.add(e.getPrePack());
                    }
                    if (e.getStaffFee() != null) {
                        staffFee = staffFee.add(e.getStaffFee());
                    }
                    if (e.getPutFee() != null) {
                        putFee = putFee.add(e.getPutFee());
                    }
                    if (e.getLogisticsSupport() != null) {
                        logisticsSupport = logisticsSupport.add(e.getLogisticsSupport());
                    }
                    if (e.getYearGoalAchievement() != null) {
                        yearGoalAchievement = yearGoalAchievement.add(e.getYearGoalAchievement());
                    }
                    if (e.getTakeHomePricePolicyFee() == null) continue;
                    takeHomePricePolicyFee = takeHomePricePolicyFee.add(e.getTakeHomePricePolicyFee());
                }
                String[] split = k.split("\\|");
                String customerCode = split[0];
                String customerName = split[1];
                String channelCode = split[2];
                String channelName = split[3];
                if ("\u5206\u9500\u6a21\u5f0f".equals(dictDataVo.getDictValue())) {
                    this.addGeneral(generateGeneralDtos, promotionPlan, distributionBaseTen, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_TEN.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_TEN.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, distributionBaseMonth, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_MONTH.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.DISTRIBUTION_BASE_MONTH.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, monthGoalAchievement, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.MONTH_GOAL_ACHIEVEMENT.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.MONTH_GOAL_ACHIEVEMENT.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, prePack, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PRE_PACK.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PRE_PACK.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, staffFee, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.STAFF_FEE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.STAFF_FEE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, putFee, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PUT_FEE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PUT_FEE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, logisticsSupport, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.LOGISTICS_SUPPORT.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.LOGISTICS_SUPPORT.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, yearGoalAchievement, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.YEAR_GOAL_ACHIEVEMENT.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.YEAR_GOAL_ACHIEVEMENT.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, takeHomePricePolicyFee, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.TAKE_HOME_PRICE_POLICY_FEE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.TAKE_HOME_PRICE_POLICY_FEE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                } else {
                    this.addGeneral(generateGeneralDtos, promotionPlan, productPromotion, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PRODUCT_PROMOTION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PRODUCT_PROMOTION.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, largeDateProcess, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.LARGE_DATE_PROCESS.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.LARGE_DATE_PROCESS.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, newCustomer, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.NEW_CUSTOMER.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.NEW_CUSTOMER.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, oldCustomer, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.OLD_CUSTOMER.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.OLD_CUSTOMER.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, tiktokMaster, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.TIKTOK_MASTER.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.TIKTOK_MASTER.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, platformGrossProtection, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, platformService, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PLATFORM_SERVICE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PLATFORM_SERVICE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, platformRebate, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PLATFORM_REBATE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PLATFORM_REBATE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, platformCommission, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PLATFORM_COMMISSION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PLATFORM_COMMISSION.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, saleCommission, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.SALE_COMMISSION.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.SALE_COMMISSION.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, uneven, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.UNEVEN.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.UNEVEN.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, highTurnover, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.HIGH_TURNOVER.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.HIGH_TURNOVER.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                    this.addGeneral(generateGeneralDtos, promotionPlan, jd, ((DictDataVo)typeMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode())).getDictValue(), ((DictDataVo)formMap.get(PromotionPlanActFormEnum.PURCHASE_REBATE.getCode())).getDictValue(), customerCode, customerName, channelCode, channelName);
                }
            });
        }
        if (!CollectionUtils.isEmpty(generateGeneralDtos)) {
            this.generalExpensesService.addItemListCache(cacheKeyGeneral, generateGeneralDtos);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(PromotionPlanSubmitDto dto) {
        Validate.isTrue((boolean)Objects.nonNull(dto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PromotionPlanEntity entity = (PromotionPlanEntity)((Object)this.promotionPlanRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u89c4\u5212", (Object[])new Object[0]);
        PromotionPlanDto promotionPlanDto = (PromotionPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PromotionPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.monthBudgetHandle(promotionPlanDto, BudgetOperationTypeEnum.USE.getCode());
        this.submitApprovalHandle(promotionPlanDto, dto.getProcessBusiness());
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitAndSetPass(PromotionPlanSubmitDto dto, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel;
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.isTrue((boolean)Objects.nonNull(dto), (String)"\u4fc3\u9500\u89c4\u5212\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(processBusiness), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PromotionPlanDto promotionPlanDto = (PromotionPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PromotionPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            businessModel = this.updateValidate(promotionPlanDto);
            this.updateHandle(businessModel, promotionPlanDto, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, true);
        } else {
            businessModel = this.createValidate(promotionPlanDto);
            this.createHandle(businessModel, promotionPlanDto, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, true);
        }
        PromotionPlanEntity entity = (PromotionPlanEntity)((Object)this.promotionPlanRepository.getById((Serializable)((Object)promotionPlanDto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u89c4\u5212", (Object[])new Object[0]);
        promotionPlanDto = (PromotionPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PromotionPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.monthBudgetHandle(promotionPlanDto, BudgetOperationTypeEnum.USE.getCode());
        this.submitApprovalHandle(promotionPlanDto, processBusiness);
        this.clearCacheList(businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
    }

    public List<MonthBudgetBusinessPolicyQueryVo> getMonthBudget(String cacheKeyGeneral, String cacheKeySale, String promotionPlanCode) {
        ArrayList<MonthBudgetBusinessPolicyQueryVo> monthBudgetVoList = new ArrayList();
        ArrayList<GeneralExpensesDto> cacheList = new ArrayList();
        List<Object> saleList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)cacheKeyGeneral)) {
            cacheList = this.generalExpensesService.findCacheList(cacheKeyGeneral);
        } else if (StringUtils.isNotBlank((CharSequence)promotionPlanCode)) {
            cacheList = this.generalExpensesRepository.findByPlanCode(promotionPlanCode);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheKeySale)) {
            saleList = this.currentMonthSaleService.findCacheList(cacheKeySale);
        } else if (StringUtils.isNotBlank((CharSequence)promotionPlanCode)) {
            saleList = this.currentMonthSaleRepository.findByPlanCode(promotionPlanCode);
        }
        monthBudgetVoList = this.getMonthBudgetHandle(cacheList, saleList);
        return monthBudgetVoList;
    }

    public List<MonthBudgetBusinessPolicyQueryVo> getMonthBudgetHandle(List<GeneralExpensesDto> cacheList, List<CurrentMonthSaleDto> saleList) {
        List<Object> monthBudgetVoList = new ArrayList<MonthBudgetBusinessPolicyQueryVo>();
        BigDecimal sumSale = saleList.stream().map(e -> this.bdNull(e.getEstimatedAmountAfter())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!CollectionUtils.isEmpty(cacheList)) {
            LinkedHashSet codes = cacheList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getMonthBudgetCode())).map(e -> e.getMonthBudgetCode()).collect(Collectors.toCollection(LinkedHashSet::new));
            monthBudgetVoList = this.monthBudgetService.findBusinessPolicyByCodes(new ArrayList(codes));
            monthBudgetVoList.forEach(vo -> {
                BigDecimal amount = cacheList.stream().filter(e -> vo.getMonthBudgetCode().equals(e.getMonthBudgetCode())).map(e -> this.bdNull(e.getApplyAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setUsedAmount(amount);
                vo.setUsedVsControl(amount.subtract(this.bdNull(vo.getControlBalanceAmount())));
                vo.setFeeRatio(sumSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(sumSale, 6, 4).multiply(new BigDecimal(100)));
                vo.setBusinessCode(((GeneralExpensesDto)cacheList.get(0)).getPromotionPlanCode());
            });
        }
        return monthBudgetVoList;
    }

    public void rejectRecover(PromotionPlanDto promotionPlan) {
        this.monthBudgetHandle(promotionPlan, BudgetOperationTypeEnum.RETURN.getCode());
    }

    public List<PromotionPlanResultVoStr> calculationResult(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, String type) {
        LinkedHashMap<String, PromotionPlanResultVo> cahchResult = this.getCahchResult(promotionPlan, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther, type);
        String nowStr = LocalDate.now().getYear() + "-01-01";
        List<PromotionPlanResult> history = this.promotionPlanResultRepository.getByDate((Date)DateUtil.parse((CharSequence)nowStr, (String)"yyyy-MM-dd"), promotionPlan.getCustomerCode(), type);
        if (!CollectionUtils.isEmpty(history)) {
            ArrayList historyVo = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(history, PromotionPlanResult.class, PromotionPlanResultVo.class, HashSet.class, ArrayList.class, new String[0]));
            Map<String, List<PromotionPlanResultVo>> historyMap = historyVo.stream().collect(Collectors.groupingBy(e -> e.getProjectCode()));
            historyMap.forEach((k, v) -> {
                BigDecimal total = v.stream().map(e -> this.bdNull(e.getPlan())).reduce(BigDecimal.ZERO, BigDecimal::add);
                ((PromotionPlanResultVo)cahchResult.get(k)).setPlanTotal(total.add(((PromotionPlanResultVo)cahchResult.get(k)).getPlan() == null ? BigDecimal.ZERO : ((PromotionPlanResultVo)cahchResult.get(k)).getPlan()));
            });
        } else {
            for (String k2 : cahchResult.keySet()) {
                PromotionPlanResultVo v2 = cahchResult.get(k2);
                if (PromotionPlanResultProjectEnum.INTENSITY.getCode().equals(k2)) continue;
                v2.setPlanTotal(v2.getPlan());
            }
        }
        BigDecimal cost = cahchResult.get(PromotionPlanResultProjectEnum.COST.getCode()).getPlanTotal();
        BigDecimal netIncome = cahchResult.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).getPlanTotal();
        BigDecimal discount = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).getPlanTotal();
        BigDecimal discountAfterSale = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).getPlanTotal();
        BigDecimal reimbursement = cahchResult.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).getPlanTotal();
        BigDecimal consumer = cahchResult.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).getPlanTotal();
        BigDecimal channel = cahchResult.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).getPlanTotal();
        BigDecimal put = cahchResult.get(PromotionPlanResultProjectEnum.PUT.getCode()).getPlanTotal();
        BigDecimal platformOperate = cahchResult.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).getPlanTotal();
        BigDecimal discountBeforeSale = cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).getPlanTotal();
        BigDecimal logistics = cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).getPlanTotal();
        BigDecimal ton = cahchResult.get(PromotionPlanResultProjectEnum.TON.getCode()).getPlanTotal();
        BigDecimal netProfit = cahchResult.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).getPlanTotal();
        BigDecimal feePool = cahchResult.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).getPlanTotal();
        cahchResult.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setPlanTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setPlanTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
        BigDecimal specialCost = BigDecimal.ZERO;
        specialCost = "purchase_sales_mode".equals(promotionPlan.getBusinessModelCode()) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setPlanTotal(specialCost);
        cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setPlanTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setPlanTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.multiply(new BigDecimal(1000)).divide(ton, 2, 4));
        cahchResult.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setPlanTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
        for (String k3 : cahchResult.keySet()) {
            PromotionPlanResultVo v3 = cahchResult.get(k3);
            v3.setPlanVsContemporaneous(this.bdNull(v3.getPlan()).subtract(this.bdNull(v3.getContemporaneous())));
            v3.setPlanVsBudget(this.bdNull(v3.getPlan()).subtract(this.bdNull(v3.getBudget())));
            if (PromotionPlanResultProjectEnum.INTENSITY.getCode().equals(k3)) continue;
            v3.setActualPlan(this.bdNull(v3.getContemporaneousTotal()).add(this.bdNull(v3.getPlan())));
            v3.setActualPlanVsBudget(v3.getActualPlan().subtract(this.bdNull(v3.getBudgetTotal())));
        }
        return this.voChange(cahchResult);
    }

    public void calculationCurrentMonthSaleFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = this.createValidate(promotionPlan);
        this.getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        this.monthSaleFee(promotionPlan);
        this.currentMonthSaleService.clearCache(cacheKeySale);
        this.currentMonthSaleService.addListCache(cacheKeySale, promotionPlan.getCurrentMonthSaleDtos());
    }

    private void monthSaleFee(PromotionPlanDto promotionPlan) {
        List currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthSaleDtos();
        List currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthDeliveryDtos();
        List purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList() : promotionPlan.getPurchaseSaleDtos();
        List generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList() : promotionPlan.getGeneralExpensesDtos();
        List otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList() : promotionPlan.getOtherExpensesDtos();
        Map dictTypeCodeMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("discounts", "tpm_sales_management_reimbursement"));
        Map saleDiscountMap = ((List)dictTypeCodeMap.get("discounts")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        Map saleReimburseMap = ((List)dictTypeCodeMap.get("tpm_sales_management_reimbursement")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        List oneD = ((DictDataVo)saleDiscountMap.get("one")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List twoD = ((DictDataVo)saleDiscountMap.get("two")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List threeD = ((DictDataVo)saleDiscountMap.get("three")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List fourD = ((DictDataVo)saleDiscountMap.get("four")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List oneR = ((DictDataVo)saleReimburseMap.get("one")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List twoR = ((DictDataVo)saleReimburseMap.get("two")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List threeR = ((DictDataVo)saleReimburseMap.get("three")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        BigDecimal discountBeforeTotal = currentMonthSaleDtos.stream().map(e -> this.bdNull(e.getEstimatedAmountBefore())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal adminHumanTotal = BigDecimal.ZERO;
        BigDecimal logisticsTotal = BigDecimal.ZERO;
        for (OtherExpensesDto dto : otherExpensesDtos) {
            adminHumanTotal = adminHumanTotal.add(this.bdNull(dto.getAdminAmountPlan()).add(this.bdNull(dto.getHumanAmountPlan())));
            logisticsTotal = logisticsTotal.add(this.bdNull(dto.getLogisticsAmountPlan()));
        }
        Validate.isTrue((BigDecimal.ZERO.compareTo(discountBeforeTotal) < 0 ? 1 : 0) != 0, (String)"\u9884\u8ba1\u6298\u524d\u9500\u552e\u989d\u6c47\u603b\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Map<String, List<GeneralExpensesDto>> customerListMap = generalExpensesDtos.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode()));
        HashMap customerRRMap = new HashMap();
        customerListMap.forEach((k, v) -> {
            HashMap<String, BigDecimal> customerMap = new HashMap<String, BigDecimal>();
            BigDecimal redInvoice = BigDecimal.ZERO;
            BigDecimal reimburse = BigDecimal.ZERO;
            for (GeneralExpensesDto dto : v) {
                if (Boolean.TRUE.equals(dto.getBeGenerate())) continue;
                if ("\u7ea2\u5b57\u53d1\u7968".equals(dto.getAuditWayName())) {
                    redInvoice = redInvoice.add(dto.getApplyAmount());
                }
                if (!"\u62a5\u9500".equals(dto.getAuditWayName())) continue;
                reimburse = reimburse.add(dto.getApplyAmount());
            }
            customerMap.put("redInvoice", redInvoice);
            customerMap.put("reimburse", reimburse);
            customerRRMap.put(k, customerMap);
        });
        BigDecimal channelPromotionFee = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(currentMonthDeliveryDtos)) {
            channelPromotionFee = currentMonthDeliveryDtos.stream().map(e -> this.bdNull(e.getChannelPromotionFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Map<String, List<CurrentMonthSaleDto>> currentMonthSaleMap = currentMonthSaleDtos.stream().collect(Collectors.groupingBy(e -> e.getCustomerCode()));
        ArrayList<CurrentMonthSaleDto> temp = new ArrayList<CurrentMonthSaleDto>();
        for (String k2 : currentMonthSaleMap.keySet()) {
            List<CurrentMonthSaleDto> dtoList = currentMonthSaleMap.get(k2);
            BigDecimal discountBeforeTotalCustomer = dtoList.stream().map(e -> this.bdNull(e.getEstimatedAmountBefore())).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (CurrentMonthSaleDto dto : dtoList) {
                BigDecimal discountSingleR;
                BigDecimal discountSingleD;
                BigDecimal platformService = BigDecimal.ZERO;
                BigDecimal ratio = dto.getEstimatedAmountBefore().divide(discountBeforeTotalCustomer, 6, 4);
                if (oneD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = this.bdNull(dto.getJd());
                } else if (twoD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())).add(this.bdNull(dto.getPlatformGrossProtection()));
                } else if (threeD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = this.bdNull(dto.getDistributionBaseTen()).add(this.bdNull(dto.getDistributionBaseMonth())).add(this.bdNull(dto.getMonthGoalAchievement())).add(this.bdNull(dto.getPrePack())).add(this.bdNull(dto.getStaffFee())).add(this.bdNull(dto.getPutFee())).add(this.bdNull(dto.getLogisticsSupport())).add(this.bdNull(dto.getYearGoalAchievement())).add(this.bdNull(dto.getTakeHomePricePolicyFee()));
                    discountSingleR = this.bdNull(dto.getPlatformService()).add(this.bdNull(dto.getPlatformRebate())).add(this.bdNull(dto.getPlatformCommission()));
                } else if (fourD.contains(promotionPlan.getPlatformName())) {
                    discountSingleD = this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())).add(this.bdNull(dto.getPlatformService()));
                    discountSingleR = this.bdNull(dto.getPlatformService()).add(this.bdNull(dto.getPlatformRebate())).add(this.bdNull(dto.getPlatformCommission()));
                } else {
                    discountSingleD = this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster()));
                }
                if (oneR.contains(promotionPlan.getPlatformName())) {
                    discountSingleR = this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())).add(this.bdNull(dto.getPlatformGrossProtection())).add(this.bdNull(dto.getSaleCommission()));
                } else if (twoR.contains(promotionPlan.getPlatformName())) {
                    discountSingleR = channelPromotionFee.multiply(ratio);
                    platformService = this.bdNull(dto.getPlatformService()).divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP);
                } else {
                    discountSingleR = threeR.contains(promotionPlan.getPlatformName()) ? this.bdNull(this.bdNull(dto.getPlatformRebate())).add(this.bdNull(dto.getPlatformCommission())) : this.bdNull(dto.getPlatformService()).add(this.bdNull(dto.getPlatformRebate())).add(this.bdNull(dto.getPlatformCommission()));
                }
                Map rrMap = (Map)customerRRMap.get(dto.getCustomerCode());
                BigDecimal redInvoice = BigDecimal.ZERO;
                BigDecimal reimburse = BigDecimal.ZERO;
                if (rrMap != null) {
                    redInvoice = (BigDecimal)rrMap.get("redInvoice");
                    reimburse = (BigDecimal)rrMap.get("reimburse");
                }
                dto.setDiscount(discountSingleD.add(redInvoice.multiply(ratio)).setScale(2, RoundingMode.HALF_UP));
                discountSingleR = discountSingleR.divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP);
                dto.setSaleReimburse(discountSingleR.add(platformService).add(reimburse.divide(new BigDecimal("1.06"), 2, RoundingMode.HALF_UP).multiply(ratio)).setScale(2, 4));
            }
            temp.addAll(dtoList);
        }
        currentMonthSaleDtos = temp;
        BigDecimal finalLogisticsTotal = logisticsTotal;
        BigDecimal finalAdminHumanTotal = adminHumanTotal;
        currentMonthSaleDtos.forEach(e -> {
            e.setEstimatedAmountBefore(e.getCombinationQuantity().multiply(e.getPlatformSupplyPrice()).multiply(e.getEstimatedSalesBox()).setScale(2, RoundingMode.HALF_UP));
            if ("\u4eac\u4e1c\u5546\u57ce".equals(promotionPlan.getPlatformName())) {
                e.setJd(e.getEstimatedAmountBefore().multiply(new BigDecimal("0.06")).setScale(2, RoundingMode.HALF_UP));
            }
            BigDecimal ratio = e.getEstimatedAmountBefore().divide(discountBeforeTotal, 6, 4);
            e.setLogistics(this.getLogistics(promotionPlan, finalLogisticsTotal, e.getEstimatedAmountBefore(), ratio, e.getCustomerCode(), e.getStartDate(), "sale"));
            e.setAdminHuman(finalAdminHumanTotal.multiply(ratio).setScale(2, RoundingMode.HALF_UP));
            this.currentMonthSaleService.calculationFee(e, promotionPlan.getBusinessModelCode());
        });
        promotionPlan.setCurrentMonthSaleDtos(currentMonthSaleDtos);
    }

    public void calculationCurrentMonthDeliveryFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyPurchase, String cacheKeyDelivery, String cacheKeyGeneral, String cacheKeyOther) {
        String businessModel = this.createValidate(promotionPlan);
        this.getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        this.monthDeliveryFee(promotionPlan);
        this.currentMonthDeliveryService.clearCache(cacheKeyDelivery);
        this.currentMonthDeliveryService.addListCache(cacheKeyDelivery, promotionPlan.getCurrentMonthDeliveryDtos());
    }

    public List<PromotionPlanVo> findByCodeList(List<String> codeList) {
        List<PromotionPlanEntity> entityList = this.promotionPlanRepository.findByCodeList(codeList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, PromotionPlanEntity.class, PromotionPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(Pageable pageable, PromotionPlanForEventPrepaymentDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new PromotionPlanForEventPrepaymentDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.promotionPlanRepository.findPromotionPlanPageListForEventPrepayment((Page<PromotionPlanForEventPrepaymentVo>)page, dto);
    }

    public int findTotalByConditionsGeneral(PromotionPlanDto promotionPlanDto) {
        return this.generalExpensesRepository.getTotalNum(promotionPlanDto);
    }

    public List<GeneralExpensesVo> findListByDetailCodeGeneral(Set<String> activityDetailCodes) {
        List<GeneralExpensesEntity> list = this.generalExpensesRepository.findListByExpensesCodes(activityDetailCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u7533\u8bf7", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, GeneralExpensesEntity.class, GeneralExpensesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public BigDecimal getMinActivityBasePrice(CurrentMonthSaleDto currentMonthSaleDto) {
        return this.currentMonthSaleRepository.getMinActivityBasePrice(currentMonthSaleDto);
    }

    public List<PromotionPlanVo> findByDateConditions(PromotionPlanDto promotionPlanDto) {
        return this.promotionPlanRepository.findByDateConditions(promotionPlanDto);
    }

    public Page<GeneralExpensesVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.generalExpensesRepository.findCanAutoAuditItemPage((Page<GeneralExpensesVo>)page, autoAuditParams);
    }

    public void updateAutoAuditFlag(List<String> activityDetailCodes, String falg) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return;
        }
        this.generalExpensesRepository.updateAutoAuditFlag(activityDetailCodes, falg);
    }

    private void monthDeliveryFee(PromotionPlanDto promotionPlan) {
        List currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthSaleDtos();
        List newCurrentMonthSaleDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(currentMonthSaleDtos, CurrentMonthSaleDto.class, CurrentMonthSaleDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthDeliveryDtos();
        List generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList() : promotionPlan.getGeneralExpensesDtos();
        List otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList() : promotionPlan.getOtherExpensesDtos();
        List purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList() : promotionPlan.getPurchaseSaleDtos();
        Map dictTypeCodeMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("discounts2", "tpm_sales_management_reimbursement2"));
        Map deliveryDiscountMap = ((List)dictTypeCodeMap.get("discounts2")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        Map deliveryReimburseMap = ((List)dictTypeCodeMap.get("tpm_sales_management_reimbursement2")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        List<String> oneD = ((DictDataVo)deliveryDiscountMap.get("one")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoD = ((DictDataVo)deliveryDiscountMap.get("two")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> oneR = ((DictDataVo)deliveryReimburseMap.get("one")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        List<String> twoR = ((DictDataVo)deliveryReimburseMap.get("two")).getChildren().stream().map(e -> e.getDictValue()).collect(Collectors.toList());
        BigDecimal redInvoice = BigDecimal.ZERO;
        BigDecimal reimburse = BigDecimal.ZERO;
        BigDecimal estimatedAmountTotal = currentMonthDeliveryDtos.stream().map(e -> this.bdNull(e.getEstimatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal feeTotal = purchaseSaleDtos.stream().map(e -> this.bdNull(e.getFeePoolDifference()).add(this.bdNull(e.getFeePoolPut())).add(this.bdNull(e.getFeePoolGrossProtection())).add(this.bdNull(e.getFeePoolSaleCommission())).add(this.bdNull(e.getFeePoolPurchaseRebate()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal adminHumanTotal = BigDecimal.ZERO;
        BigDecimal logisticsTotal = BigDecimal.ZERO;
        for (OtherExpensesDto dto : otherExpensesDtos) {
            adminHumanTotal = adminHumanTotal.add(this.bdNull(dto.getAdminAmountPlan()).add(this.bdNull(dto.getHumanAmountPlan())));
            logisticsTotal = logisticsTotal.add(this.bdNull(dto.getLogisticsAmountPlan()));
        }
        Validate.isTrue((BigDecimal.ZERO.compareTo(estimatedAmountTotal) < 0 ? 1 : 0) != 0, (String)"\u5f53\u6708\u9001\u8d27\u9884\u8ba1\u9500\u552e\u989d\u6c47\u603b\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        for (OtherExpensesDto dto : generalExpensesDtos) {
            if (Boolean.TRUE.equals(dto.getBeGenerate())) continue;
            if ("\u7ea2\u5b57\u53d1\u7968".equals(dto.getAuditWayName())) {
                redInvoice = redInvoice.add(dto.getApplyAmount());
            }
            if (!"\u62a5\u9500".equals(dto.getAuditWayName())) continue;
            reimburse = reimburse.add(dto.getApplyAmount());
        }
        BigDecimal plateformServiceSum = BigDecimal.ZERO;
        if (twoR.contains(promotionPlan.getPlatformName())) {
            plateformServiceSum = newCurrentMonthSaleDtos.stream().map(e -> this.bdNull(e.getPlatformService())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Set productSet = currentMonthDeliveryDtos.stream().map(e -> e.getProductCode()).collect(Collectors.toSet());
        ArrayList subCurrentMonthSaleDtos = Lists.newArrayList();
        Iterator iterator = newCurrentMonthSaleDtos.iterator();
        while (iterator.hasNext()) {
            CurrentMonthSaleDto e2 = (CurrentMonthSaleDto)iterator.next();
            if (productSet.contains(e2.getProductCode())) continue;
            subCurrentMonthSaleDtos.add(e2);
            iterator.remove();
        }
        BigDecimal discountSub = BigDecimal.ZERO;
        BigDecimal saleReimburseSub = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("discount", discountSub);
        map.put("saleReimburse", saleReimburseSub);
        for (CurrentMonthSaleDto dto : subCurrentMonthSaleDtos) {
            this.sumDiscountSaleReimburse(map, dto, promotionPlan.getPlatformName(), oneD, twoD, oneR, twoR);
        }
        discountSub = (BigDecimal)map.get("discount");
        saleReimburseSub = (BigDecimal)map.get("saleReimburse");
        for (CurrentMonthDeliveryDto cdd : currentMonthDeliveryDtos) {
            BigDecimal discount = BigDecimal.ZERO;
            BigDecimal saleReimburse = BigDecimal.ZERO;
            HashMap<String, BigDecimal> mapSale = new HashMap<String, BigDecimal>();
            mapSale.put("discount", discount);
            mapSale.put("saleReimburse", saleReimburse);
            BigDecimal ratio = cdd.getEstimatedAmount().divide(estimatedAmountTotal, 6, 4);
            for (CurrentMonthSaleDto dto : newCurrentMonthSaleDtos) {
                if (!cdd.getProductCode().equals(dto.getProductCode())) continue;
                this.sumDiscountSaleReimburse(mapSale, dto, promotionPlan.getPlatformName(), oneD, twoD, oneR, twoR);
            }
            discount = (BigDecimal)mapSale.get("discount");
            saleReimburse = (BigDecimal)mapSale.get("saleReimburse");
            BigDecimal plateformService = BigDecimal.ZERO;
            if (twoD.contains(promotionPlan.getPlatformName())) {
                BigDecimal deliveryPurchase = this.bdNull(cdd.getPurchaseRebate());
                discount = discount.add(deliveryPurchase);
            }
            if (twoR.contains(promotionPlan.getPlatformName())) {
                saleReimburse = saleReimburse.add(this.bdNull(cdd.getChannelPromotionFee()));
                plateformService = plateformServiceSum.multiply(ratio).divide(new BigDecimal(1.06), 2, 4);
            }
            saleReimburse = saleReimburse.divide(new BigDecimal(1.06), 2, 4);
            BigDecimal saleReimburseSubNew = saleReimburseSub.divide(new BigDecimal(1.06), 2, 4);
            log.info("========================================\u5f53\u6708\u9001\u8d27\u91cd\u65b0\u8ba1\u7b97\u635f\u76ca");
            log.info("\u4ea7\u54c1\u7f16\u7801\uff1a" + cdd.getProductCode());
            log.info("\u5f53\u6761\u9001\u8d27\u7684\u6bd4\u4f8bratio\uff1a" + ratio);
            log.info("\u603b\u7684\u7ea2\u5b57\u53d1\u7968redInvoice\uff1a" + redInvoice);
            log.info("\u76f8\u540c\u4ea7\u54c1\u7684\u5355\u54c1\u6298\u6263discount\uff1a" + discount);
            log.info("\u4e0d\u540c\u4ea7\u54c1\u7684\u5f53\u6708\u9500\u552e\u603b\u6298\u6263discountSub\uff1a" + discountSub);
            cdd.setDiscount(discount.add(redInvoice.multiply(ratio)).add(discountSub.multiply(ratio)).setScale(2, 4));
            log.info("\u76f8\u540c\u4ea7\u54c1\u7684\u5355\u54c1\u62a5\u9500saleReimburse\uff1a" + saleReimburse);
            log.info("\u5f53\u524d\u6bd4\u4f8b\u5e73\u53f0\u670d\u52a1\u8d39/1.06plateformService\uff1a" + plateformService);
            log.info("\u62a5\u9500\u6c47\u603breimburse\uff1a" + reimburse);
            log.info("\u91c7\u9500\u5e93\u5b58\u4e2d\u8d39\u7528\u6c60\u6c47\u603bfeeTotal\uff1a" + feeTotal);
            log.info("\u4e0d\u540c\u4ea7\u54c1\u7684\u5f53\u6708\u9500\u552e\u603b\u62a5\u9500saleReimburseSubNew\uff1a" + saleReimburseSubNew);
            log.info("========================================\u5f53\u6708\u9001\u8d27\u91cd\u65b0\u8ba1\u7b97\u635f\u76ca");
            cdd.setSaleReimburse(saleReimburse.add(plateformService).add(reimburse.add(feeTotal).divide(new BigDecimal("1.06"), 2, 4).multiply(ratio)).add(saleReimburseSubNew.multiply(ratio)).setScale(2, 4));
            cdd.setAdminHuman(adminHumanTotal.multiply(ratio).setScale(2, 4));
            cdd.setLogistics(this.getLogistics(promotionPlan, logisticsTotal, cdd.getEstimatedAmount(), ratio, cdd.getCustomerCode(), cdd.getStartDate(), "delivery"));
        }
        currentMonthDeliveryDtos.forEach(e -> this.currentMonthDeliveryService.calculationFee(e, promotionPlan.getPlatformName()));
        promotionPlan.setCurrentMonthDeliveryDtos(currentMonthDeliveryDtos);
    }

    private BigDecimal getLogistics(PromotionPlanDto promotionPlan, BigDecimal otherLogisticsSum, BigDecimal estimatedAmount, BigDecimal ratio, String customerCode, Date startDate, String type) {
        BigDecimal logistics = BigDecimal.ZERO;
        if ("sale".equals(type)) {
            TpmFreightChargeMaintenanceDto fcmDto = new TpmFreightChargeMaintenanceDto();
            fcmDto.setCustomerCode(customerCode);
            fcmDto.setPlatformCode(promotionPlan.getPlatformCode());
            fcmDto.setSalesOrgCode(promotionPlan.getSalesOrgCode());
            fcmDto.setEffectiveDate(startDate);
            log.info("=======\u8fd0\u8d39\u4ef7\u683c\u7ba1\u7406\u8fd0\u8d39\u8d39\u7387\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)fcmDto));
            Page voPage = this.tpmFreightChargeMaintenanceService.findByConditions(null, fcmDto);
            log.info("=======\u8fd0\u8d39\u4ef7\u683c\u7ba1\u7406\u8fd0\u8d39\u8d39\u7387\u8fd4\u56de\u53c2\u6570\uff1a" + JSONArray.toJSONString((Object)voPage));
            if (voPage.getTotal() > 0L) {
                logistics = ((TpmFreightChargeMaintenanceVo)voPage.getRecords().get(0)).getPrice().multiply(this.bdNull(estimatedAmount)).setScale(2, 4);
            }
        }
        return logistics.add(otherLogisticsSum.multiply(ratio)).setScale(2, 4);
    }

    private void sumDiscountSaleReimburse(Map<String, BigDecimal> map, CurrentMonthSaleDto dto, String platformName, List<String> oneD, List<String> twoD, List<String> oneR, List<String> twoR) {
        BigDecimal discount = map.get("discount");
        BigDecimal saleReimburse = map.get("saleReimburse");
        BigDecimal discountSingleR = BigDecimal.ZERO;
        BigDecimal discountSingleD = oneD.contains(platformName) ? this.bdNull(dto.getJd()) : (twoD.contains(platformName) ? this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())).add(this.bdNull(dto.getPlatformGrossProtection())).add(this.bdNull(dto.getSaleCommission())) : this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())));
        if (oneR.contains(platformName)) {
            discountSingleR = this.bdNull(dto.getProductPromotion()).add(this.bdNull(dto.getNewCustomer())).add(this.bdNull(dto.getOldCustomer())).add(this.bdNull(dto.getLargeDateProcess())).add(this.bdNull(dto.getHighTurnover())).add(this.bdNull(dto.getUneven())).add(this.bdNull(dto.getTiktokMaster())).add(this.bdNull(dto.getPlatformGrossProtection())).add(this.bdNull(dto.getSaleCommission()));
        } else if (!twoR.contains(platformName)) {
            discountSingleR = this.bdNull(dto.getPlatformService()).add(this.bdNull(dto.getPlatformRebate())).add(this.bdNull(dto.getPlatformCommission()));
        }
        discount = discount.add(discountSingleD);
        saleReimburse = saleReimburse.add(discountSingleR);
        map.put("discount", discount);
        map.put("saleReimburse", saleReimburse);
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }

    List<PromotionPlanResultVoStr> voChange(LinkedHashMap<String, PromotionPlanResultVo> cahchResult) {
        ArrayList<PromotionPlanResultVo> values = new ArrayList<PromotionPlanResultVo>(cahchResult.values());
        ArrayList<PromotionPlanResultVoStr> strVoList = new ArrayList<PromotionPlanResultVoStr>();
        cahchResult.forEach((k, v) -> {
            PromotionPlanResultVoStr strVo = new PromotionPlanResultVoStr().setProjectCode(v.getProjectCode()).setProjectName(v.getProjectName());
            if (k.equals(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.PUT_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()) || k.equals(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()) || k.equals(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode())) {
                strVo.setPlan(v.getPlan().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanTotal(v.getPlanTotal().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setContemporaneous(this.bdNull(v.getContemporaneous()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setContemporaneousTotal(this.bdNull(v.getContemporaneousTotal()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setBudget(this.bdNull(v.getBudget()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setBudgetTotal(this.bdNull(v.getBudgetTotal()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanVsContemporaneous(v.getPlanVsContemporaneous().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanVsBudget(v.getPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setActualPlan(v.getActualPlan().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setActualPlanVsBudget(v.getActualPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, 4) + "%");
            } else {
                strVo.setPlan((v.getPlan() == null ? BigDecimal.ZERO : v.getPlan()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanTotal((v.getPlanTotal() == null ? BigDecimal.ZERO : v.getPlanTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setContemporaneous((v.getContemporaneous() == null ? BigDecimal.ZERO : v.getContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString()).setContemporaneousTotal((v.getContemporaneousTotal() == null ? BigDecimal.ZERO : v.getContemporaneousTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setBudget((v.getBudget() == null ? BigDecimal.ZERO : v.getBudget()).setScale(3, RoundingMode.HALF_UP).toString()).setBudgetTotal((v.getBudgetTotal() == null ? BigDecimal.ZERO : v.getBudgetTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanVsContemporaneous((v.getPlanVsContemporaneous() == null ? BigDecimal.ZERO : v.getPlanVsContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanVsBudget((v.getPlanVsBudget() == null ? BigDecimal.ZERO : v.getPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString()).setActualPlan((v.getActualPlan() == null ? BigDecimal.ZERO : v.getActualPlan()).setScale(3, RoundingMode.HALF_UP).toString()).setActualPlanVsBudget((v.getActualPlanVsBudget() == null ? BigDecimal.ZERO : v.getActualPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString());
            }
            strVoList.add(strVo);
        });
        return strVoList;
    }

    public LinkedHashMap<String, PromotionPlanResultVo> getStoreResult(PromotionPlanDto promotionPlan, List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos, List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos, String businessModel, String type) {
        currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthSaleDtos();
        currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthDeliveryDtos();
        purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList() : promotionPlan.getPurchaseSaleDtos();
        generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList() : promotionPlan.getGeneralExpensesDtos();
        otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList() : promotionPlan.getOtherExpensesDtos();
        return this.result(promotionPlan, currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, type, promotionPlan.getPlatformName());
    }

    public LinkedHashMap<String, PromotionPlanResultVo> getCahchResult(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, String type) {
        String businessModel = this.createValidate(promotionPlan);
        this.getCacheList2(promotionPlan, businessModel, cacheKeySale, cacheKeyDelivery, cacheKeyPurchase, cacheKeyGeneral, cacheKeyOther);
        ArrayList<CurrentMonthSaleDto> currentMonthSaleDtos = promotionPlan.getCurrentMonthSaleDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthSaleDtos();
        ArrayList<CurrentMonthDeliveryDto> currentMonthDeliveryDtos = promotionPlan.getCurrentMonthDeliveryDtos() == null ? new ArrayList() : promotionPlan.getCurrentMonthDeliveryDtos();
        ArrayList<PurchaseSaleDto> purchaseSaleDtos = promotionPlan.getPurchaseSaleDtos() == null ? new ArrayList() : promotionPlan.getPurchaseSaleDtos();
        ArrayList<GeneralExpensesDto> generalExpensesDtos = promotionPlan.getGeneralExpensesDtos() == null ? new ArrayList() : promotionPlan.getGeneralExpensesDtos();
        ArrayList<OtherExpensesDto> otherExpensesDtos = promotionPlan.getOtherExpensesDtos() == null ? new ArrayList() : promotionPlan.getOtherExpensesDtos();
        return this.result(promotionPlan, currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, type, promotionPlan.getPlatformName());
    }

    public LinkedHashMap<String, PromotionPlanResultVo> result(PromotionPlanDto promotionPlan, List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos, List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos, String businessModel, String type, String platformName) {
        LinkedHashMap<String, PromotionPlanResultVo> map = this.createPromotionPlanResultVoList(promotionPlan, type);
        this.resultPlan(currentMonthSaleDtos, currentMonthDeliveryDtos, purchaseSaleDtos, generalExpensesDtos, otherExpensesDtos, businessModel, map, type, platformName);
        this.resultProfitLoss(promotionPlan, businessModel, map, type);
        return map;
    }

    public void resultProfitLoss(PromotionPlanDto promotionPlan, String businessModel, LinkedHashMap<String, PromotionPlanResultVo> map, String type) {
        String customerCode;
        String month = DateUtil.format((Date)promotionPlan.getStartDate(), (String)"yyyy-MM");
        ActualProfitLossVo dtoA = new ActualProfitLossVo();
        BudgetProfitLossVo dtoB = new BudgetProfitLossVo();
        if ("\u5206\u9500\u6a21\u5f0f".equals(businessModel)) {
            dtoA.setDepartmentCode("2006279");
            dtoB.setDepartmentCode("2006279");
            Validate.notBlank((CharSequence)promotionPlan.getCustomerProfitLossCode(), (String)"\u6240\u5c5e\u9884\u7b97\u5ba2\u6237\u5fc5\u586b\uff01", (Object[])new Object[0]);
            customerCode = promotionPlan.getCustomerProfitLossCode();
        } else {
            customerCode = promotionPlan.getCustomerCode();
        }
        dtoA.setCustomerCode(customerCode);
        dtoB.setCustomerCode(customerCode);
        String[] split = month.split("-");
        String year = split[0];
        String yearBefore = String.valueOf(Integer.valueOf(split[0]) - 1);
        List aList = new ArrayList();
        List bList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            dtoA.setType(type);
            dtoB.setType(type);
            aList = this.actualProfitLossService.findProfitLoss(dtoA, this.getMonthList(yearBefore, split[1]));
            bList = this.budgetProfitLossService.findProfitLoss(dtoB, this.getMonthList(year, split[1]));
        }
        this.sumProfitLoss(aList, map, "actual", yearBefore + "-" + split[1], businessModel);
        this.sumProfitLoss(bList, map, "budget", month, businessModel);
    }

    private List<String> getMonthList(String year, String month) {
        ArrayList<String> monthList = new ArrayList<String>();
        int monthInt = Integer.parseInt(month);
        for (int i = 1; i <= monthInt; ++i) {
            if (i < 10) {
                monthList.add(year + "-0" + i);
                continue;
            }
            monthList.add(year + "-" + i);
        }
        return monthList;
    }

    public <T> void sumProfitLoss(List<T> list, LinkedHashMap<String, PromotionPlanResultVo> map, String type, String month, String businessModel) {
        Object specialCost;
        BigDecimal ton = BigDecimal.ZERO;
        BigDecimal discountBeforeSale = BigDecimal.ZERO;
        BigDecimal discountAfterSale = BigDecimal.ZERO;
        BigDecimal gmv = BigDecimal.ZERO;
        BigDecimal intensity = BigDecimal.ZERO;
        BigDecimal netIncome = BigDecimal.ZERO;
        BigDecimal cost = BigDecimal.ZERO;
        BigDecimal netProfit = BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal reimbursement = BigDecimal.ZERO;
        BigDecimal consumer = BigDecimal.ZERO;
        BigDecimal channel = BigDecimal.ZERO;
        BigDecimal put = BigDecimal.ZERO;
        BigDecimal platformOperate = BigDecimal.ZERO;
        BigDecimal feePool = BigDecimal.ZERO;
        BigDecimal market = BigDecimal.ZERO;
        BigDecimal logistics = BigDecimal.ZERO;
        BigDecimal admin = BigDecimal.ZERO;
        BigDecimal human = BigDecimal.ZERO;
        List<T> voList = list;
        Map<String, List<ProfitLossVo>> mapMonth = voList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthly()));
        List<ProfitLossVo> profitLossMonth = mapMonth.get(month);
        if (!CollectionUtils.isEmpty(profitLossMonth)) {
            for (ProfitLossVo vo : profitLossMonth) {
                ton = ton.add(this.bdNull(vo.getSalesTon()));
                discountBeforeSale = discountBeforeSale.add(this.bdNull(vo.getSaleAmount()));
                discountAfterSale = discountAfterSale.add(this.bdNull(vo.getSaleAmount()).subtract(this.bdNull(vo.getDiscountSub())));
                gmv = gmv.add(this.bdNull(vo.getGmv()));
                intensity = intensity.add(this.bdNull(vo.getIntensity()));
                netIncome = netIncome.add(this.bdNull(vo.getNetIncome()).add(this.bdNull(vo.getOthersAdd())));
                cost = cost.add(this.bdNull(vo.getDirectMaterial()));
                netProfit = netProfit.add(this.bdNull(vo.getNetProfit()));
                discount = discount.add(this.bdNull(vo.getSaleFeeSaleDiscount()));
                reimbursement = reimbursement.add(this.bdNull(vo.getSaleFeeReimburse()));
                consumer = consumer.add(this.bdNull(vo.getConsumer()));
                channel = channel.add(this.bdNull(vo.getChannel()));
                put = put.add(this.bdNull(vo.getPut()));
                platformOperate = platformOperate.add(this.bdNull(vo.getPlatformOperate()));
                feePool = feePool.add(this.bdNull(vo.getFeePool()));
                market = market.add(this.bdNull(vo.getSaleFeeMarketReimburseSub()));
                logistics = logistics.add(this.bdNull(vo.getTransportHandling()).add(this.bdNull(vo.getSaleFeeInventory())));
                admin = admin.add(this.bdNull(vo.getSaleFeeAdmin()).add(this.bdNull(vo.getManage())).add(this.bdNull(vo.getDevelopment())));
                human = human.add(this.bdNull(vo.getSaleFeeAdminHuman()).add(this.bdNull(vo.getManageHuman())).add(this.bdNull(vo.getDevelopmentHuman())));
            }
            if ("budget".equals(type)) {
                map.get(PromotionPlanResultProjectEnum.TON.getCode()).setBudget(ton);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setBudget(discountBeforeSale);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setBudget(discountAfterSale);
                map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setBudget(gmv);
                map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setBudget(intensity.divide(new BigDecimal(100), 3, 4));
                map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setBudget(netIncome);
                map.get(PromotionPlanResultProjectEnum.COST.getCode()).setBudget(cost);
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setBudget(netProfit);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setBudget(discount);
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setBudget(reimbursement);
                map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setBudget(consumer);
                map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setBudget(channel);
                map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setBudget(put);
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setBudget(platformOperate);
                map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setBudget(feePool);
                map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setBudget(market);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setBudget(logistics);
                map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setBudget(admin);
                map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setBudget(human);
                map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setBudget(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setBudget(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
                specialCost = BigDecimal.ZERO;
                specialCost = "\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setBudget((BigDecimal)specialCost);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setBudget(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setBudget(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(ton, 2, 4));
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setBudget(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
            } else {
                map.get(PromotionPlanResultProjectEnum.TON.getCode()).setContemporaneous(ton);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setContemporaneous(discountBeforeSale);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setContemporaneous(discountAfterSale);
                map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setContemporaneous(gmv);
                map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setContemporaneous(intensity.divide(new BigDecimal(100), 3, 4));
                map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setContemporaneous(netIncome);
                map.get(PromotionPlanResultProjectEnum.COST.getCode()).setContemporaneous(cost);
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setContemporaneous(netProfit);
                map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setContemporaneous(discount);
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setContemporaneous(reimbursement);
                map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setContemporaneous(consumer);
                map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setContemporaneous(channel);
                map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setContemporaneous(put);
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setContemporaneous(platformOperate);
                map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setContemporaneous(feePool);
                map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setContemporaneous(market);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setContemporaneous(logistics);
                map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setContemporaneous(admin);
                map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setContemporaneous(human);
                map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setContemporaneous(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
                map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setContemporaneous(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
                specialCost = BigDecimal.ZERO;
                specialCost = "\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setContemporaneous((BigDecimal)specialCost);
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setContemporaneous(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
                map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setContemporaneous(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(ton, 2, 4));
                map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setContemporaneous(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
            }
        }
        if (!CollectionUtils.isEmpty(profitLossMonth)) {
            voList.removeAll(profitLossMonth);
        }
        for (ProfitLossVo vo : voList) {
            ton = ton.add(this.bdNull(vo.getSalesTon()));
            discountBeforeSale = discountBeforeSale.add(this.bdNull(vo.getSaleAmount()));
            discountAfterSale = discountAfterSale.add(this.bdNull(vo.getSaleAmount()).subtract(this.bdNull(vo.getDiscountSub())));
            gmv = gmv.add(this.bdNull(vo.getGmv()));
            intensity = intensity.add(this.bdNull(vo.getIntensity()));
            netIncome = netIncome.add(this.bdNull(vo.getNetIncome()).add(this.bdNull(vo.getOthersAdd())));
            cost = cost.add(this.bdNull(vo.getDirectMaterial()));
            netProfit = netProfit.add(this.bdNull(vo.getNetProfit()));
            discount = discount.add(this.bdNull(vo.getSaleFeeSaleDiscount()));
            reimbursement = reimbursement.add(this.bdNull(vo.getSaleFeeReimburse()));
            consumer = consumer.add(this.bdNull(vo.getConsumer()));
            channel = channel.add(this.bdNull(vo.getChannel()));
            put = put.add(this.bdNull(vo.getPut()));
            platformOperate = platformOperate.add(this.bdNull(vo.getPlatformOperate()));
            feePool = feePool.add(this.bdNull(vo.getFeePool()));
            market = market.add(this.bdNull(vo.getSaleFeeMarketReimburseSub()));
            logistics = logistics.add(this.bdNull(vo.getTransportHandling()).add(this.bdNull(vo.getSaleFeeInventory())));
            admin = admin.add(this.bdNull(vo.getSaleFeeAdmin()).add(this.bdNull(vo.getManage())).add(this.bdNull(vo.getDevelopment())));
            human = human.add(this.bdNull(vo.getSaleFeeAdminHuman()).add(this.bdNull(vo.getManageHuman())).add(this.bdNull(vo.getDevelopmentHuman())));
        }
        if ("budget".equals(type)) {
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setBudgetTotal(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setBudgetTotal(discountBeforeSale);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setBudgetTotal(discountAfterSale);
            map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setBudgetTotal(gmv);
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setBudgetTotal(netIncome);
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setBudgetTotal(cost);
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setBudgetTotal(netProfit);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setBudgetTotal(discount);
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setBudgetTotal(reimbursement);
            map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setBudgetTotal(consumer);
            map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setBudgetTotal(channel);
            map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setBudgetTotal(put);
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setBudgetTotal(platformOperate);
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setBudgetTotal(feePool);
            map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setBudgetTotal(market);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setBudgetTotal(logistics);
            map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setBudgetTotal(admin);
            map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setBudgetTotal(human);
            map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setBudgetTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setBudgetTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
            specialCost = BigDecimal.ZERO;
            specialCost = "\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setBudgetTotal((BigDecimal)specialCost);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setBudgetTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setBudgetTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(ton, 2, 4));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setBudgetTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
        } else {
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setContemporaneousTotal(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setContemporaneousTotal(discountBeforeSale);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setContemporaneousTotal(discountAfterSale);
            map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setContemporaneousTotal(gmv);
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setContemporaneousTotal(netIncome);
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setContemporaneousTotal(cost);
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setContemporaneousTotal(netProfit);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setContemporaneousTotal(discount);
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setContemporaneousTotal(reimbursement);
            map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setContemporaneousTotal(consumer);
            map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setContemporaneousTotal(channel);
            map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setContemporaneousTotal(put);
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setContemporaneousTotal(platformOperate);
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setContemporaneousTotal(feePool);
            map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setContemporaneousTotal(market);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setContemporaneousTotal(logistics);
            map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setContemporaneousTotal(admin);
            map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setContemporaneousTotal(human);
            map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setContemporaneousTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setContemporaneousTotal(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
            specialCost = BigDecimal.ZERO;
            specialCost = "\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setContemporaneousTotal((BigDecimal)specialCost);
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setContemporaneousTotal(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
            map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setContemporaneousTotal(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(ton, 2, 4));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setContemporaneousTotal(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
        }
    }

    public void resultPlan(List<CurrentMonthSaleDto> currentMonthSaleDtos, List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos, List<PurchaseSaleDto> purchaseSaleDtos, List<GeneralExpensesDto> generalExpensesDtos, List<OtherExpensesDto> otherExpensesDtos, String businessModel, LinkedHashMap<String, PromotionPlanResultVo> map, String type, String platformName) {
        BigDecimal ton = BigDecimal.ZERO;
        BigDecimal discountBeforeSale = BigDecimal.ZERO;
        BigDecimal discountAfterSale = BigDecimal.ZERO;
        BigDecimal gmv = BigDecimal.ZERO;
        BigDecimal intensity = BigDecimal.ZERO;
        BigDecimal intensityTemp = BigDecimal.ZERO;
        BigDecimal tmall = BigDecimal.ZERO;
        BigDecimal netIncome = BigDecimal.ZERO;
        BigDecimal cost = BigDecimal.ZERO;
        BigDecimal netProfit = BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal reimbursement = BigDecimal.ZERO;
        BigDecimal consumer = BigDecimal.ZERO;
        BigDecimal channel = BigDecimal.ZERO;
        BigDecimal put = BigDecimal.ZERO;
        BigDecimal platformOperate = BigDecimal.ZERO;
        BigDecimal feePool = BigDecimal.ZERO;
        BigDecimal market = BigDecimal.ZERO;
        BigDecimal logistics = BigDecimal.ZERO;
        BigDecimal admin = BigDecimal.ZERO;
        BigDecimal human = BigDecimal.ZERO;
        BigDecimal feePoolDifference = BigDecimal.ZERO;
        BigDecimal feePoolSaleCommission = BigDecimal.ZERO;
        BigDecimal feePoolGrossProtection = BigDecimal.ZERO;
        BigDecimal feePoolPut = BigDecimal.ZERO;
        BigDecimal feePoolPurchaseRebate = BigDecimal.ZERO;
        BigDecimal consumerRD = BigDecimal.ZERO;
        BigDecimal channelRD = BigDecimal.ZERO;
        BigDecimal putRD = BigDecimal.ZERO;
        BigDecimal platformOperateRD = BigDecimal.ZERO;
        BigDecimal consumerOther = BigDecimal.ZERO;
        BigDecimal channelOther = BigDecimal.ZERO;
        BigDecimal putOther = BigDecimal.ZERO;
        BigDecimal platformOperateOther = BigDecimal.ZERO;
        BigDecimal purchaseRebate = BigDecimal.ZERO;
        BigDecimal saleCommission = BigDecimal.ZERO;
        for (GeneralExpensesDto generalExpensesDto : generalExpensesDtos) {
            if ("\u6d88\u8d39\u8005\u8d39\u7528".equals(generalExpensesDto.getBudgetItemName1())) {
                if ("\u7ea2\u5b57\u53d1\u7968".equals(generalExpensesDto.getAuditWayName()) || "\u6298\u6263".equals(generalExpensesDto.getAuditWayName())) {
                    consumerRD = consumerRD.add(generalExpensesDto.getApplyAmount());
                } else {
                    consumerOther = consumerOther.add(generalExpensesDto.getApplyAmount());
                }
            } else if ("\u6e20\u9053\u8d39\u7528".equals(generalExpensesDto.getBudgetItemName1())) {
                if ("\u7ea2\u5b57\u53d1\u7968".equals(generalExpensesDto.getAuditWayName()) || "\u6298\u6263".equals(generalExpensesDto.getAuditWayName())) {
                    channelRD = channelRD.add(generalExpensesDto.getApplyAmount());
                } else {
                    channelOther = channelOther.add(generalExpensesDto.getApplyAmount());
                }
                if ("\u5929\u732b\u8d85\u5e02".equals(platformName)) {
                    if ("\u91c7\u8d2d\u8fd4\u70b9".equals(generalExpensesDto.getBudgetItemName3())) {
                        purchaseRebate = purchaseRebate.add(generalExpensesDto.getApplyAmount());
                    } else if ("\u9500\u552e\u8fd4\u70b9".equals(generalExpensesDto.getBudgetItemName3())) {
                        saleCommission = saleCommission.add(generalExpensesDto.getApplyAmount());
                    }
                }
            } else if ("\u6295\u653e\u8d39\u7528".equals(generalExpensesDto.getBudgetItemName1())) {
                if ("\u7ea2\u5b57\u53d1\u7968".equals(generalExpensesDto.getAuditWayName()) || "\u6298\u6263".equals(generalExpensesDto.getAuditWayName())) {
                    putRD = putRD.add(generalExpensesDto.getApplyAmount());
                } else {
                    putOther = putOther.add(generalExpensesDto.getApplyAmount());
                }
            } else if ("\u5e73\u53f0\u8fd0\u8425\u8d39\u7528".equals(generalExpensesDto.getBudgetItemName1())) {
                if ("\u7ea2\u5b57\u53d1\u7968".equals(generalExpensesDto.getAuditWayName()) || "\u6298\u6263".equals(generalExpensesDto.getAuditWayName())) {
                    platformOperateRD = platformOperateRD.add(generalExpensesDto.getApplyAmount());
                } else {
                    platformOperateOther = platformOperateOther.add(generalExpensesDto.getApplyAmount());
                }
            }
            if (!"\u732b\u8d85\u5361".equals(generalExpensesDto.getActivityFormName())) continue;
            tmall = tmall.add(generalExpensesDto.getApplyAmount());
        }
        for (CurrentMonthSaleDto currentMonthSaleDto : currentMonthSaleDtos) {
            if (Objects.isNull(currentMonthSaleDto.getCombinationQuantity())) {
                currentMonthSaleDto.setCombinationQuantity(BigDecimal.ZERO);
            }
            if (Objects.isNull(currentMonthSaleDto.getActivityBasePrice())) {
                currentMonthSaleDto.setActivityBasePrice(BigDecimal.ZERO);
            }
            if (Objects.isNull(currentMonthSaleDto.getEstimatedSalesBox())) {
                currentMonthSaleDto.setEstimatedSalesBox(BigDecimal.ZERO);
            }
            if (Objects.isNull(currentMonthSaleDto.getStandardRetailPrice())) {
                currentMonthSaleDto.setStandardRetailPrice(BigDecimal.ZERO);
            }
            gmv = gmv.add(currentMonthSaleDto.getCombinationQuantity().multiply(currentMonthSaleDto.getActivityBasePrice()).multiply(currentMonthSaleDto.getEstimatedSalesBox()));
            intensityTemp = intensityTemp.add(currentMonthSaleDto.getStandardRetailPrice().multiply(currentMonthSaleDto.getCombinationQuantity()).multiply(currentMonthSaleDto.getEstimatedSalesBox()));
            logistics = logistics.add(currentMonthSaleDto.getLogistics() == null ? BigDecimal.ZERO : currentMonthSaleDto.getLogistics());
        }
        map.get(PromotionPlanResultProjectEnum.GMV.getCode()).setPlan(gmv.divide(new BigDecimal(1000), 3, 4));
        map.get(PromotionPlanResultProjectEnum.INTENSITY.getCode()).setPlan(intensityTemp.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : gmv.subtract(tmall).divide(intensityTemp, 4, 4));
        map.get(PromotionPlanResultProjectEnum.LOGISTICS.getCode()).setPlan(logistics.divide(new BigDecimal(1000), 3, 4));
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            if ("\u8d26\u9762".equals(type)) {
                for (CurrentMonthDeliveryDto currentMonthDeliveryDto : currentMonthDeliveryDtos) {
                    ton = ton.add(currentMonthDeliveryDto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : currentMonthDeliveryDto.getEstimatedSalesTon());
                    discountBeforeSale = discountBeforeSale.add(currentMonthDeliveryDto.getEstimatedAmount() == null ? BigDecimal.ZERO : currentMonthDeliveryDto.getEstimatedAmount());
                    netIncome = netIncome.add(currentMonthDeliveryDto.getNetIncome() == null ? BigDecimal.ZERO : currentMonthDeliveryDto.getNetIncome());
                    if (Objects.isNull(currentMonthDeliveryDto.getCombinationQuantity())) {
                        currentMonthDeliveryDto.setCombinationQuantity(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthDeliveryDto.getEstimatedSalesBox())) {
                        currentMonthDeliveryDto.setEstimatedSalesBox(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthDeliveryDto.getTaxRate())) {
                        currentMonthDeliveryDto.setTaxRate(BigDecimal.ZERO);
                    }
                    cost = cost.add((currentMonthDeliveryDto.getCostPrice() == null ? BigDecimal.ZERO : currentMonthDeliveryDto.getCostPrice()).multiply(currentMonthDeliveryDto.getCombinationQuantity()).multiply(currentMonthDeliveryDto.getEstimatedSalesBox()).divide(BigDecimal.ONE.add(this.bdNull(currentMonthDeliveryDto.getTaxRate())), 4, 4));
                    netProfit = netProfit.add(currentMonthDeliveryDto.getNetProfit() == null ? BigDecimal.ZERO : currentMonthDeliveryDto.getNetProfit());
                    if (Objects.isNull(currentMonthDeliveryDto.getDiscount())) {
                        currentMonthDeliveryDto.setDiscount(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthDeliveryDto.getSaleReimburse())) {
                        currentMonthDeliveryDto.setSaleReimburse(BigDecimal.ZERO);
                    }
                    discount = discount.add(currentMonthDeliveryDto.getDiscount());
                    reimbursement = reimbursement.add(currentMonthDeliveryDto.getSaleReimburse());
                }
            } else {
                for (CurrentMonthSaleDto currentMonthSaleDto : currentMonthSaleDtos) {
                    ton = ton.add(currentMonthSaleDto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : currentMonthSaleDto.getEstimatedSalesTon());
                    discountBeforeSale = discountBeforeSale.add(currentMonthSaleDto.getEstimatedAmountBefore() == null ? BigDecimal.ZERO : currentMonthSaleDto.getEstimatedAmountBefore());
                    netIncome = netIncome.add(currentMonthSaleDto.getNetIncome() == null ? BigDecimal.ZERO : currentMonthSaleDto.getNetIncome());
                    if (Objects.isNull(currentMonthSaleDto.getCombinationQuantity())) {
                        currentMonthSaleDto.setCombinationQuantity(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthSaleDto.getEstimatedSalesBox())) {
                        currentMonthSaleDto.setEstimatedSalesBox(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthSaleDto.getTaxRate())) {
                        currentMonthSaleDto.setTaxRate(BigDecimal.ZERO);
                    }
                    cost = cost.add((currentMonthSaleDto.getCostPrice() == null ? BigDecimal.ZERO : currentMonthSaleDto.getCostPrice()).multiply(currentMonthSaleDto.getCombinationQuantity()).multiply(currentMonthSaleDto.getEstimatedSalesBox()).divide(BigDecimal.ONE.add(this.bdNull(currentMonthSaleDto.getTaxRate())), 4, 4));
                    netProfit = netProfit.add(currentMonthSaleDto.getNetProfit() == null ? BigDecimal.ZERO : currentMonthSaleDto.getNetProfit());
                    if (Objects.isNull(currentMonthSaleDto.getDiscount())) {
                        currentMonthSaleDto.setDiscount(BigDecimal.ZERO);
                    }
                    if (Objects.isNull(currentMonthSaleDto.getSaleReimburse())) {
                        currentMonthSaleDto.setSaleReimburse(BigDecimal.ZERO);
                    }
                    discount = discount.add(currentMonthSaleDto.getDiscount());
                    reimbursement = reimbursement.add(currentMonthSaleDto.getSaleReimburse());
                }
            }
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setPlan(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setPlan(discountBeforeSale.divide(new BigDecimal(1000), 3, 4));
            discountAfterSale = discountBeforeSale.subtract(discount);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setPlan(discountAfterSale.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setPlan(netIncome.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setPlan(cost.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setPlan(netProfit.divide(new BigDecimal(1000), 3, 4));
            for (PurchaseSaleDto purchaseSaleDto : purchaseSaleDtos) {
                feePoolDifference = feePoolDifference.add(this.bdNull(purchaseSaleDto.getFeePoolDifference()));
                feePoolSaleCommission = feePoolSaleCommission.add(this.bdNull(purchaseSaleDto.getFeePoolSaleCommission()));
                feePoolGrossProtection = feePoolGrossProtection.add(this.bdNull(purchaseSaleDto.getFeePoolGrossProtection()));
                feePoolPut = feePoolPut.add(this.bdNull(purchaseSaleDto.getFeePoolPut()));
                feePoolPurchaseRebate = feePoolPurchaseRebate.add(this.bdNull(purchaseSaleDto.getFeePoolPurchaseRebate()));
            }
            if ("\u8d26\u9762".equals(type)) {
                feePool = feePool.add(feePoolDifference).add(feePoolSaleCommission).add(feePoolGrossProtection).add(feePoolPut);
            }
            map.get(PromotionPlanResultProjectEnum.FEE_POOL.getCode()).setPlan(feePool.divide(new BigDecimal("1.06"), 2, 4).divide(new BigDecimal(1000), 3, 4));
        } else if ("\u81ea\u8425\u6a21\u5f0f".equals(businessModel) || "\u5206\u9500\u6a21\u5f0f".equals(businessModel)) {
            for (CurrentMonthSaleDto currentMonthSaleDto : currentMonthSaleDtos) {
                ton = ton.add(currentMonthSaleDto.getEstimatedSalesTon() == null ? BigDecimal.ZERO : currentMonthSaleDto.getEstimatedSalesTon());
                discountBeforeSale = discountBeforeSale.add(currentMonthSaleDto.getEstimatedAmountBefore() == null ? BigDecimal.ZERO : currentMonthSaleDto.getEstimatedAmountBefore());
                netIncome = netIncome.add(currentMonthSaleDto.getNetIncome() == null ? BigDecimal.ZERO : currentMonthSaleDto.getNetIncome());
                cost = cost.add((currentMonthSaleDto.getCostPrice() == null ? BigDecimal.ZERO : currentMonthSaleDto.getCostPrice()).multiply(currentMonthSaleDto.getCombinationQuantity()).multiply(currentMonthSaleDto.getEstimatedSalesBox()).divide(BigDecimal.ONE.add(this.bdNull(currentMonthSaleDto.getTaxRate())), 4, 4));
                netProfit = netProfit.add(currentMonthSaleDto.getNetProfit() == null ? BigDecimal.ZERO : currentMonthSaleDto.getNetProfit());
                if (Objects.isNull(currentMonthSaleDto.getDiscount())) {
                    currentMonthSaleDto.setDiscount(BigDecimal.ZERO);
                }
                if (Objects.isNull(currentMonthSaleDto.getSaleReimburse())) {
                    currentMonthSaleDto.setSaleReimburse(BigDecimal.ZERO);
                }
                discount = discount.add(currentMonthSaleDto.getDiscount());
                reimbursement = reimbursement.add(currentMonthSaleDto.getSaleReimburse());
            }
            map.get(PromotionPlanResultProjectEnum.TON.getCode()).setPlan(ton);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_BEFORE_SALE.getCode()).setPlan(discountBeforeSale.divide(new BigDecimal(1000), 3, 4));
            discountAfterSale = discountBeforeSale.subtract(discount);
            map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).setPlan(discountAfterSale.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode()).setPlan(netIncome.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.COST.getCode()).setPlan(cost.divide(new BigDecimal(1000), 3, 4));
            map.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode()).setPlan(netProfit.divide(new BigDecimal(1000), 3, 4));
        } else {
            throw new RuntimeException("\u4e1a\u52a1\u6a21\u5f0f\u3010" + businessModel + "\u3011\u4e0d\u6b63\u786e");
        }
        map.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode()).setPlan(discount.divide(new BigDecimal(1000), 3, 4));
        map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).setPlan(reimbursement.divide(new BigDecimal(1000), 3, 4));
        consumer = consumerRD.add(consumerOther.subtract(feePoolDifference).divide(new BigDecimal("1.06"), 2, 4));
        map.get(PromotionPlanResultProjectEnum.CONSUMER.getCode()).setPlan(consumer.divide(new BigDecimal(1000), 3, 4));
        channel = channelRD.add(channelOther.subtract(feePoolSaleCommission.add(feePoolPurchaseRebate).add(feePoolGrossProtection)).divide(new BigDecimal("1.06"), 2, 4));
        if ("\u524d\u53f0".equals(type)) {
            channel = channel.subtract(purchaseRebate).subtract(saleCommission);
        }
        map.get(PromotionPlanResultProjectEnum.CHANNEL.getCode()).setPlan(channel.divide(new BigDecimal(1000), 3, 4));
        put = putRD.add(putOther.subtract(feePoolPut).divide(new BigDecimal("1.06"), 2, 4));
        map.get(PromotionPlanResultProjectEnum.PUT.getCode()).setPlan(put.divide(new BigDecimal(1000), 3, 4));
        platformOperate = platformOperateRD.add(platformOperateOther.divide(new BigDecimal("1.06"), 2, 4));
        map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE.getCode()).setPlan(platformOperate.divide(new BigDecimal(1000), 3, 4));
        if (!CollectionUtils.isEmpty(otherExpensesDtos)) {
            for (OtherExpensesDto otherExpensesDto : otherExpensesDtos) {
                market = market.add(otherExpensesDto.getMarketAmountPlan() == null ? BigDecimal.ZERO : otherExpensesDto.getMarketAmountPlan());
                admin = admin.add(otherExpensesDto.getAdminAmountPlan() == null ? BigDecimal.ZERO : otherExpensesDto.getAdminAmountPlan());
                human = human.add(otherExpensesDto.getHumanAmountPlan() == null ? BigDecimal.ZERO : otherExpensesDto.getHumanAmountPlan());
            }
        }
        map.get(PromotionPlanResultProjectEnum.MARKET.getCode()).setPlan(market.divide(new BigDecimal(1000), 3, 4));
        map.get(PromotionPlanResultProjectEnum.ADMIN.getCode()).setPlan(admin.divide(new BigDecimal(1000), 3, 4));
        map.get(PromotionPlanResultProjectEnum.HUMAN.getCode()).setPlan(human.divide(new BigDecimal(1000), 3, 4));
        map.get(PromotionPlanResultProjectEnum.GROSS_RATE.getCode()).setPlan(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
        map.get(PromotionPlanResultProjectEnum.DISCOUNT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : map.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode()).getPlan().divide(map.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode()).getPlan(), 4, 4));
        map.get(PromotionPlanResultProjectEnum.CONSUMERT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.CHANNEL_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.PUT_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.PLATFORM_OPERATE_RATE.getCode()).setPlan(discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
        BigDecimal specialCost = "\u91c7\u9500\u6a21\u5f0f".equals(businessModel) ? (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).add(feePool.divide(new BigDecimal("1.06"), 2, 4)).divide(discountAfterSale, 4, 4)) : (discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.add(channel).add(put).add(platformOperate).divide(discountAfterSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.SPECIAL_COST.getCode()).setPlan(specialCost);
        map.get(PromotionPlanResultProjectEnum.LOGISTICS_RATE.getCode()).setPlan(discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
        map.get(PromotionPlanResultProjectEnum.LOGISTICS_TON.getCode()).setPlan(ton.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(ton, 2, 4));
        map.get(PromotionPlanResultProjectEnum.NET_PROFIT_RATE.getCode()).setPlan(netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
    }

    private LinkedHashMap<String, PromotionPlanResultVo> createPromotionPlanResultVoList(PromotionPlanDto promotionPlan, String type) {
        LinkedHashMap<String, PromotionPlanResultVo> map = new LinkedHashMap<String, PromotionPlanResultVo>();
        List<HashMap<String, String>> enumListMap = this.getEnumListMap();
        enumListMap.forEach(e -> {
            PromotionPlanResultVo vo = new PromotionPlanResultVo(promotionPlan.getPromotionPlanCode(), promotionPlan.getPromotionPlanName(), promotionPlan.getStartDate(), promotionPlan.getEndDate(), (String)e.get("code"), (String)e.get("name"), type);
            vo.setTenantCode(TenantUtils.getTenantCode());
            map.put((String)e.get("code"), vo);
        });
        return map;
    }

    private List<HashMap<String, String>> getEnumListMap() {
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        for (PromotionPlanResultProjectEnum ppEnum : EnumSet.allOf(PromotionPlanResultProjectEnum.class)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ppEnum.getName());
            map.put("code", ppEnum.getCode());
            list.add(map);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monthBudgetHandle(PromotionPlanDto promotionPlan, String budgetOperationType) {
        List<GeneralExpensesDto> dtoList = this.generalExpensesRepository.findByPlanCode(promotionPlan.getPromotionPlanCode());
        List<GeneralExpensesDto> monthDtoList = dtoList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getMonthBudgetCode())).collect(Collectors.toList());
        List policyDtoList = dtoList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCommercePolicyCode())).collect(Collectors.toList());
        List<Object> monthBudgetVoList = new ArrayList();
        List<CurrentMonthSaleDto> saleList = this.currentMonthSaleRepository.findByPlanCode(promotionPlan.getPromotionPlanCode());
        if (!CollectionUtils.isEmpty(monthDtoList)) {
            monthBudgetVoList = this.getMonthBudgetHandle(monthDtoList, saleList);
        }
        boolean budgetLock = false;
        boolean policyLock = false;
        List monthCodeList = null;
        List businessPolicyCodeList = null;
        try {
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
                monthCodeList = monthBudgetVoList.stream().map(MonthBudgetVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
                budgetLock = this.monthBudgetLockService.lock(monthCodeList, TimeUnit.MINUTES, 3);
                Validate.isTrue((boolean)budgetLock, (String)"\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
                monthBudgetVoList.forEach(e -> this.monthBudgetService.operateBudget(e.getMonthBudgetCode(), e.getFeeRatio(), e.getUsedAmount(), budgetOperationType, e.getBusinessCode()));
            } else if (!CollectionUtils.isEmpty(policyDtoList)) {
                businessPolicyCodeList = policyDtoList.stream().map(GeneralExpensesDto::getCommercePolicyCode).distinct().collect(Collectors.toList());
                List policyList = this.businessPolicyService.findBusinessPolicyByCode(new HashSet(businessPolicyCodeList));
                policyLock = this.businessPolicyLockService.lock(businessPolicyCodeList, TimeUnit.MINUTES, 3);
                Validate.isTrue((boolean)policyLock, (String)"\u5546\u52a1\u653f\u7b56\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
                block3: for (BusinessPolicyVo policy : policyList) {
                    for (GeneralExpensesDto dto : policyDtoList) {
                        if (!dto.getCommercePolicyCode().equals(policy.getBusinessPolicyCode())) continue;
                        if (BudgetOperationTypeEnum.USE.getCode().equals(budgetOperationType)) {
                            BigDecimal subtract = policy.getApplyAmount().subtract(dto.getApplyAmount());
                            Validate.isTrue((subtract.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5546\u52a1\u653f\u7b56\u3010" + policy.getBusinessPolicyCode() + "\u3011\u7684\u7533\u8bf7\u91d1\u989d"), (Object[])new Object[0]);
                            policy.setAlreadyUseAmount(Optional.ofNullable(policy.getAlreadyUseAmount()).orElse(BigDecimal.ZERO).add(dto.getApplyAmount()));
                            continue block3;
                        }
                        policy.setAlreadyUseAmount(Optional.ofNullable(policy.getAlreadyUseAmount()).orElse(BigDecimal.ZERO).subtract(dto.getApplyAmount()));
                        continue block3;
                    }
                }
                this.businessPolicyService.updateBusinessPolicyApplyAmount(policyList);
            }
        }
        finally {
            if (budgetLock && CollectionUtil.isNotEmpty(monthCodeList)) {
                this.monthBudgetLockService.unLock(monthCodeList);
            }
            if (policyLock && CollectionUtil.isNotEmpty(businessPolicyCodeList)) {
                this.businessPolicyLockService.unlock(businessPolicyCodeList);
            }
        }
    }

    private void submitApprovalHandle(PromotionPlanDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getPromotionPlanCode());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("promotion_plan_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        PromotionPlanEntity entity = new PromotionPlanEntity();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.promotionPlanRepository.updateById((Object)entity);
    }

    public <T> void addGeneralCopy(List<GeneralExpensesDto> generateGeneralDtos, T dto, BigDecimal amount, String name) {
        if (amount != null && amount.compareTo(BigDecimal.ZERO) > 0) {
            GeneralExpensesDto generate = (GeneralExpensesDto)this.nebulaToolkitService.copyObjectByWhiteList(dto, GeneralExpensesDto.class, HashSet.class, ArrayList.class, new String[0]);
            generate.setApplyAmount(amount);
            generate.setBeGenerate(Boolean.TRUE);
            generate.setId(UUID.randomUUID().toString().replace("-", ""));
            generate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            generate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            ActivityTypeVo activityTypeVo = this.activityTypeService.getActivityTypeByActivityTypeName(name);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityTypeVo.getActivityTypeRelationDtoList()) ? 1 : 0) != 0, (String)("\u3010" + name + "\u3011\u6d3b\u52a8\u7c7b\u578b\u5173\u8054\u4e3a\u7a7a"), (Object[])new Object[0]);
            generate.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
            generate.setActivityTypeName(activityTypeVo.getActivityTypeName());
            ActivityTypeRelationDto activityTypeRelationDto = activityTypeVo.getActivityTypeRelationDtoList().stream().filter(o -> o.getBusinessUnitCode().equals(BusinessUnitEnum.ONLINE.getCode())).findFirst().orElse(null);
            Validate.notNull((Object)activityTypeRelationDto, (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + name + "\u3011,\u5728\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406\u4e2d\uff0c\u672a\u7ef4\u62a4\u4e1a\u52a1\u5355\u5143\u4e3a" + BusinessUnitEnum.ONLINE.getCode() + "\u7684\u5173\u8054\u4fe1\u606f\u6570\u636e\uff01"), (Object[])new Object[0]);
            Validate.notEmpty((Collection)activityTypeRelationDto.getActivityTypeFormDtoList(), (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + name + "\u3011\uff0c\u5728\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406\u4e2d,\u672a\u7ef4\u62a4\u4e1a\u52a1\u5355\u5143\u4e3a" + BusinessUnitEnum.ONLINE.getCode() + "\u7684\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u6570\u636e\uff01"), (Object[])new Object[0]);
            List activityTypeFormDtoList = activityTypeRelationDto.getActivityTypeFormDtoList();
            ActivityTypeFormDto activityTypeFormDto = activityTypeFormDtoList.stream().filter(e -> name.equals(e.getActivityFormName())).findFirst().orElse(null);
            Validate.notNull((Object)activityTypeFormDto, (String)("\u3010" + name + "\u3011\u7684\u6d3b\u52a8\u5f62\u5f0f\u672a\u7ef4\u62a4"), (Object[])new Object[0]);
            generate.setActivityFormCode(activityTypeFormDto.getActivityFormCode());
            generate.setActivityFormName(activityTypeFormDto.getActivityFormName());
            generate.setYearMonthLy(DateUtil.format((Date)generate.getStartDate(), (String)"yyyy-MM"));
            generateGeneralDtos.add(generate);
        }
    }

    public void addGeneral(List<GeneralExpensesDto> generateGeneralDtos, PromotionPlanDto promotionPlan, BigDecimal amount, String typeCode, String fromCode, String customerCode, String customerName) {
        this.addGeneral(generateGeneralDtos, promotionPlan, amount, typeCode, fromCode, customerCode, customerName, null, null);
    }

    public void addGeneral(List<GeneralExpensesDto> generateGeneralDtos, PromotionPlanDto promotionPlan, BigDecimal amount, String typeCode, String fromCode, String customerCode, String customerName, String channelCode, String channelName) {
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            GeneralExpensesDto generate = new GeneralExpensesDto();
            generate.setApplyAmount(amount);
            generate.setStartDate(promotionPlan.getStartDate());
            generate.setEndDate(promotionPlan.getEndDate());
            generate.setCustomerCode(customerCode);
            generate.setCustomerName(customerName);
            generate.setBeGenerate(Boolean.TRUE);
            generate.setId(UUID.randomUUID().toString().replace("-", ""));
            generate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            generate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            ActivityTypeVo activityTypeVo = this.activityTypeService.getActivityTypeByActivityTypeCode(typeCode);
            Validate.notNull((Object)activityTypeVo, (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + typeCode + "\u3011\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u7c7b\u578b"), (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityTypeVo.getActivityTypeRelationDtoList()) ? 1 : 0) != 0, (String)("\u3010" + typeCode + "\u3011\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406\u4e2d\uff0c\u672a\u7ef4\u62a4\u5173\u8054\u4fe1\u606f"), (Object[])new Object[0]);
            generate.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
            generate.setActivityTypeName(activityTypeVo.getActivityTypeName());
            ActivityTypeRelationDto activityTypeRelationDto = activityTypeVo.getActivityTypeRelationDtoList().stream().filter(o -> o.getBusinessUnitCode().equals(BusinessUnitEnum.ONLINE.getCode())).findFirst().orElse(null);
            Validate.notNull((Object)activityTypeRelationDto, (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + typeCode + "\u3011,\u5728\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406\u4e2d\uff0c\u672a\u7ef4\u62a4\u4e1a\u52a1\u5355\u5143\u4e3a" + BusinessUnitEnum.ONLINE.getCode() + "\u7684\u5173\u8054\u4fe1\u606f\u6570\u636e\uff01"), (Object[])new Object[0]);
            Validate.notEmpty((Collection)activityTypeRelationDto.getActivityTypeFormDtoList(), (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + typeCode + "\u3011\uff0c\u5728\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406\u4e2d,\u672a\u7ef4\u62a4\u4e1a\u52a1\u5355\u5143\u4e3a" + BusinessUnitEnum.ONLINE.getCode() + "\u7684\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u6570\u636e\uff01"), (Object[])new Object[0]);
            List activityTypeFormDtoList = activityTypeRelationDto.getActivityTypeFormDtoList();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityTypeFormDtoList) ? 1 : 0) != 0, (String)("\u3010" + typeCode + "\u3011\u7684\u6d3b\u52a8\u5f62\u5f0f\u672a\u7ef4\u62a4"), (Object[])new Object[0]);
            ActivityTypeFormDto activityTypeFormDto = activityTypeFormDtoList.stream().filter(e -> fromCode.equals(e.getActivityFormCode())).findFirst().orElse(null);
            Validate.notNull((Object)activityTypeFormDto, (String)("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u3010" + typeCode + "\u3011\uff0c\u5728\u6d3b\u52a8\u5206\u7c7b\u7ba1\u7406,\u4e1a\u52a1\u5355\u5143\u4e3a" + BusinessUnitEnum.ONLINE.getCode() + "\u7684\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u6570\u636e\u4e0a\uff0c\u672a\u5173\u8054\u3010" + fromCode + "\u3011\u7684\u6d3b\u52a8\u5f62\u5f0f"), (Object[])new Object[0]);
            generate.setActivityFormCode(activityTypeFormDto.getActivityFormCode());
            generate.setActivityFormName(activityTypeFormDto.getActivityFormName());
            generate.setYearMonthLy(DateUtil.format((Date)generate.getStartDate(), (String)"yyyy-MM"));
            generate.setChannelCode(channelCode);
            generate.setChannelName(channelName);
            generateGeneralDtos.add(generate);
        }
    }

    private String createValidate(PromotionPlanDto promotionPlan) {
        Validate.notNull((Object)promotionPlan, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.commonValidate(promotionPlan);
    }

    private String updateValidate(PromotionPlanDto promotionPlan) {
        Validate.notNull((Object)promotionPlan, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPlan.getId(), (String)"\u4fee\u6539\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.commonValidate(promotionPlan);
    }

    private String commonValidate(PromotionPlanDto promotionPlan) {
        Validate.notBlank((CharSequence)promotionPlan.getPromotionPlanName(), (String)"\u4fc3\u9500\u89c4\u5212\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)promotionPlan.getStartDate(), (String)"\u4fc3\u9500\u89c4\u5212\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)promotionPlan.getEndDate(), (String)"\u4fc3\u9500\u89c4\u5212\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPlan.getBusinessModelCode(), (String)"\u4e1a\u52a1\u6a21\u5f0f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPlan.getSalesOrgCode(), (String)"\u9500\u552e\u673a\u6784\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPlan.getBusinessFormatCode(), (String)"\u4e1a\u6001\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.getBusinessModelName(promotionPlan.getBusinessModelCode());
    }

    private String getBusinessModelName(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u4e1a\u52a1\u6a21\u5f0f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DictDataVo dictDataVo = this.dictDataVoService.findByDictTypeCode("mdm_business_model").stream().filter(e -> code.equals(e.getDictCode())).findFirst().orElse(null);
        Validate.notNull((Object)dictDataVo, (String)"\u6570\u636e\u5b57\u5178\uff1a\u4e1a\u52a1\u6a21\u5f0f\uff0c\u672a\u7ef4\u62a4", (Object[])new Object[0]);
        return dictDataVo.getDictValue();
    }

    public void detailsValidate(PromotionPlanDto promotionPlan, String businessModel) {
        if ("\u91c7\u9500\u6a21\u5f0f".equals(businessModel)) {
            Validate.notBlank((CharSequence)promotionPlan.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)promotionPlan.getPlatformCode(), (String)"\u5e73\u53f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.deliveryValidate(promotionPlan.getCurrentMonthDeliveryDtos(), promotionPlan.getPlatformName());
            this.purchaseValidate(promotionPlan.getPurchaseSaleDtos());
        } else if ("\u81ea\u8425\u6a21\u5f0f".equals(businessModel)) {
            Validate.notBlank((CharSequence)promotionPlan.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)promotionPlan.getPlatformCode(), (String)"\u5e73\u53f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if (!"\u5206\u9500\u6a21\u5f0f".equals(businessModel)) {
            throw new RuntimeException("\u4e1a\u52a1\u6a21\u5f0f\u3010" + businessModel + "\u3011\u4e0d\u6b63\u786e");
        }
        this.expensesValidate(promotionPlan.getGeneralExpensesDtos());
        this.saleValidate(promotionPlan.getCurrentMonthSaleDtos(), promotionPlan.getPlatformName());
        this.otherValidate(promotionPlan.getOtherExpensesDtos());
    }

    public void expensesValidate(List<GeneralExpensesDto> dtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtos) ? 1 : 0) != 0, (String)"\u8d39\u7528\u7533\u8bf7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.forEach(e -> {
            Validate.notBlank((CharSequence)e.getActivityTypeCode(), (String)"\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getApplyAmount(), (String)"\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getAuditWayCode(), (String)"\u7ed3\u6848\u65b9\u5f0f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getAuditConditionType(), (String)"\u6838\u9500\u6761\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getYearMonthLy(), (String)"\u8d39\u7528\u5f52\u5c5e\u5e74\u6708\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!(!StringUtils.isNotBlank((CharSequence)e.getCommercePolicyCode()) && !StringUtils.isNotBlank((CharSequence)e.getMonthBudgetCode()) || StringUtils.isNotBlank((CharSequence)e.getCommercePolicyCode()) && StringUtils.isNotBlank((CharSequence)e.getMonthBudgetCode())) ? 1 : 0) != 0, (String)"\u5546\u52a1\u653f\u7b56\u548c\u9884\u7b97\u6709\u4e14\u53ea\u80fd\u586b\u5199\u4e00\u9879", (Object[])new Object[0]);
        });
    }

    public void saleValidate(List<CurrentMonthSaleDto> dtos, String platformName) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank((CharSequence)e.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductBrandCode(), (String)"\u54c1\u724c\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getTaxRate(), (String)"\u7a0e\u7387\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getRatio(), (String)"\u7cfb\u6570\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getStandardRetailPrice(), (String)"\u6807\u51c6\u96f6\u552e\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getPlatformSupplyPrice(), (String)"\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getActivityBasePrice(), (String)"\u6d3b\u52a8\u5e95\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getCombinationQuantity(), (String)"\u7ec4\u5408\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getPromotionTypeCode(), (String)"\u4fc3\u9500\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getEstimatedSalesBox(), (String)"\u9884\u8ba1\u9500\u91cf\uff08\u7bb1\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            e.setEstimatedAmountBefore(e.getCombinationQuantity().multiply(e.getPlatformSupplyPrice()).multiply(e.getEstimatedSalesBox()).setScale(2, RoundingMode.HALF_UP));
            if ("\u4eac\u4e1c\u5546\u57ce".equals(platformName)) {
                e.setJd(e.getEstimatedAmountBefore().multiply(new BigDecimal("0.06")).setScale(2, RoundingMode.HALF_UP));
            }
        });
    }

    public void deliveryValidate(List<CurrentMonthDeliveryDto> dtos, String platformName) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank((CharSequence)e.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductBrandCode(), (String)"\u54c1\u724c\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getTaxRate(), (String)"\u7a0e\u7387\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getRatio(), (String)"\u7cfb\u6570\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getStandardRetailPrice(), (String)"\u6807\u51c6\u96f6\u552e\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getPlatformSupplyPrice(), (String)"\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getCombinationQuantity(), (String)"\u7ec4\u5408\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getEstimatedSalesBox(), (String)"\u9884\u8ba1\u9500\u91cf\uff08\u7bb1\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getEstimatedSalesTon(), (String)"\u9884\u8ba1\u9500\u91cf\uff08\u5428\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.currentMonthDeliveryService.calculationFee(e, platformName);
        });
    }

    public void purchaseValidate(List<PurchaseSaleDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notBlank((CharSequence)e.getProductBrandCode(), (String)"\u54c1\u724c\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getStandardRetailPrice(), (String)"\u6807\u51c6\u96f6\u552e\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getSupplyPrice(), (String)"\u4f9b\u8d27\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getPromotionPrice(), (String)"\u4fc3\u9500\u552e\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getMonthInventoryEnd(), (String)"\u672c\u6708\u671f\u672b\u5e93\u5b58\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    public void otherValidate(List<OtherExpensesDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(e -> {
            Validate.notNull((Object)e.getAdminAmountBudget(), (String)"\u884c\u653f\u7ba1\u7406\u8d39\u7528-\u9884\u7b97\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getAdminAmountPlan(), (String)"\u884c\u653f\u7ba1\u7406\u8d39\u7528-\u89c4\u5212\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getHumanAmountBudget(), (String)"\u4eba\u529b\u6210\u672c-\u9884\u7b97\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getHumanAmountPlan(), (String)"\u4eba\u529b\u6210\u672c-\u89c4\u5212\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getMarketAmountBudget(), (String)"\u5e02\u573a\u8d39\u7528-\u9884\u7b97\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getMarketAmountPlan(), (String)"\u5e02\u573a\u8d39\u7528-\u89c4\u5212\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    public List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(CurrentMonthSaleDto dto) {
        return this.currentMonthSaleRepository.findCustomerProductMonthSaleSumList(dto);
    }
}

