/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanTableForm;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanTableFormRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanResultProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanTableFormService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanParamVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="promotionPlanTableFormService")
public class PromotionPlanTableFormServiceImpl
implements PromotionPlanTableFormService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanTableFormServiceImpl.class);
    @Autowired(required=false)
    private PromotionPlanResultRepository promotionPlanResultRepository;
    @Autowired(required=false)
    private PromotionPlanTableFormRepository promotionPlanTableFormRepository;
    @Autowired(required=false)
    private ActualProfitLossService actualProfitLossService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;
    @Autowired(required=false)
    private PromotionPlanRepository promotionPlanRepository;

    @Transactional(rollbackFor={Exception.class})
    public void createDataSummary(String date) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            date = DateUtil.getDate((String)"yyyy-MM-dd");
        }
        List<Object> planResultList = new ArrayList();
        planResultList = this.promotionPlanResultRepository.getAllByDate(date, "\u8d26\u9762", ProcessStatusEnum.PASS.getDictCode());
        if (CollectionUtils.isEmpty(planResultList)) {
            log.info("\u672c\u6b21\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u6c42\u7ed3\u675f!");
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        log.info("\u5f00\u59cb\u6784\u5efa\u6570\u636e\uff0c\u67e5\u8be2\u6570\u636e\u91cf\u4e3a:{}", (Object)planResultList.size());
        Map<String, List<PromotionPlanParamVo>> groupMap = planResultList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getOrgCode()) && StringUtils.isNotEmpty((CharSequence)vo.getStartDate()) && StringUtils.isNotEmpty((CharSequence)vo.getPlatformCode())).collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getOrgCode(), vo.getPlatformCode(), vo.getStartDate().substring(0, 7)})));
        log.info("\u90e8\u95e8+\u5e73\u53f0+\u5e74\u6708\u6c47\u603b\u540e\u6570\u636e\u91cf\u4e3a{}", (Object)groupMap.entrySet().size());
        ArrayList<PromotionPlanTableForm> list = new ArrayList<PromotionPlanTableForm>();
        for (Map.Entry<String, List<PromotionPlanParamVo>> key : groupMap.entrySet()) {
            List<PromotionPlanParamVo> value = key.getValue();
            PromotionPlanParamVo promotionPlanParam = value.get(0);
            Map<String, List<PromotionPlanParamVo>> projectMap = value.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getProjectCode())).collect(Collectors.groupingBy(PromotionPlanParamVo::getProjectCode));
            List netIncome = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.NET_INCOME.getCode())).orElse(new ArrayList());
            BigDecimal netIncomeContemporaneous = BigDecimal.ZERO;
            BigDecimal netIncomeBudget = BigDecimal.ZERO;
            BigDecimal netIncomePlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : netIncome) {
                if (StringUtils.equals((CharSequence)promotionPlanParamVo.getBusinessModelCode(), (CharSequence)"distribution_mode")) {
                    netIncomeContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    netIncomeBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                } else {
                    netIncomeContemporaneous = netIncomeContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    netIncomeBudget = netIncomeBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                netIncomePlan = netIncomePlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            BigDecimal incomeAchievement = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                incomeAchievement = netIncomePlan.divide(netIncomeBudget, 6, 4);
            }
            BigDecimal vsContemporaneous = netIncomePlan.subtract(netIncomeContemporaneous);
            BigDecimal vsBudget = netIncomePlan.subtract(netIncomeBudget);
            List disCount = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.DISCOUNT.getCode())).orElse(new ArrayList());
            BigDecimal disCountContemporaneous = BigDecimal.ZERO;
            Object disCountBudget = BigDecimal.ZERO;
            BigDecimal disCountPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : disCount) {
                if (StringUtils.equals((CharSequence)promotionPlanParamVo.getBusinessModelCode(), (CharSequence)"distribution_mode")) {
                    disCountContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    disCountBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                } else {
                    disCountContemporaneous = disCountContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    disCountBudget = ((BigDecimal)disCountBudget).add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                disCountPlan = disCountPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            List reimbursement = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode())).orElse(new ArrayList());
            BigDecimal reimbursementContemporaneous = BigDecimal.ZERO;
            BigDecimal reimbursementBudget = BigDecimal.ZERO;
            BigDecimal reimbursementPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : reimbursement) {
                if (StringUtils.equals((CharSequence)promotionPlanParamVo.getBusinessModelCode(), (CharSequence)"distribution_mode")) {
                    reimbursementContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    reimbursementBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                } else {
                    reimbursementContemporaneous = reimbursementContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    reimbursementBudget = reimbursementBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                reimbursementPlan = reimbursementPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            List discountAfterSale = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode())).orElse(new ArrayList());
            BigDecimal discountAfterSaleContemporaneous = BigDecimal.ZERO;
            BigDecimal discountAfterSaleBudget = BigDecimal.ZERO;
            BigDecimal discountAfterSalePlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : discountAfterSale) {
                if (StringUtils.equals((CharSequence)promotionPlanParamVo.getBusinessModelCode(), (CharSequence)"distribution_mode")) {
                    discountAfterSaleContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    discountAfterSaleBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                } else {
                    discountAfterSaleContemporaneous = discountAfterSaleContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    discountAfterSaleBudget = discountAfterSaleBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                discountAfterSalePlan = discountAfterSalePlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            BigDecimal contemporaneousSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSaleContemporaneous) != 0) {
                contemporaneousSpecialExpenseRate = disCountContemporaneous.add(reimbursementContemporaneous).divide(discountAfterSaleContemporaneous, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal budgetSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSaleBudget) != 0) {
                budgetSpecialExpenseRate = ((BigDecimal)disCountBudget).add(reimbursementBudget).divide(discountAfterSaleBudget, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal planSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(discountAfterSalePlan) != 0) {
                planSpecialExpenseRate = disCountPlan.add(reimbursementPlan).divide(discountAfterSalePlan, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal expenseRateVsContemporaneous = planSpecialExpenseRate.subtract(contemporaneousSpecialExpenseRate);
            BigDecimal expenseRateVsBudget = planSpecialExpenseRate.subtract(budgetSpecialExpenseRate);
            List netProfit = Optional.ofNullable(projectMap.get(PromotionPlanResultProjectEnum.NET_PROFIT.getCode())).orElse(new ArrayList());
            BigDecimal netProfitContemporaneous = BigDecimal.ZERO;
            BigDecimal netProfitBudget = BigDecimal.ZERO;
            BigDecimal netProfitPlan = BigDecimal.ZERO;
            for (PromotionPlanParamVo promotionPlanParamVo : netProfit) {
                if (StringUtils.equals((CharSequence)promotionPlanParamVo.getBusinessModelCode(), (CharSequence)"distribution_mode")) {
                    netProfitContemporaneous = Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO);
                    netProfitBudget = Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO);
                } else {
                    netProfitContemporaneous = netProfitContemporaneous.add(Optional.ofNullable(promotionPlanParamVo.getContemporaneous()).orElse(BigDecimal.ZERO));
                    netProfitBudget = netProfitBudget.add(Optional.ofNullable(promotionPlanParamVo.getBudget()).orElse(BigDecimal.ZERO));
                }
                netProfitPlan = netProfitPlan.add(Optional.ofNullable(promotionPlanParamVo.getPlan()).orElse(BigDecimal.ZERO));
            }
            BigDecimal budgetProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                budgetProfitMargin = netProfitBudget.divide(netIncomeBudget, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal plannedProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomePlan) != 0) {
                plannedProfitMargin = netProfitPlan.divide(netIncomePlan, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal profitMarginReached = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetProfitMargin) != 0) {
                profitMarginReached = plannedProfitMargin.divide(budgetProfitMargin, 6, 4).multiply(new BigDecimal(100));
            }
            log.info("\u5f00\u59cb\u6784\u5efa\u6570\u636e!");
            PromotionPlanTableForm promotionPlanTableForm = new PromotionPlanTableForm();
            promotionPlanTableForm.setOnlyKey(key.getKey());
            promotionPlanTableForm.setTenantCode(tenantCode);
            promotionPlanTableForm.setDelFlag(delFlag);
            promotionPlanTableForm.setSalesDepartmentCode(promotionPlanParam.getSalesDepartmentCode());
            promotionPlanTableForm.setSalesDepartmentName(promotionPlanParam.getSalesDepartmentName());
            promotionPlanTableForm.setOrgCode(promotionPlanParam.getOrgCode());
            promotionPlanTableForm.setOrgName(promotionPlanParam.getOrgName());
            promotionPlanTableForm.setPlatformCode(promotionPlanParam.getPlatformCode());
            promotionPlanTableForm.setPlatformName(promotionPlanParam.getPlatformName());
            promotionPlanTableForm.setYearAndMonth(promotionPlanParam.getStartDate().substring(0, 7));
            promotionPlanTableForm.setNetIncomeContemporaneous(netIncomeContemporaneous);
            promotionPlanTableForm.setNetIncomeBudget(netIncomeBudget);
            promotionPlanTableForm.setNetIncomePlan(netIncomePlan);
            promotionPlanTableForm.setIncomeAchievement(incomeAchievement);
            promotionPlanTableForm.setVsContemporaneous(vsContemporaneous);
            promotionPlanTableForm.setVsBudget(vsBudget);
            promotionPlanTableForm.setContemporaneousSpecialExpenseRate(contemporaneousSpecialExpenseRate);
            promotionPlanTableForm.setBudgetSpecialExpenseRate(budgetSpecialExpenseRate);
            promotionPlanTableForm.setPlanSpecialExpenseRate(planSpecialExpenseRate);
            promotionPlanTableForm.setExpenseRateVsContemporaneous(expenseRateVsContemporaneous);
            promotionPlanTableForm.setExpenseRateVsBudget(expenseRateVsBudget);
            promotionPlanTableForm.setBudgetNetProfit(netProfitBudget);
            promotionPlanTableForm.setPlannedNetProfit(netProfitPlan);
            promotionPlanTableForm.setContemporaneousNetProfit(netProfitContemporaneous);
            promotionPlanTableForm.setBudgetProfitMargin(budgetProfitMargin);
            promotionPlanTableForm.setPlannedProfitMargin(plannedProfitMargin);
            promotionPlanTableForm.setProfitMarginReached(profitMarginReached);
            promotionPlanTableForm.setLevelCode("1");
            list.add(promotionPlanTableForm);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate((String)date, (String)"yyyy-MM-dd"));
        calendar.add(1, -1);
        String lastYearNowMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        calendar.set(2, 0);
        calendar.set(5, 1);
        String lastYearOneMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String nowDate = DateUtil.getFirstDayOfMonth((String)date);
        PromotionPlanDto promotionPlanDto = new PromotionPlanDto();
        promotionPlanDto.setStartDateStr(nowDate);
        promotionPlanDto.setEndDateStr(nowDate);
        promotionPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List promotionPlanVoList = Optional.ofNullable(this.promotionPlanRepository.findByDateConditions(promotionPlanDto)).orElse(new ArrayList());
        if (CollectionUtil.isEmpty((Collection)promotionPlanVoList)) {
            return;
        }
        ActualProfitLossVo dto = new ActualProfitLossVo();
        dto.setType("\u8d26\u9762");
        dto.setBeginDate(lastYearOneMonth.substring(0, 7));
        dto.setEndDate(nowDate.substring(0, 7));
        List profitLoss = Optional.ofNullable(this.actualProfitLossService.findProfitLossByDto(dto)).orElse(new ArrayList());
        log.info("\u90e8\u95e8\u7ef4\u5ea6\u67e5\u8be2\u635f\u76ca\u8868-\u5b9e\u9645\u7684\u6570\u636e\u91cf\u4e3a:{}", (Object)profitLoss.size());
        Map<Object, Object> actualProfitLossMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)profitLoss)) {
            actualProfitLossMap = profitLoss.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getDepartmentCode())).collect(Collectors.groupingBy(ProfitLossVo::getDepartmentCode));
        }
        BudgetProfitLossVo budgetDto = new BudgetProfitLossVo();
        budgetDto.setType("\u8d26\u9762");
        budgetDto.setBeginDate(lastYearOneMonth.substring(0, 7));
        budgetDto.setEndDate(nowDate.substring(0, 7));
        List profitLossByDto = Optional.ofNullable(this.budgetProfitLossService.findProfitLossByDto(budgetDto)).orElse(new ArrayList());
        log.info("\u90e8\u95e8\u7ef4\u5ea6\u67e5\u8be2\u635f\u76ca\u8868-\u9884\u7b97\u7684\u6570\u636e\u91cf\u4e3a:{}", (Object)profitLossByDto.size());
        Map<Object, Object> budgetProfitLossMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)profitLossByDto)) {
            budgetProfitLossMap = profitLossByDto.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getDepartmentCode())).collect(Collectors.groupingBy(ProfitLossVo::getDepartmentCode));
        }
        Map planMap = new HashMap();
        if (CollectionUtil.isNotEmpty(list)) {
            planMap = Optional.ofNullable(list.stream().collect(Collectors.groupingBy(PromotionPlanTableForm::getOrgCode))).orElse(new HashMap());
        }
        Map<String, List<PromotionPlanParamVo>> planSalesDepartmentMap = planResultList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getOrgCode())).collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getOrgCode()})));
        for (PromotionPlanVo promotionPlanVo : promotionPlanVoList) {
            String salesDepartmentCode = promotionPlanVo.getOrgCode();
            List actualProfitLossVos = (List)actualProfitLossMap.get(salesDepartmentCode);
            List budgetProfitLossVos = (List)budgetProfitLossMap.get(salesDepartmentCode);
            List<PromotionPlanParamVo> promotionPlanParamVos = planSalesDepartmentMap.get(salesDepartmentCode);
            PromotionPlanTableForm promotionPlanTableForm = new PromotionPlanTableForm();
            promotionPlanTableForm.setId(null);
            BigDecimal netIncomeContemporaneous = BigDecimal.ZERO;
            BigDecimal netIncomeBudget = BigDecimal.ZERO;
            BigDecimal netIncomePlan = BigDecimal.ZERO;
            BigDecimal disCountContemporaneous = BigDecimal.ZERO;
            BigDecimal disCountBudget = BigDecimal.ZERO;
            BigDecimal disCountPlan = BigDecimal.ZERO;
            BigDecimal reimbursementContemporaneous = BigDecimal.ZERO;
            BigDecimal reimbursementBudget = BigDecimal.ZERO;
            BigDecimal reimbursementPlan = BigDecimal.ZERO;
            BigDecimal salesContemporaneous = BigDecimal.ZERO;
            BigDecimal salesBudget = BigDecimal.ZERO;
            BigDecimal salesPlan = BigDecimal.ZERO;
            BigDecimal disCountSubContemporaneous = BigDecimal.ZERO;
            BigDecimal disCountSubBudget = BigDecimal.ZERO;
            BigDecimal netProfitContemporaneous = BigDecimal.ZERO;
            BigDecimal netProfitBudget = BigDecimal.ZERO;
            BigDecimal netProfitPlan = BigDecimal.ZERO;
            BigDecimal othersAddContemporaneous = BigDecimal.ZERO;
            BigDecimal othersAddBudget = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty((Collection)actualProfitLossVos)) {
                Map<String, List<ActualProfitLossVo>> actualProfitLossYearMonthMap = actualProfitLossVos.stream().collect(Collectors.groupingBy(ProfitLossVo::getYearMonthly));
                List lastYearMonthNowList = Optional.ofNullable(actualProfitLossYearMonthMap.get(lastYearNowMonth.substring(0, 7))).orElse(new ArrayList());
                netIncomeContemporaneous = netIncomeContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getNetIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                disCountContemporaneous = disCountContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getSaleFeeSaleDiscount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                reimbursementContemporaneous = reimbursementContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getSaleFeeReimburse).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                salesContemporaneous = salesContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                disCountSubContemporaneous = disCountSubContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getDiscountSub).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                netProfitContemporaneous = netProfitContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                othersAddContemporaneous = othersAddContemporaneous.add(lastYearMonthNowList.stream().map(ProfitLossVo::getOthersAdd).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            netIncomeContemporaneous = netIncomeContemporaneous.add(othersAddContemporaneous);
            if (CollectionUtil.isNotEmpty((Collection)budgetProfitLossVos)) {
                Map<String, List<BudgetProfitLossVo>> budgetProfitLossVosYearMonthMap = budgetProfitLossVos.stream().collect(Collectors.groupingBy(ProfitLossVo::getYearMonthly));
                List yearMonthNowList = Optional.ofNullable(budgetProfitLossVosYearMonthMap.get(nowDate.substring(0, 7))).orElse(new ArrayList());
                netIncomeBudget = netIncomeBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getNetIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                disCountBudget = disCountBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getSaleFeeSaleDiscount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                reimbursementBudget = reimbursementBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getSaleFeeReimburse).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                salesBudget = salesBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getSaleAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                disCountBudget = disCountBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getDiscountSub).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                netProfitBudget = netProfitBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                othersAddBudget = othersAddBudget.add(yearMonthNowList.stream().map(ProfitLossVo::getOthersAdd).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            netIncomeBudget = netIncomeBudget.add(othersAddBudget);
            if (CollectionUtil.isNotEmpty(list)) {
                List planTableFormList = Optional.ofNullable(planMap.get(salesDepartmentCode)).orElse(new ArrayList());
                netIncomePlan = netIncomePlan.add(planTableFormList.stream().map(PromotionPlanTableForm::getNetIncomePlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                netProfitPlan = netProfitPlan.add(planTableFormList.stream().map(PromotionPlanTableForm::getPlannedNetProfit).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            if (CollectionUtil.isNotEmpty(promotionPlanParamVos)) {
                Map<String, List<PromotionPlanParamVo>> yearMonthMap = promotionPlanParamVos.stream().collect(Collectors.groupingBy(vo -> vo.getStartDate().substring(0, 7)));
                List promotionPlanParamVoList = Optional.ofNullable(yearMonthMap.get(nowDate.substring(0, 7))).orElse(new ArrayList());
                List DISCOUNT_AFTER_SALE = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals((CharSequence)vo.getProjectCode(), (CharSequence)PromotionPlanResultProjectEnum.DISCOUNT_AFTER_SALE.getCode())).collect(Collectors.toList());
                List DISCOUNT = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals((CharSequence)vo.getProjectCode(), (CharSequence)PromotionPlanResultProjectEnum.DISCOUNT.getCode())).collect(Collectors.toList());
                List REIMBURSEMENT = promotionPlanParamVoList.stream().filter(vo -> StringUtils.equals((CharSequence)vo.getProjectCode(), (CharSequence)PromotionPlanResultProjectEnum.REIMBURSEMENT.getCode())).collect(Collectors.toList());
                disCountPlan = disCountPlan.add(DISCOUNT.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                reimbursementPlan = reimbursementPlan.add(REIMBURSEMENT.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                salesPlan = salesPlan.add(DISCOUNT_AFTER_SALE.stream().map(PromotionPlanParamVo::getPlan).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            BigDecimal incomeAchievement = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                incomeAchievement = netIncomePlan.divide(netIncomeBudget, 6, 4);
            }
            BigDecimal vsContemporaneous = netIncomePlan.subtract(netIncomeContemporaneous);
            BigDecimal vsBudget = netIncomePlan.subtract(netIncomeContemporaneous);
            BigDecimal contemporaneousSpecialExpenseRate = BigDecimal.ZERO;
            BigDecimal discountAfterSaleContemporaneous = salesContemporaneous.subtract(disCountSubContemporaneous);
            if (BigDecimal.ZERO.compareTo(discountAfterSaleContemporaneous) != 0) {
                contemporaneousSpecialExpenseRate = disCountContemporaneous.add(reimbursementContemporaneous).divide(discountAfterSaleContemporaneous, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal budgetSpecialExpenseRate = BigDecimal.ZERO;
            BigDecimal discountAfterSaleBudget = salesBudget.subtract(disCountSubBudget);
            if (BigDecimal.ZERO.compareTo(discountAfterSaleBudget) != 0) {
                budgetSpecialExpenseRate = disCountBudget.add(reimbursementBudget).divide(discountAfterSaleBudget, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal planSpecialExpenseRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(salesPlan) != 0) {
                planSpecialExpenseRate = disCountPlan.add(reimbursementPlan).divide(salesPlan, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal expenseRateVsContemporaneous = planSpecialExpenseRate.subtract(contemporaneousSpecialExpenseRate);
            BigDecimal expenseRateVsBudget = planSpecialExpenseRate.subtract(budgetSpecialExpenseRate);
            BigDecimal budgetProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomeBudget) != 0) {
                budgetProfitMargin = netProfitBudget.divide(netIncomeBudget, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal plannedProfitMargin = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(netIncomePlan) != 0) {
                plannedProfitMargin = netProfitPlan.divide(netIncomePlan, 6, 4).multiply(new BigDecimal(100));
            }
            BigDecimal profitMarginReached = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetProfitMargin) != 0) {
                profitMarginReached = plannedProfitMargin.divide(budgetProfitMargin, 6, 4).multiply(new BigDecimal(100));
            }
            log.info("\u5f00\u59cb\u6784\u5efa\u6570\u636e!");
            promotionPlanTableForm.setOnlyKey(salesDepartmentCode + nowDate.substring(0, 7));
            promotionPlanTableForm.setTenantCode(tenantCode);
            promotionPlanTableForm.setDelFlag(delFlag);
            promotionPlanTableForm.setSalesDepartmentCode(promotionPlanVo.getSalesDepartmentCode());
            promotionPlanTableForm.setSalesDepartmentName(promotionPlanVo.getSalesDepartmentName());
            promotionPlanTableForm.setOrgCode(promotionPlanVo.getOrgCode());
            promotionPlanTableForm.setOrgName(promotionPlanVo.getOrgName());
            promotionPlanTableForm.setYearAndMonth(nowDate.substring(0, 7));
            promotionPlanTableForm.setNetIncomeContemporaneous(netIncomeContemporaneous);
            promotionPlanTableForm.setNetIncomeBudget(netIncomeBudget);
            promotionPlanTableForm.setNetIncomePlan(netIncomePlan);
            promotionPlanTableForm.setIncomeAchievement(incomeAchievement);
            promotionPlanTableForm.setVsContemporaneous(vsContemporaneous);
            promotionPlanTableForm.setVsBudget(vsBudget);
            promotionPlanTableForm.setContemporaneousSpecialExpenseRate(contemporaneousSpecialExpenseRate);
            promotionPlanTableForm.setBudgetSpecialExpenseRate(budgetSpecialExpenseRate);
            promotionPlanTableForm.setPlanSpecialExpenseRate(planSpecialExpenseRate);
            promotionPlanTableForm.setExpenseRateVsContemporaneous(expenseRateVsContemporaneous);
            promotionPlanTableForm.setExpenseRateVsBudget(expenseRateVsBudget);
            promotionPlanTableForm.setBudgetNetProfit(netProfitBudget);
            promotionPlanTableForm.setPlannedNetProfit(netProfitPlan);
            promotionPlanTableForm.setContemporaneousNetProfit(netProfitContemporaneous);
            promotionPlanTableForm.setBudgetProfitMargin(budgetProfitMargin);
            promotionPlanTableForm.setPlannedProfitMargin(plannedProfitMargin);
            promotionPlanTableForm.setProfitMarginReached(profitMarginReached);
            promotionPlanTableForm.setLevelCode("0");
            list.add(promotionPlanTableForm);
        }
        log.info("\u6784\u5efa\u6570\u636e\u5b8c\u6210,\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5230\u6570\u636e\u5e93!");
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<PromotionPlanTableForm> updateList = new ArrayList<PromotionPlanTableForm>();
            ArrayList<PromotionPlanTableForm> saveList = new ArrayList<PromotionPlanTableForm>();
            List<String> onlyKeys = list.stream().map(PromotionPlanTableForm::getOnlyKey).distinct().collect(Collectors.toList());
            List<PromotionPlanTableForm> byOnlyKey = this.promotionPlanTableFormRepository.findByOnlyKey(onlyKeys, tenantCode, delFlag);
            if (CollectionUtils.isEmpty(byOnlyKey)) {
                saveList.addAll(list);
            } else {
                Map<String, String> map = byOnlyKey.stream().collect(Collectors.toMap(PromotionPlanTableForm::getOnlyKey, UuidEntity::getId, (a, b) -> a));
                for (PromotionPlanTableForm promotionPlanTableForm : list) {
                    String id = map.get(promotionPlanTableForm.getOnlyKey());
                    if (StringUtils.isNotEmpty((CharSequence)id)) {
                        promotionPlanTableForm.setId(id);
                        updateList.add(promotionPlanTableForm);
                        continue;
                    }
                    saveList.add(promotionPlanTableForm);
                }
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.promotionPlanTableFormRepository.updateBatchById(updateList);
            }
            if (!CollectionUtils.isEmpty(saveList)) {
                this.promotionPlanTableFormRepository.saveBatch(saveList);
            }
        }
        log.info("\u6570\u636e\u5165\u5e93\u5b8c\u6210!");
    }

    public List<PromotionPlanTableFormVo> findByPlatformLevelByDepartmentId(String id) {
        Validate.notNull((Object)id, (String)"\u672a\u4f20\u5165id!", (Object[])new Object[0]);
        PromotionPlanTableForm promotionPlanTableForm = (PromotionPlanTableForm)((Object)this.promotionPlanTableFormRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)promotionPlanTableForm), (String)"\u672a\u83b7\u53d6\u5230\u90e8\u95e8\u6570\u636e!", (Object[])new Object[0]);
        String salesDepartmentCode = promotionPlanTableForm.getOrgCode();
        String yearAndMonth = promotionPlanTableForm.getYearAndMonth();
        List<PromotionPlanTableFormVo> list = this.promotionPlanTableFormRepository.findByPlatformLevelByDepartmentId(salesDepartmentCode, "0", yearAndMonth);
        return list;
    }
}

