/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanResultRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.PromotionPlanWholeSummaryProjectEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryDetailService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ActualProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ProfitLossVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanResultVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailStrVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="promotionPlanWholeSummaryDetailService")
public class PromotionPlanWholeSummaryDetailServiceImpl
implements PromotionPlanWholeSummaryDetailService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanWholeSummaryDetailServiceImpl.class);
    @Autowired(required=false)
    private ActualProfitLossService actualProfitLossService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;
    @Autowired(required=false)
    private PromotionPlanResultRepository promotionPlanResultRepository;

    public List<PromotionPlanWholeSummaryDetailVo> calculationResult(String yearMonthLy) {
        ArrayList<PromotionPlanWholeSummaryDetailVo> list = new ArrayList<PromotionPlanWholeSummaryDetailVo>();
        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = this.createPromotionPlanResultVoList(yearMonthLy);
        this.resultProfitLoss(map, yearMonthLy);
        this.resultPlan(map, yearMonthLy);
        int index = 0;
        for (String k : map.keySet()) {
            PromotionPlanWholeSummaryDetailVo v = map.get(k);
            v.setPlanVsContemporaneous(this.bdNull(v.getPlan()).subtract(this.bdNull(v.getContemporaneous())));
            v.setPlanVsBudget(this.bdNull(v.getPlan()).subtract(this.bdNull(v.getBudget())));
            v.setActualPlan(this.bdNull(v.getActualSub1()).add(this.bdNull(v.getPlan())));
            v.setActualPlanLast(this.bdNull(v.getActualSub2()).add(this.bdNull(v.getPlanSub1())).add(this.bdNull(v.getPlan())));
            v.setActualPlanVsBudget(this.bdNull(v.getActualPlan()).subtract(this.bdNull(v.getBudgetTotal())));
            v.setUseProgress(v.getBudgetTotalYear() == null ? BigDecimal.ZERO : v.getActualPlan().divide(v.getBudgetTotalYear(), 6, RoundingMode.HALF_UP));
            v.setSortIndex(Integer.valueOf(index));
            list.add(v);
            ++index;
        }
        return list;
    }

    public void resultPlan(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String yearMonthLy) {
        String endStr;
        String[] split = yearMonthLy.split("-");
        String year = split[0];
        int month = Integer.valueOf(split[1]);
        String startStr = year + "-01-01";
        List<PromotionPlanResultVo> planResultList = this.promotionPlanResultRepository.getAllByStartDateAndEndSum(startStr, endStr = DateUtil.formatDate((Date)DateUtil.getLastDayOfMonth((Date)DateUtil.strToDate((String)(yearMonthLy + "-01"), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd))), "\u8d26\u9762", ProcessStatusEnum.PASS.getDictCode());
        if (CollectionUtils.isEmpty(planResultList)) {
            return;
        }
        LinkedHashMap planMap = planResultList.stream().sorted(Comparator.comparing(PromotionPlanResultVo::getYearMonthLy)).collect(Collectors.groupingBy(e -> e.getYearMonthLy(), LinkedHashMap::new, Collectors.toMap(PromotionPlanResultVo::getProjectCode, PromotionPlanResultVo::getPlan)));
        planMap.forEach((k, v) -> v.put(PromotionPlanWholeSummaryProjectEnum.GROSS.getCode(), ((BigDecimal)v.get(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode())).subtract((BigDecimal)v.get(PromotionPlanWholeSummaryProjectEnum.COST.getCode()))));
        Map thisMonth = (Map)planMap.get(yearMonthLy);
        this.setMapRate(thisMonth);
        this.setMap(map, thisMonth, "plan");
        if (month > 1) {
            String monthStr = month > 10 ? String.valueOf(month - 1) : "0" + (month - 1);
            Map lastMonth = (Map)planMap.get(year + "-" + monthStr);
            this.setMapRate(lastMonth);
            this.setMap(map, lastMonth, "plan_last");
        }
        HashMap<String, BigDecimal> monthTotal = new HashMap<String, BigDecimal>();
        for (String k2 : planMap.keySet()) {
            this.sumMap((Map)planMap.get(k2), monthTotal);
        }
        this.setMapRate(monthTotal);
        this.setMap(map, monthTotal, "plan_total");
    }

    public void resultProfitLoss(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String yearMonthLy) {
        ActualProfitLossVo dtoA = new ActualProfitLossVo();
        BudgetProfitLossVo dtoB = new BudgetProfitLossVo();
        dtoA.setType("\u8d26\u9762");
        dtoB.setType("\u8d26\u9762");
        String[] split = yearMonthLy.split("-");
        String year = split[0];
        String yearBefore = String.valueOf(Integer.valueOf(split[0]) - 1);
        ArrayList<String> aMonthList = new ArrayList<String>();
        aMonthList.addAll(this.getMonthList(yearBefore, split[1]));
        if (Integer.valueOf(split[1]) - 1 > 0) {
            aMonthList.addAll(this.getMonthList(year, String.valueOf(Integer.valueOf(split[1]) - 1)));
        }
        List aList = this.actualProfitLossService.findProfitLoss(dtoA, aMonthList);
        List bList = this.budgetProfitLossService.findProfitLoss(dtoB, this.getMonthList(year, "12"));
        this.sumProfitLoss(aList, map, "actual", yearBefore + "-" + split[1], Integer.valueOf(split[1]) - 1);
        this.sumProfitLoss(bList, map, "budget", yearMonthLy, 1);
    }

    public <T> void sumProfitLoss(List<T> list, LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map, String type, String month, int mm) {
        List<T> voList = list;
        LinkedHashMap mapMonth = voList.stream().sorted(Comparator.comparing(ProfitLossVo::getYearMonthly)).collect(Collectors.groupingBy(e -> e.getYearMonthly(), LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap monthMapFee = new LinkedHashMap();
        for (String k : mapMonth.keySet()) {
            List monthVolist = (List)mapMonth.get(k);
            BigDecimal discountBeforeSale = BigDecimal.ZERO;
            BigDecimal discountAfterSale = BigDecimal.ZERO;
            Object gmv = BigDecimal.ZERO;
            BigDecimal netIncome = BigDecimal.ZERO;
            BigDecimal cost = BigDecimal.ZERO;
            BigDecimal netProfit = BigDecimal.ZERO;
            BigDecimal discount = BigDecimal.ZERO;
            BigDecimal reimbursement = BigDecimal.ZERO;
            BigDecimal consumer = BigDecimal.ZERO;
            BigDecimal channel = BigDecimal.ZERO;
            BigDecimal put = BigDecimal.ZERO;
            BigDecimal platformOperate = BigDecimal.ZERO;
            BigDecimal feePool = BigDecimal.ZERO;
            BigDecimal logistics = BigDecimal.ZERO;
            BigDecimal admin = BigDecimal.ZERO;
            BigDecimal gross = BigDecimal.ZERO;
            HashMap<String, Object> mapFee = new HashMap<String, Object>();
            for (ProfitLossVo vo : monthVolist) {
                discountBeforeSale = discountBeforeSale.add(this.bdNull(vo.getSaleAmount()));
                discountAfterSale = discountAfterSale.add(this.bdNull(vo.getSaleAmount()).subtract(this.bdNull(vo.getDiscountSub())));
                gmv = ((BigDecimal)gmv).add(this.bdNull(vo.getGmv()));
                netIncome = netIncome.add(this.bdNull(vo.getNetIncome()).add(this.bdNull(vo.getOthersAdd())));
                cost = cost.add(this.bdNull(vo.getDirectMaterial()));
                netProfit = netProfit.add(this.bdNull(vo.getNetProfit()));
                discount = discount.add(this.bdNull(vo.getSaleFeeSaleDiscount()));
                reimbursement = reimbursement.add(this.bdNull(vo.getSaleFeeReimburse()));
                consumer = consumer.add(this.bdNull(vo.getConsumer()));
                channel = channel.add(this.bdNull(vo.getChannel()));
                put = put.add(this.bdNull(vo.getPut()));
                platformOperate = platformOperate.add(this.bdNull(vo.getPlatformOperate()));
                feePool = feePool.add(this.bdNull(vo.getFeePool()));
                logistics = logistics.add(this.bdNull(vo.getTransportHandling()).add(this.bdNull(vo.getSaleFeeInventory())));
                admin = admin.add(this.bdNull(vo.getSaleFeeAdmin()).add(this.bdNull(vo.getManage())).add(this.bdNull(vo.getDevelopment())));
                gross = gross.add(this.bdNull(vo.getNetIncome()).add(this.bdNull(vo.getOthersAdd())).subtract(this.bdNull(vo.getDirectMaterial())));
            }
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_BEFORE_SALE.getCode(), discountBeforeSale);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_AFTER_SALE.getCode(), discountAfterSale);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.GMV.getCode(), gmv);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode(), netIncome);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.COST.getCode(), cost);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT.getCode(), netProfit);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT.getCode(), discount);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT.getCode(), reimbursement);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.CONSUMER.getCode(), consumer);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.CHANNEL.getCode(), channel);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.PUT.getCode(), put);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE.getCode(), platformOperate);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.FEE_POOL.getCode(), feePool);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.LOGISTICS.getCode(), logistics);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.ADMIN.getCode(), admin);
            mapFee.put(PromotionPlanWholeSummaryProjectEnum.GROSS.getCode(), gross);
            monthMapFee.put(k, mapFee);
        }
        int monthInt = Integer.valueOf(month.replace("-", ""));
        HashMap<String, BigDecimal> mapTotal = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> mapSubBudget = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> mapSubActual = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> mapSubActual2 = new HashMap<String, BigDecimal>();
        for (String k : monthMapFee.keySet()) {
            int kInt = Integer.valueOf(k.replace("-", ""));
            String[] split = k.split("-");
            if (kInt <= monthInt) {
                this.sumMap((Map)monthMapFee.get(k), mapTotal);
                continue;
            }
            if ("budget".equals(type)) {
                this.sumMap((Map)monthMapFee.get(k), mapSubBudget);
                continue;
            }
            if (mm == 0) continue;
            if (Integer.valueOf(split[1]) >= mm) {
                this.sumMap((Map)monthMapFee.get(k), mapSubActual);
                continue;
            }
            this.sumMap((Map)monthMapFee.get(k), mapSubActual);
            this.sumMap((Map)monthMapFee.get(k), mapSubActual2);
        }
        Map thisMonth = (Map)monthMapFee.get(month);
        this.setMapRate(thisMonth);
        this.setMapRate(mapTotal);
        if ("budget".equals(type)) {
            this.setMap(map, thisMonth, "budget");
            this.setMap(map, mapTotal, "budget_total");
            this.sumMap(mapTotal, mapSubBudget);
            this.setMapRate(mapTotal);
            this.setMap(map, mapTotal, "budget_year");
        } else {
            this.setMap(map, thisMonth, "actual");
            this.setMap(map, mapTotal, "actual_total");
            this.setMap(map, mapSubActual, "actual_sub1");
            this.setMap(map, mapSubActual2, "actual_sub2");
        }
    }

    private LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> createPromotionPlanResultVoList(String month) {
        LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> map = new LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo>();
        List<HashMap<String, String>> enumListMap = this.getEnumListMap();
        enumListMap.forEach(e -> {
            PromotionPlanWholeSummaryDetailVo vo = new PromotionPlanWholeSummaryDetailVo();
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setYearMonthLy(month);
            vo.setProjectCode((String)e.get("code"));
            vo.setProjectName((String)e.get("name"));
            map.put((String)e.get("code"), vo);
        });
        return map;
    }

    private void setMap(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> dataMap, Map<String, BigDecimal> thisMonth, String type) {
        if (thisMonth == null || thisMonth.isEmpty()) {
            return;
        }
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            String k = ppEnum.getCode();
            switch (type) {
                case "budget": {
                    dataMap.get(k).setBudget(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "actual": {
                    dataMap.get(k).setContemporaneous(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "budget_total": {
                    dataMap.get(k).setBudgetTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "actual_total": {
                    dataMap.get(k).setContemporaneousTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "budget_year": {
                    dataMap.get(k).setBudgetTotalYear(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "actual_sub1": {
                    dataMap.get(k).setActualSub1(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "actual_sub2": {
                    dataMap.get(k).setActualSub2(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "plan": {
                    dataMap.get(k).setPlan(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "plan_last": {
                    dataMap.get(k).setPlanSub1(thisMonth.get(ppEnum.getCode()));
                    break;
                }
                case "plan_total": {
                    dataMap.get(k).setPlanTotal(thisMonth.get(ppEnum.getCode()));
                    break;
                }
            }
        }
    }

    private void sumMap(Map<String, BigDecimal> thisMonth, Map<String, BigDecimal> mapTotal) {
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            String k = ppEnum.getCode();
            if (k.equals(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode())) continue;
            if (!mapTotal.containsKey(k)) {
                mapTotal.put(k, BigDecimal.ZERO);
            }
            mapTotal.put(ppEnum.getCode(), mapTotal.get(k).add(thisMonth.get(ppEnum.getCode())));
        }
    }

    private void setMapRate(Map<String, BigDecimal> thisMonth) {
        if (thisMonth == null || thisMonth.isEmpty()) {
            return;
        }
        BigDecimal discountBeforeSale = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_BEFORE_SALE.getCode());
        BigDecimal discountAfterSale = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_AFTER_SALE.getCode());
        BigDecimal netIncome = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.NET_INCOME.getCode());
        BigDecimal cost = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.COST.getCode());
        BigDecimal netProfit = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT.getCode());
        BigDecimal discount = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.DISCOUNT.getCode());
        BigDecimal reimbursement = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT.getCode());
        BigDecimal consumer = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.CONSUMER.getCode());
        BigDecimal channel = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.CHANNEL.getCode());
        BigDecimal put = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.PUT.getCode());
        BigDecimal platformOperate = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE.getCode());
        BigDecimal logistics = thisMonth.get(PromotionPlanWholeSummaryProjectEnum.LOGISTICS.getCode());
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode(), netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netIncome.subtract(cost).divide(netIncome, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : reimbursement.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : consumer.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : channel.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : put.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode(), discountAfterSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : platformOperate.divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode(), discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : discount.add(reimbursement).divide(discountAfterSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode(), discountBeforeSale.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : logistics.divide(discountBeforeSale, 4, 4));
        thisMonth.put(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode(), netIncome.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : netProfit.divide(netIncome, 4, 4));
    }

    private List<HashMap<String, String>> getEnumListMap() {
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        for (PromotionPlanWholeSummaryProjectEnum ppEnum : EnumSet.allOf(PromotionPlanWholeSummaryProjectEnum.class)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ppEnum.getName());
            map.put("code", ppEnum.getCode());
            list.add(map);
        }
        return list;
    }

    public List<PromotionPlanWholeSummaryDetailStrVo> voChange(LinkedHashMap<String, PromotionPlanWholeSummaryDetailVo> cahchResult) {
        ArrayList<PromotionPlanWholeSummaryDetailStrVo> strVoList = new ArrayList<PromotionPlanWholeSummaryDetailStrVo>();
        cahchResult.forEach((k, v) -> {
            PromotionPlanWholeSummaryDetailStrVo strVo = new PromotionPlanWholeSummaryDetailStrVo().setProjectName(v.getProjectName());
            if (k.equals(PromotionPlanWholeSummaryProjectEnum.GROSS_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.DISCOUNT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.REIMBURSEMENT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.CONSUMERT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.CHANNEL_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.PUT_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.PLATFORM_OPERATE_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.SPECIAL_COST.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.LOGISTICS_RATE.getCode()) || k.equals(PromotionPlanWholeSummaryProjectEnum.NET_PROFIT_RATE.getCode())) {
                strVo.setPlan(v.getPlan().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanTotal(v.getPlanTotal().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setContemporaneous(this.bdNull(v.getContemporaneous()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setContemporaneousTotal(this.bdNull(v.getContemporaneousTotal()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setBudget(this.bdNull(v.getBudget()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setBudgetTotal(this.bdNull(v.getBudgetTotal()).multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanVsContemporaneous(v.getPlanVsContemporaneous().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setPlanVsBudget(v.getPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setActualPlan(v.getActualPlan().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setActualPlanLast(v.getActualPlanLast().multiply(new BigDecimal(100)).setScale(2, 4) + "%").setActualPlanVsBudget(v.getActualPlanVsBudget().multiply(new BigDecimal(100)).setScale(2, 4) + "%");
            } else {
                strVo.setPlan((v.getPlan() == null ? BigDecimal.ZERO : v.getPlan()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanTotal((v.getPlanTotal() == null ? BigDecimal.ZERO : v.getPlanTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setContemporaneous((v.getContemporaneous() == null ? BigDecimal.ZERO : v.getContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString()).setContemporaneousTotal((v.getContemporaneousTotal() == null ? BigDecimal.ZERO : v.getContemporaneousTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setBudget((v.getBudget() == null ? BigDecimal.ZERO : v.getBudget()).setScale(3, RoundingMode.HALF_UP).toString()).setBudgetTotal((v.getBudgetTotal() == null ? BigDecimal.ZERO : v.getBudgetTotal()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanVsContemporaneous((v.getPlanVsContemporaneous() == null ? BigDecimal.ZERO : v.getPlanVsContemporaneous()).setScale(3, RoundingMode.HALF_UP).toString()).setPlanVsBudget((v.getPlanVsBudget() == null ? BigDecimal.ZERO : v.getPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString()).setActualPlan((v.getActualPlan() == null ? BigDecimal.ZERO : v.getActualPlan()).setScale(3, RoundingMode.HALF_UP).toString()).setActualPlanLast((v.getActualPlanLast() == null ? BigDecimal.ZERO : v.getActualPlanLast()).setScale(3, RoundingMode.HALF_UP).toString()).setActualPlanVsBudget((v.getActualPlanVsBudget() == null ? BigDecimal.ZERO : v.getActualPlanVsBudget()).setScale(3, RoundingMode.HALF_UP).toString()).setBudgetTotalYear((v.getBudgetTotalYear() == null ? BigDecimal.ZERO : v.getBudgetTotalYear()).setScale(3, RoundingMode.HALF_UP).toString()).setUseProgress(this.bdNull(v.getUseProgress()).multiply(new BigDecimal(100)).setScale(2, 4) + "%");
            }
            strVoList.add(strVo);
        });
        return strVoList;
    }

    private List<String> getMonthList(String year, String month) {
        ArrayList<String> monthList = new ArrayList<String>();
        int monthInt = Integer.parseInt(month);
        for (int i = 1; i <= monthInt; ++i) {
            if (i < 10) {
                monthList.add(year + "-0" + i);
                continue;
            }
            monthList.add(year + "-" + i);
        }
        return monthList;
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }
}

