/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummary;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanWholeSummaryDetail;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanWholeSummaryDetailRepository;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanWholeSummaryRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanWholeSummaryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryDetailService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailStrVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionPlanWholeSummaryService")
public class PromotionPlanWholeSummaryServiceImpl
implements PromotionPlanWholeSummaryService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanWholeSummaryServiceImpl.class);
    @Autowired(required=false)
    private PromotionPlanWholeSummaryRepository promotionPlanWholeSummaryRepository;
    @Autowired(required=false)
    private PromotionPlanWholeSummaryDetailRepository promotionPlanWholeSummaryDetailRepository;
    @Autowired(required=false)
    private PromotionPlanWholeSummaryDetailService promotionPlanWholeSummaryDetailService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Value(value="${venus.file.fileRoot}")
    public String fileRoot;

    @Transactional(rollbackFor={Exception.class})
    public void createPromotionPlanWholeSummary(String yearMonthLy) {
        PromotionPlanWholeSummary entity;
        if (StringUtils.isBlank((CharSequence)yearMonthLy)) {
            yearMonthLy = DateUtil.getDateStrByFormat((Date)DateUtil.dateAddMonth((Date)new Date(), (Integer)-1), (String)"yyyy-MM");
        }
        if ((entity = this.promotionPlanWholeSummaryRepository.findByYearMonth(yearMonthLy)) != null) {
            this.promotionPlanWholeSummaryDetailRepository.deleteYearMonth(yearMonthLy);
            this.promotionPlanWholeSummaryRepository.deleteYearMonth(yearMonthLy);
        }
        List promotionPlanWholeSummaryDetailVos = this.promotionPlanWholeSummaryDetailService.calculationResult(yearMonthLy);
        PromotionPlanWholeSummary newEntity = new PromotionPlanWholeSummary();
        newEntity.setTenantCode(TenantUtils.getTenantCode());
        newEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newEntity.setYearMonthLy(yearMonthLy);
        newEntity.setWholeSummaryName(yearMonthLy + "\u4fc3\u9500\u89c4\u5212\u6574\u4f53\u4e00\u89c8\u8868");
        newEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        FileDto fileDto = this.toExcel(promotionPlanWholeSummaryDetailVos, newEntity.getWholeSummaryName());
        newEntity.setFileCode(fileDto.getFileCode());
        newEntity.setOriginalFileName(fileDto.getOriginalFileName());
        this.promotionPlanWholeSummaryRepository.save((Object)newEntity);
        if (CollectionUtils.isNotEmpty((Collection)promotionPlanWholeSummaryDetailVos)) {
            Collection details = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotionPlanWholeSummaryDetailVos, PromotionPlanWholeSummaryDetailVo.class, PromotionPlanWholeSummaryDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.promotionPlanWholeSummaryDetailRepository.saveBatch(details);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(PromotionPlanWholeSummaryDto dto) {
        Validate.isTrue((boolean)Objects.nonNull(dto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PromotionPlanWholeSummary entity = (PromotionPlanWholeSummary)((Object)this.promotionPlanWholeSummaryRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e00\u89c8\u8868\u6570\u636e", (Object[])new Object[0]);
        PromotionPlanWholeSummaryDto wholeSummaryDto = (PromotionPlanWholeSummaryDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PromotionPlanWholeSummaryDto.class, HashSet.class, ArrayList.class, new String[0]);
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(wholeSummaryDto.getWholeSummaryName());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)wholeSummaryDto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("promotion_plan_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        this.promotionPlanWholeSummaryRepository.saveOrUpdate((Object)entity);
    }

    public List<PromotionPlanWholeSummaryDetailStrVo> getPromotionPlanWholeSummaryDetail(String yearMonthLy) {
        List<PromotionPlanWholeSummaryDetail> details = this.promotionPlanWholeSummaryDetailRepository.findByYearMonth(yearMonthLy);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(details, PromotionPlanWholeSummaryDetail.class, PromotionPlanWholeSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        LinkedHashMap map = voList.stream().collect(Collectors.toMap(e -> e.getProjectCode(), Function.identity(), (o, n) -> n, LinkedHashMap::new));
        return this.promotionPlanWholeSummaryDetailService.voChange(map);
    }

    public FileDto toExcel(List<PromotionPlanWholeSummaryDetailVo> voList, String wholeSummaryName) {
        FileDto fileDto = new FileDto();
        LinkedHashMap map = voList.stream().collect(Collectors.toMap(e -> e.getProjectCode(), Function.identity(), (o, n) -> n, LinkedHashMap::new));
        List voStrList = this.promotionPlanWholeSummaryDetailService.voChange(map);
        log.info("\u751f\u6210excel\uff1a\u521b\u5efa\u5f00\u59cb");
        File dir = new File(this.fileRoot);
        if (!dir.exists()) {
            log.info("\u751f\u6210excel\uff1a\u65b0\u5efa\u76ee\u5f55");
            dir.mkdirs();
        }
        String excelName = wholeSummaryName + System.currentTimeMillis() + ".xlsx";
        String fileName = this.fileRoot + "/" + excelName;
        EasyExcel.write((String)fileName, PromotionPlanWholeSummaryDetailStrVo.class).sheet(wholeSummaryName).doWrite((Collection)voStrList);
        File file = new File(fileName);
        byte[] fileByte = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = this.fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null, excelName, fileByte);
            Validate.notNull((Object)ordinaryFileVo, (String)"\u4e00\u89c8\u8868excel\u6587\u4ef6\u751f\u6210\u5931\u8d25!!! \u540d\u79f0\uff1a[%s]", (Object[])new Object[]{wholeSummaryName});
            fileDto.setFileCode(ordinaryFileVo.getId());
            fileDto.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
        }
        catch (IOException e2) {
            log.info("\u751f\u6210excel\uff1a\u4e0a\u4f20\u5f02\u5e38\uff1a" + e2.getMessage());
            throw new RuntimeException(e2);
        }
        finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
        log.info("\u4e0a\u4f20\u6587\u4ef6\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fileDto));
        boolean delete = file.delete();
        if (delete) {
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f,{}", (Object)file.getName());
        } else {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25,{}", (Object)file.getName());
        }
        return fileDto;
    }
}

