/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PurchaseSaleRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PurchaseSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="purchaseSaleService")
public class PurchaseSaleServiceImpl
implements PurchaseSaleService {
    @Autowired(required=false)
    private PurchaseSaleRepository purchaseSaleRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<PurchaseSaleVo> findByConditions(Pageable pageable, PurchaseSaleDto purchaseSale) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(purchaseSale)) {
            purchaseSale = new PurchaseSaleDto();
        }
        return this.purchaseSaleRepository.findByConditions(pageable, purchaseSale);
    }

    public Page<PurchaseSaleVo> findCachePageList(Pageable pageable, String cacheKey, String promotionPlanCode) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)objects, PurchaseSaleDto.class, PurchaseSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)promotionPlanCode)) {
            List<PurchaseSaleDto> dtoList = this.purchaseSaleRepository.findByPlanCode(promotionPlanCode);
            if (!CollectionUtils.isEmpty(dtoList)) {
                this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), dtoList.toArray());
            }
            page.setTotal((long)dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList.subList((int)page.offset(), (int)end), PurchaseSaleDto.class, PurchaseSaleVo.class, HashSet.class, ArrayList.class, new String[0]);
                page.setRecords(voList);
            }
        }
        return page;
    }

    public List<PurchaseSaleDto> findCacheList(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public List<PurchaseSaleDto> findList(String code) {
        return this.purchaseSaleRepository.findByPlanCode(code);
    }

    public void addItemCache(String cacheKey, List<PurchaseSaleDto> saveList) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        Map<Object, Object> saveItemMap = !CollectionUtils.isEmpty(saveList) ? saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity())) : Maps.newHashMap();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            for (Object object : objects) {
                PurchaseSaleDto item = (PurchaseSaleDto)object;
                newList.add(saveItemMap.getOrDefault(item.getId(), item));
            }
        }
        PurchaseSaleDto newItem = new PurchaseSaleDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newList.add(0, newItem);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void copyItemListCache(String cacheKey, List<PurchaseSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        ArrayList copyList = Lists.newArrayList();
        for (Object object : objects) {
            PurchaseSaleDto item = (PurchaseSaleDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                PurchaseSaleDto newItem = (PurchaseSaleDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) {
                    PurchaseSaleDto copyItem = (PurchaseSaleDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newItem, PurchaseSaleDto.class, HashSet.class, ArrayList.class, new String[0]);
                    copyItem.setId(UUID.randomUUID().toString().replace("-", ""));
                    copyItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    copyItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    copyList.add(copyItem);
                }
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        newList.addAll(0, copyList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void saveCurrentPageCache(String cacheKey, List<PurchaseSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            PurchaseSaleDto item = (PurchaseSaleDto)object;
            newList.add(saveItemMap.getOrDefault(item.getId(), item));
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void deleteCacheList(String cacheKey, List<PurchaseSaleDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map saveItemMap = itemList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            PurchaseSaleDto item = (PurchaseSaleDto)object;
            if (saveItemMap.containsKey(item.getId())) {
                PurchaseSaleDto newItem = (PurchaseSaleDto)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) continue;
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
        }
    }

    public void clearCache(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
    }

    public Integer getTotal(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        return this.redisService.lSize(redisCacheKey).intValue();
    }

    public void addListCache(String cacheKey, List<PurchaseSaleDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        ArrayList newList = Lists.newArrayList();
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            newList.addAll(objects);
        }
        newList.addAll(saveList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void updateListCache(String cacheKey, List<PurchaseSaleDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), itemList.toArray());
    }

    private String getRedisCacheKey(String cacheKey) {
        return "purchase_sale_cache:page:" + cacheKey;
    }
}

