/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.BudgetProfitLossService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossImportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.BudgetProfitLossVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BudgetProfitLossImportsProcess
implements ImportProcess<BudgetProfitLossImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(BudgetProfitLossImportsProcess.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private BudgetProfitLossService budgetProfitLossService;

    public Integer getBatchCount() {
        return 10000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, BudgetProfitLossImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            log.info("\u5f00\u59cb\u5bfc\u5165......");
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            log.info("\u5f00\u59cb\u5bfc\u5165\u6821\u9a8c......");
            List<BudgetProfitLossVo> importList = this.validate(data, params);
            log.info("\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f......");
            log.info("\u5f00\u59cb\u5bfc\u5165\u4fdd\u5b58......");
            this.budgetProfitLossService.saveBatch(importList);
            log.info("\u7ed3\u675f\u5bfc\u5165\u4fdd\u5b58......");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private List<BudgetProfitLossVo> validate(LinkedHashMap<Integer, BudgetProfitLossImportsVo> data, Map<String, Object> params) {
        List orgVos;
        ArrayList<BudgetProfitLossImportsVo> importList = new ArrayList<BudgetProfitLossImportsVo>(data.values());
        log.info("\u5f00\u59cb\u975e\u7a7a\u6821\u9a8c......");
        for (int i = 0; i < importList.size(); ++i) {
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getBusinessFormatName(), (String)("\u4e1a\u6001\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getBusinessUnitName(), (String)("\u4e1a\u52a1\u5355\u5143\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getYearMonthly(), (String)("\u5e74\u6708\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getDepartmentCode(), (String)("\u90e8\u95e8\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getCustomerCode(), (String)("\u5ba2\u6237\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((BudgetProfitLossImportsVo)importList.get(i)).getType(), (String)("\u524d\u53f0/\u8d26\u9762\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u9519\u8bef\u6570\u636e\u4f4d\u4e8e\u7b2c\u3010" + (i + 2) + "\u3011\u884c"), (Object[])new Object[0]);
        }
        log.info("\u7ed3\u675f\u975e\u7a7a\u6821\u9a8c......");
        log.info("\u5f00\u59cb\u67e5\u8be2\u5173\u8054\u6570\u636e......");
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("mdm_business_format", "mdm_business_unit"));
        log.info("\u5f00\u59cb\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> departmentCodeSet = new HashSet<String>();
        for (BudgetProfitLossImportsVo importVo : importList) {
            if (StringUtils.isNotBlank((CharSequence)importVo.getCustomerCode())) {
                customerCodeSet.add(importVo.getCustomerCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)importVo.getDepartmentCode())) continue;
            departmentCodeSet.add(importVo.getDepartmentCode());
        }
        Map customerVoMap = null;
        Map orgVoMap = null;
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        if (CollectionUtils.isNotEmpty((Collection)customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(orgVos = this.orgVoService.findByOrgCodes(new ArrayList(departmentCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        log.info("\u7ed3\u675f\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(importList, BudgetProfitLossImportsVo.class, BudgetProfitLossVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        log.info("\u5f00\u59cb\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        int index = 2;
        for (BudgetProfitLossVo dto : dtoList) {
            DictDataVo businessFormat = ((List)dictDataMap.get("mdm_business_format")).stream().filter(e -> e.getDictValue().equals(dto.getBusinessFormatName())).findFirst().orElse(null);
            if (businessFormat == null) {
                throw new IllegalArgumentException("\u4e1a\u6001\u3010" + dto.getBusinessFormatName() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            dto.setBusinessFormatCode(businessFormat.getDictCode());
            DictDataVo businessUnit = ((List)dictDataMap.get("mdm_business_unit")).stream().filter(e -> e.getDictValue().equals(dto.getBusinessUnitName())).findFirst().orElse(null);
            if (businessUnit == null) {
                throw new IllegalArgumentException("\u4e1a\u52a1\u5355\u5143\u3010" + dto.getBusinessUnitName() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            dto.setBusinessUnitCode(businessUnit.getDictCode());
            if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                if (customerVoMap != null && customerVoMap.containsKey(dto.getCustomerCode())) {
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(dto.getCustomerCode());
                    dto.setCustomerName(customerVo.getCustomerName());
                } else {
                    throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (orgVoMap == null || !orgVoMap.containsKey(dto.getDepartmentCode())) {
                throw new IllegalArgumentException("\u90e8\u95e8\u7f16\u7801\u3010" + dto.getDepartmentCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            OrgVo orgVo = (OrgVo)orgVoMap.get(dto.getDepartmentCode());
            dto.setDepartmentName(orgVo.getOrgName());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        log.info("\u7ed3\u675f\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        return new ArrayList<BudgetProfitLossVo>(dtoList);
    }

    public Class<BudgetProfitLossImportsVo> findCrmExcelVoClass() {
        return BudgetProfitLossImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_BUDGET_PROFIT_LOSS_IMPORT";
    }

    public String getTemplateName() {
        return "\u635f\u76ca\u9884\u7b97\u8868\u5bfc\u5165";
    }
}

