/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthDeliveryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryExportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CurrentMonthDeliveryExportsProcess
implements ExportProcess<CurrentMonthDeliveryExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CurrentMonthDeliveryExportsProcess.class);
    @Autowired(required=false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        log.info("=========\u83b7\u53d6\u5f53\u6708\u9001\u8d27\u5bfc\u51fa\u603b\u8bb0\u5f55\u6570");
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        log.info("=========cacheKey\uff1a" + params.get("cacheKey"));
        Integer total = this.currentMonthDeliveryService.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        log.info("=========total\uff1a" + total);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        log.info("=========\u5f00\u59cb\u5f53\u6708\u9001\u8d27\u5bfc\u51fa");
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page cachePage = this.currentMonthDeliveryService.findCachePageList((Pageable)pageable, cacheKey, params.get("promotionPlanCode") == null ? null : (String)params.get("promotionPlanCode"));
        log.info("=========\u83b7\u53d6\u8d39\u7528\u7533\u8bf7\u5bfc\u51fa\u603b\u8bb0\u5f55\u6570\uff1a" + cachePage.getSize());
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        List records = cachePage.getRecords();
        records.forEach(e -> {
            e.setStartDateStr(DateUtil.format((Date)e.getStartDate(), (String)"yyyy-MM-dd"));
            e.setEndDateStr(DateUtil.format((Date)e.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        });
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, CurrentMonthDeliveryVo.class, CurrentMonthDeliveryExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        log.info("=========\u7ed3\u675f\u8d39\u7528\u7533\u8bf7\u5bfc\u51fa");
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public String getBusinessCode() {
        return "TPM_PP_CURRENT_MONTH_DELIVERY_EXPORT";
    }

    public String getBusinessName() {
        return "\u4fc3\u9500\u89c4\u5212-\u5f53\u6708\u9001\u8d27\u5bfc\u51fa";
    }

    public Class<CurrentMonthDeliveryExportsVo> findCrmExcelVoClass() {
        return CurrentMonthDeliveryExportsVo.class;
    }
}

