/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.MonthDeliveryPromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.ActivityApplyRulesService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesPromotionPlanAmountVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthDeliveryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthDeliveryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryImportsVo;
import com.biz.crm.tpm.business.sales.volume.channel.feign.feign.TpmSalesVolumeChannelServiceFeign;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.TpmSalesVolumeChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CurrentMonthDeliveryImportsProcess
implements ImportProcess<CurrentMonthDeliveryImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CurrentMonthDeliveryImportsProcess.class);
    @Autowired(required=false)
    PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private TpmSalesVolumeChannelServiceFeign tpmSalesVolumeChannelServiceFeign;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityApplyRulesService activityApplyRulesService;
    @Autowired(required=false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;

    public Integer getBatchCount() {
        return 10000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, CurrentMonthDeliveryImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Validate.notNull((Object)params.get("platformCode"), (String)"\u5e73\u53f0\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("platformName"), (String)"\u5e73\u53f0\u540d\u79f0\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("salesOrgCode"), (String)"\u7ec4\u7ec7\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("businessModelCode"), (String)"\u4e1a\u52a1\u6a21\u5f0f\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("channelCode"), (String)"\u6e20\u9053\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("businessFormatCode"), (String)"\u4e1a\u6001\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        for (Map.Entry<Integer, CurrentMonthDeliveryImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            CurrentMonthDeliveryImportsVo vo = row.getValue();
            this.validateIsTrue(vo.getStartDate() != null, "\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getEndDate() != null, "\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getProductCode()), "\u4ea7\u54c1\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getCombinationQuantity() != null, "\u7ec4\u5408\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getEstimatedSalesBox() != null, "\u9884\u8ba1\u9500\u91cf\uff08\u7bb1\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, CurrentMonthDeliveryImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            log.info("\u5f00\u59cb\u5bfc\u5165......");
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
            String cacheKey = (String)params.get("cacheKey");
            log.info("\u5f00\u59cb\u5bfc\u5165\u6821\u9a8c......");
            List<CurrentMonthDeliveryDto> importList = this.validate(data, params, errMap);
            log.info("\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f......");
            if (errMap.isEmpty()) {
                log.info("\u5f00\u59cb\u5bfc\u5165\u7f13\u5b58......");
                this.currentMonthDeliveryService.addListCache(cacheKey, importList);
                log.info("\u7ed3\u675f\u5bfc\u5165\u7f13\u5b58......");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        return errMap;
    }

    private List<CurrentMonthDeliveryDto> validate(LinkedHashMap<Integer, CurrentMonthDeliveryImportsVo> data, Map<String, Object> params, Map<Integer, String> errMap) {
        List productVos;
        List customerVos;
        String platformCode = (String)params.get("platformCode");
        String platformName = (String)params.get("platformName");
        String salesOrgCode = (String)params.get("salesOrgCode");
        String businessModelCode = (String)params.get("businessModelCode");
        String channelCode = (String)params.get("channelCode");
        String businessFormatCode = (String)params.get("businessFormatCode");
        log.info("\u5f00\u59cb\u67e5\u8be2\u5173\u8054\u6570\u636e......");
        TpmSalesVolumeChannelDto salesVolumeChannelDto = new TpmSalesVolumeChannelDto();
        salesVolumeChannelDto.setPlatformCode(platformCode);
        Result result = this.tpmSalesVolumeChannelServiceFeign.findByConditions((Pageable)PageRequest.of((int)1, (int)50), salesVolumeChannelDto);
        List channelList = ((Page)result.getResult()).getRecords();
        log.info("\u7ed3\u675f\u67e5\u8be2\u5173\u8054\u6570\u636e......");
        log.info("\u5f00\u59cb\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        Set customerCodeSet = data.values().stream().map(CurrentMonthDeliveryImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productCodeSet = data.values().stream().map(CurrentMonthDeliveryImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        data.forEach((k, v) -> v.setIndex(k));
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> productVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(TpmSalesVolumeChannelVo::getSalesVolumeChannel, item -> item));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(productVos = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodeSet))))) {
            productVoMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        log.info("\u7ed3\u675f\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), CurrentMonthDeliveryImportsVo.class, CurrentMonthDeliveryDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        log.info("\u5f00\u59cb\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        for (CurrentMonthDeliveryDto dto : dtoList) {
            try {
                if (customerVoMap.containsKey(dto.getCustomerCode())) {
                    List customerVoList = (List)customerVoMap.get(dto.getCustomerCode());
                    CustomerVo customerVo = customerVoList.stream().filter(e -> channelCode.equals(e.getCustomerChannelCode()) && salesOrgCode.equals(e.getSalesInstitutionCode()) && businessFormatCode.equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                    if (customerVo != null) {
                        dto.setCustomerName(customerVo.getCustomerName());
                        dto.setCustomerCode(customerVo.getCustomerCode());
                        dto.setErpCode(customerVo.getErpCode());
                    } else {
                        this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                } else {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (productVoMap.containsKey(dto.getProductCode())) {
                    ProductVo productVo = (ProductVo)productVoMap.get(dto.getProductCode());
                    dto.setProductName(productVo.getProductName());
                    dto.setProductBrandCode(productVo.getProductBrandCode());
                    dto.setProductBrandName(productVo.getProductBrandName());
                    dto.setTaxRate(productVo.getRate());
                    dto.setRatio(productVo.getNetWeight() == null ? BigDecimal.ZERO : productVo.getNetWeight());
                } else {
                    this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u3010" + dto.getProductCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getChannelName())) {
                    if (channelVoMap.containsKey(dto.getChannelName())) {
                        dto.setChannelCode(((TpmSalesVolumeChannelVo)channelVoMap.get(dto.getChannelName())).getSalesVolumeChannelCode());
                    } else {
                        this.validateIsTrue(false, "\u7535\u5546\u6e20\u9053\u3010" + dto.getChannelName() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                log.info("dto.getProductCode()=" + dto.getProductCode() + "\u3001getErpCode=" + dto.getErpCode() + "\u3001businessModelCode=" + businessModelCode + "\u3001getStartDate=" + DateUtil.format((Date)dto.getStartDate(), (String)"yyyy-MM-dd"));
                ProductPlanningDetailsVo feeVo = null;
                try {
                    feeVo = this.productVoService.findByProductPlanningDetails(dto.getProductCode(), dto.getErpCode(), businessModelCode, DateUtil.format((Date)dto.getStartDate(), (String)"yyyy-MM-dd"));
                }
                catch (Exception e2) {
                    this.validateIsTrue(false, "\u4ef7\u683c\u7ba1\u7406\u67e5\u8be2\u6570\u636e\u4e0d\u4e0d\u5b58\u5728");
                }
                if (Objects.nonNull(feeVo)) {
                    dto.setPlatformSupplyPrice(feeVo.getPlatformSupplyPrice());
                    dto.setStandardRetailPrice(feeVo.getStandardRetailPrice());
                    dto.setRedLinePrice(feeVo.getRedLinePrice());
                    dto.setCostPrice(feeVo.getCostPrice());
                }
                this.validateIsTrue(dto.getPlatformSupplyPrice() != null, "\u4ea7\u54c1\u3010" + dto.getProductCode() + "\u3011\u7684\u6807\u51c6\u96f6\u552e\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(dto.getStandardRetailPrice() != null, "\u4ea7\u54c1\u3010" + dto.getProductCode() + "\u3011\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(dto.getCostPrice() != null, "\u4ea7\u54c1\u3010" + dto.getProductCode() + "\u3011\u6210\u672c\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put(dto.getIndex(), errInfo);
                    continue;
                }
                log.info("\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97......");
                log.info("\u5f00\u59cb\u5185\u90e8\u81ea\u52a8\u8ba1\u7b97......");
                this.currentMonthDeliveryService.calculationFee(dto, platformName);
                log.info("\u7ed3\u675f\u5185\u90e8\u81ea\u52a8\u8ba1\u7b97......");
                log.info("\u5f00\u59cb\u7533\u8bf7\u89c4\u5219\u63a5\u53e3\u81ea\u52a8\u8ba1\u7b97......");
                MonthDeliveryPromotionPlanAmountDto amountDto = (MonthDeliveryPromotionPlanAmountDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MonthDeliveryPromotionPlanAmountDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                amountDto.setPlatformCode(platformCode);
                amountDto.setSalesOrgCode(salesOrgCode);
                ActivityApplyRulesPromotionPlanAmountVo amountVo = this.activityApplyRulesService.calAmountMonthDelivery(amountDto);
                log.info("\u7ed3\u675f\u7533\u8bf7\u89c4\u5219\u63a5\u53e3\u81ea\u52a8\u8ba1\u7b97......");
                log.info("\u7ed3\u675f\u81ea\u52a8\u8ba1\u7b97......");
                BeanUtils.copyProperties((Object)amountVo, (Object)dto);
                dto.setId(UUID.randomUUID().toString().replace("-", ""));
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setTenantCode(TenantUtils.getTenantCode());
                dto.setEndDate((Date)DateUtil.parse((CharSequence)(DateUtil.format((Date)dto.getEndDate(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                e3.printStackTrace();
            }
        }
        log.info("\u7ed3\u675f\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        return new ArrayList<CurrentMonthDeliveryDto>(dtoList);
    }

    public Class<CurrentMonthDeliveryImportsVo> findCrmExcelVoClass() {
        return CurrentMonthDeliveryImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_PP_CURRENT_MONTH_DELIVERY_IMPORT";
    }

    public String getTemplateName() {
        return "\u4fc3\u9500\u89c4\u5212-\u5f53\u6708\u9001\u8d27\u5bfc\u5165";
    }
}

