/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesImportsVo;
import com.biz.crm.tpm.business.sales.volume.channel.feign.feign.TpmSalesVolumeChannelServiceFeign;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.TpmSalesVolumeChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GeneralExpensesImportsProcess
implements ImportProcess<GeneralExpensesImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(GeneralExpensesImportsProcess.class);
    @Autowired(required=false)
    PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private TpmSalesVolumeChannelServiceFeign tpmSalesVolumeChannelServiceFeign;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;

    public Integer getBatchCount() {
        return 10000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, GeneralExpensesImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("platformCode"), (String)"\u5e73\u53f0\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("platformName"), (String)"\u5e73\u53f0\u540d\u79f0\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("salesOrgCode"), (String)"\u7ec4\u7ec7\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("businessModelCode"), (String)"\u4e1a\u52a1\u6a21\u5f0f\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("channelCode"), (String)"\u6e20\u9053\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("businessFormatCode"), (String)"\u4e1a\u6001\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        for (Map.Entry<Integer, GeneralExpensesImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            GeneralExpensesImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityTypeCode()), "\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormCode()), "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getStartDate() != null, "\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getEndDate() != null, "\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getCustomerCode() != null, "\u5ba2\u6237\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getApplyAmount() != null, "\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getAuditWayName()), "\u7ed3\u6848\u65b9\u5f0f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getAuditConditionType()), "\u6838\u9500\u6761\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, GeneralExpensesImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            log.info("\u5f00\u59cb\u5bfc\u5165......");
            String cacheKey = (String)params.get("cacheKey");
            log.info("\u5f00\u59cb\u5bfc\u5165\u6821\u9a8c......");
            List<GeneralExpensesDto> importList = this.validate(data, params, errMap);
            log.info("\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f......");
            if (errMap.isEmpty()) {
                log.info("\u5f00\u59cb\u5bfc\u5165\u7f13\u5b58......");
                this.generalExpensesService.addListCache(cacheKey, importList);
                log.info("\u7ed3\u675f\u5bfc\u5165\u7f13\u5b58......");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        return errMap;
    }

    private List<GeneralExpensesDto> validate(LinkedHashMap<Integer, GeneralExpensesImportsVo> data, Map<String, Object> params, Map<Integer, String> errMap) {
        List activityFormList;
        List activityTypeList;
        List monthBudgetList;
        List productVos;
        List customerVos;
        String platformCode = (String)params.get("platformCode");
        String salesOrgCode = (String)params.get("salesOrgCode");
        String channelCode = (String)params.get("channelCode");
        String businessFormatCode = (String)params.get("businessFormatCode");
        log.info("\u5f00\u59cb\u67e5\u8be2\u5173\u8054\u6570\u636e......");
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("tpm_promotion_type", "tpm_audit_type", "tpm_audit_form"));
        TpmSalesVolumeChannelDto salesVolumeChannelDto = new TpmSalesVolumeChannelDto();
        salesVolumeChannelDto.setPlatformCode(platformCode);
        Result result = this.tpmSalesVolumeChannelServiceFeign.findByConditions((Pageable)PageRequest.of((int)1, (int)500), salesVolumeChannelDto);
        List channelList = ((Page)result.getResult()).getRecords();
        log.info("\u7ed3\u675f\u67e5\u8be2\u5173\u8054\u6570\u636e......");
        log.info("\u5f00\u59cb\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> productCodeSet = new HashSet<String>();
        HashSet<String> monthBudgetCodes = new HashSet<String>();
        HashSet<String> activityTypeCodes = new HashSet<String>();
        HashSet<String> activityFormCodes = new HashSet<String>();
        for (GeneralExpensesImportsVo importVo : data.values()) {
            if (StringUtils.isNotBlank((CharSequence)importVo.getCustomerCode())) {
                customerCodeSet.add(importVo.getCustomerCode());
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getProductCode())) {
                productCodeSet.add(importVo.getProductCode());
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getMonthBudgetCode())) {
                monthBudgetCodes.add(importVo.getMonthBudgetCode());
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getActivityTypeCode())) {
                activityTypeCodes.add(importVo.getActivityTypeCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)importVo.getActivityFormCode())) continue;
            activityFormCodes.add(importVo.getActivityFormCode());
        }
        data.forEach((k, v) -> v.setIndex(k));
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> productVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        Map<Object, Object> monthBudgetMap = new HashMap();
        Map<Object, Object> activityTypeMap = new HashMap();
        Map<Object, Object> activityFormMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(TpmSalesVolumeChannelVo::getSalesVolumeChannel, item -> item));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productCodeSet) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(productVos = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodeSet))))) {
            productVoMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(monthBudgetCodes) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(monthBudgetList = this.monthBudgetService.findBusinessPolicyByCodes(new ArrayList(monthBudgetCodes))))) {
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(activityTypeList = this.activityTypeService.findByCodes(new ArrayList(activityTypeCodes))))) {
            activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity()));
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(activityFormList = this.activityFormService.findActivityFormByCode(activityFormCodes)))) {
            activityFormMap = activityFormList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        }
        log.info("\u7ed3\u675f\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), GeneralExpensesImportsVo.class, GeneralExpensesDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        log.info("\u5f00\u59cb\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        for (GeneralExpensesDto dto : dtoList) {
            try {
                DictDataVo auditWay;
                if (customerVoMap.containsKey(dto.getCustomerCode())) {
                    List customerVoList = (List)customerVoMap.get(dto.getCustomerCode());
                    CustomerVo customerVo = customerVoList.stream().filter(e -> channelCode.equals(e.getCustomerChannelCode()) && salesOrgCode.equals(e.getSalesInstitutionCode()) && businessFormatCode.equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                    if (customerVo != null) {
                        dto.setCustomerName(customerVo.getCustomerName());
                        dto.setCustomerCode(customerVo.getCustomerCode());
                        dto.setErpCode(customerVo.getErpCode());
                    } else {
                        this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                } else {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
                    if (productVoMap.containsKey(dto.getProductCode())) {
                        ProductVo productVo = (ProductVo)productVoMap.get(dto.getProductCode());
                        dto.setProductName(productVo.getProductName());
                        dto.setProductBrandCode(productVo.getProductBrandCode());
                        dto.setProductBrandName(productVo.getProductBrandName());
                    } else {
                        this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getChannelName())) {
                    if (channelVoMap.containsKey(dto.getChannelName())) {
                        dto.setChannelCode(((TpmSalesVolumeChannelVo)channelVoMap.get(dto.getChannelName())).getSalesVolumeChannelCode());
                    } else {
                        this.validateIsTrue(false, "\u7535\u5546\u6e20\u9053\u3010" + dto.getChannelName() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getMonthBudgetCode())) {
                    if (monthBudgetMap.containsKey(dto.getMonthBudgetCode())) {
                        MonthBudgetBusinessPolicyQueryVo monthBudget = (MonthBudgetBusinessPolicyQueryVo)monthBudgetMap.get(dto.getMonthBudgetCode());
                        dto.setBudgetItemCode1(monthBudget.getFirstBudgetItemCode());
                        dto.setBudgetItemCode2(monthBudget.getSecondBudgetItemCode());
                        dto.setBudgetItemCode3(monthBudget.getBudgetItemCode());
                        dto.setBudgetItemName1(monthBudget.getFirstBudgetItemName());
                        dto.setBudgetItemName2(monthBudget.getSecondBudgetItemName());
                        dto.setBudgetItemName3(monthBudget.getBudgetItemName());
                    } else {
                        this.validateIsTrue(false, "\u5173\u8054\u9884\u7b97\u3010" + dto.getMonthBudgetCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                if (activityTypeMap.containsKey(dto.getActivityTypeCode())) {
                    dto.setActivityTypeName(((ActivityTypeVo)activityTypeMap.get(dto.getActivityTypeCode())).getActivityTypeName());
                } else {
                    this.validateIsTrue(false, "\u6d3b\u52a8\u7c7b\u578b\u3010" + dto.getActivityTypeCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (activityFormMap.containsKey(dto.getActivityFormCode())) {
                    dto.setActivityFormName(((ActivityFormVo)activityFormMap.get(dto.getActivityFormCode())).getActivityFormName());
                } else {
                    this.validateIsTrue(false, "\u6d3b\u52a8\u5f62\u5f0f\u3010" + dto.getActivityFormCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionTypeCode())) {
                    DictDataVo promotionType = ((List)dictDataMap.get("tpm_promotion_type")).stream().filter(e -> e.getDictValue().equals(dto.getPromotionTypeCode())).findFirst().orElse(null);
                    if (promotionType != null) {
                        dto.setPromotionTypeCode(promotionType.getDictCode());
                    } else {
                        this.validateIsTrue(false, "\u4fc3\u9500\u7c7b\u578b\u3010" + dto.getPromotionTypeCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                if ((auditWay = (DictDataVo)((List)dictDataMap.get("tpm_audit_form")).stream().filter(e -> e.getDictValue().equals(dto.getAuditWayName())).findFirst().orElse(null)) != null) {
                    dto.setAuditWayCode(auditWay.getDictCode());
                } else {
                    this.validateIsTrue(false, "\u7ed3\u6848\u65b9\u5f0f\u3010" + dto.getPromotionTypeCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                DictDataVo auditType = ((List)dictDataMap.get("tpm_audit_type")).stream().filter(e -> e.getDictValue().equals(dto.getAuditConditionType())).findFirst().orElse(null);
                if (auditType != null) {
                    dto.setAuditConditionType(auditType.getDictCode());
                } else {
                    this.validateIsTrue(false, "\u6838\u9500\u6761\u4ef6\u3010" + dto.getPromotionTypeCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put(dto.getIndex(), errInfo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)dto.getId())) {
                    dto.setId(UUID.randomUUID().toString().replace("-", ""));
                }
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEndDate((Date)DateUtil.parse((CharSequence)(DateUtil.format((Date)dto.getEndDate(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
                dto.setYearMonthLy(DateUtil.format((Date)dto.getStartDate(), (String)"yyyy-MM"));
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                e2.printStackTrace();
            }
        }
        log.info("\u7ed3\u675f\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        return new ArrayList<GeneralExpensesDto>(dtoList);
    }

    public Class<GeneralExpensesImportsVo> findCrmExcelVoClass() {
        return GeneralExpensesImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_PP_GENERAL_EXPENSES_IMPORT";
    }

    public String getTemplateName() {
        return "\u4fc3\u9500\u89c4\u5212-\u8d39\u7528\u7533\u8bf7\u5bfc\u5165";
    }
}

