/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionFeeApportionDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionFeeApportionService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionFeeApportionImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PromotionFeeApportionImportsProcess
implements ImportProcess<PromotionFeeApportionImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(PromotionFeeApportionImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private PromotionFeeApportionService promotionFeeApportionService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, PromotionFeeApportionImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List activityFormList;
        List customerVos;
        List orgVos;
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        Map<Object, Object> activityFormMap = new HashMap();
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> orgCodeSet = new HashSet<String>();
        HashSet<Object> uniqueKeySet = new HashSet<Object>();
        HashSet<String> activityFormCodes = new HashSet<String>();
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList(MDM_BUSINESS_FORMAT));
        for (Integer k : data.keySet()) {
            PromotionFeeApportionImportsVo vo = data.get(k);
            DictDataVo businessFormat = ((List)dictDataMap.get(MDM_BUSINESS_FORMAT)).stream().filter(e -> e.getDictValue().equals(vo.getBusinessFormatCode())).findFirst().orElse(null);
            if (businessFormat != null) {
                vo.setBusinessFormatCode(businessFormat.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001\u3010" + vo.getBusinessFormatCode() + "\u3011\u9519\u8bef!");
            }
            channelCodeSet.add(vo.getChannelCode());
            orgCodeSet.add(vo.getSalesInstitutionCode());
            customerCodeSet.add(vo.getCustomerCode());
            activityFormCodes.add(vo.getActivityFormCode());
            String uniqueKey = businessFormat.getDictCode() + vo.getChannelCode() + vo.getSalesInstitutionCode() + vo.getCustomerCode() + vo.getYearMonthLy() + vo.getActivityFormCode();
            this.validateIsTrue(!uniqueKeySet.contains(uniqueKey), "\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e");
            uniqueKeySet.add(uniqueKey);
            data.get(k).setUniqueKey(uniqueKey);
            data.get(k).setBusinessFormatCode(businessFormat.getDictCode());
        }
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(orgCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(activityFormList = this.activityFormService.findActivityFormByCode(activityFormCodes)))) {
            activityFormMap = activityFormList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        }
        for (Integer k : data.keySet()) {
            PromotionFeeApportionImportsVo vo = data.get(k);
            if (activityFormMap.containsKey(vo.getActivityFormCode())) {
                data.get(k).setActivityFormName(((ActivityFormVo)activityFormMap.get(vo.getActivityFormCode())).getActivityFormName());
            } else {
                this.validateIsTrue(false, "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u3010" + vo.getActivityFormCode() + "\u3011\u9519\u8bef\uff01");
            }
            if (channelVoMap.containsKey(vo.getChannelCode())) {
                data.get(k).setChannelName(((CustomerChannelVo)channelVoMap.get(vo.getChannelCode())).getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801\u3010" + vo.getChannelCode() + "\u3011\u9519\u8bef\uff01");
            }
            SalesOrgVo salesOrgVo = null;
            if (orgVoMap.containsKey(vo.getSalesInstitutionCode())) {
                List orgList = (List)orgVoMap.get(vo.getSalesInstitutionCode());
                salesOrgVo = orgList.stream().filter(e -> vo.getChannelCode().equals(e.getChannelCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo == null) {
                    this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + vo.getSalesInstitutionCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u9500\u552e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    data.get(k).setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    data.get(k).setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    data.get(k).setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + vo.getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff01");
            }
            if (customerVoMap.containsKey(vo.getCustomerCode())) {
                SalesOrgVo finalSalesOrgVo = salesOrgVo;
                List customerList = (List)customerVoMap.get(vo.getCustomerCode());
                if (finalSalesOrgVo != null) {
                    CustomerVo customerVo = customerList.stream().filter(e -> vo.getChannelCode().equals(e.getCustomerChannelCode()) && finalSalesOrgVo.getErpCode().equals(e.getSalesInstitutionErpCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                    if (customerVo == null) {
                        this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + vo.getCustomerCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                    } else {
                        data.get(k).setCustomerCode(customerVo.getCustomerCode());
                        data.get(k).setCustomerErpCode(customerVo.getErpCode());
                        data.get(k).setCustomerName(customerVo.getCustomerName());
                        data.get(k).setPlatformCode(customerVo.getEstorePlatform());
                    }
                }
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + vo.getCustomerCode() + "\u3011\u9519\u8bef\uff01");
            }
            data.get(k).setTenantCode(TenantUtils.getTenantCode());
            data.get(k).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.get(k).setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            data.get(k).setFeeApportion(vo.getFeeApportionTotal().multiply(vo.getRatio()).setScale(2, 4));
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(k, errInfo);
        }
        if (errMap.isEmpty()) {
            Collection<PromotionFeeApportionImportsVo> values = data.values();
            this.promotionFeeApportionService.importSave(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(values, PromotionFeeApportionImportsVo.class, PromotionFeeApportionDto.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        }
        return errMap;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, PromotionFeeApportionImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        log.info("===========================\u5f00\u59cb\u6570\u636e\u6821\u9a8c");
        for (Map.Entry<Integer, PromotionFeeApportionImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            PromotionFeeApportionImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getYearMonthLy()), "\u5e74\u6708\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormCode()), "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(vo.getRatio() != null, "\u5206\u644a\u6bd4\u4f8b\u5fc5\u586b!");
            this.validateIsTrue(vo.getFeeApportionTotal() != null, "\u4fc3\u9500\u8d39\u7528\u5206\u644a\u603b\u989d(\u5143)\u5fc5\u586b!");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        log.info("===========================\u6570\u636e\u6821\u9a8c\u4fe1\u606f\uff1a" + JSONObject.toJSONString(errMap));
        return errMap;
    }

    public Class<PromotionFeeApportionImportsVo> findCrmExcelVoClass() {
        return PromotionFeeApportionImportsVo.class;
    }

    public String getTemplateCode() {
        return "PROMOTION_FEE_APPORTION_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u4fc3\u9500\u8d39\u7528\u5206\u644a\u5bfc\u5165";
    }
}

