/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanCostProgressDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanCostProgressService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressExportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanCostProgressVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PromotionPlanCostProgressExportsProcess
implements ExportProcess<PromotionPlanCostProgressExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanCostProgressExportsProcess.class);
    @Autowired(required=false)
    private PromotionPlanCostProgressService promotionPlanCostProgressService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Integer getTotal(Map<String, Object> params) {
        PromotionPlanCostProgressDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.promotionPlanCostProgressService.findCostProgressByConditions((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      \u9500\u552e\u8d39\u7528\u6279\u590d\u8868\u5bfc\u51fa[{}]    <=====", (Object)JSON.toJSONString((Object)vo));
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        PromotionPlanCostProgressDto dto = this.convertParams(params);
        Page pageResult = this.promotionPlanCostProgressService.findCostProgressByConditions((Pageable)pageable, dto);
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        this.adjustData(records);
        Collection data = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, PromotionPlanCostProgressVo.class, PromotionPlanCostProgressExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return JSON.parseArray((String)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public String getBusinessCode() {
        return "PROMOTION_PLAN_COST_PROGRESS_EXPORT";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private PromotionPlanCostProgressDto convertParams(Map<String, Object> params) {
        return (PromotionPlanCostProgressDto)JSON.parseObject((String)JSON.toJSONString(params), PromotionPlanCostProgressDto.class);
    }

    private void adjustData(Collection<PromotionPlanCostProgressVo> data) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_model"}));
        for (PromotionPlanCostProgressVo vo : data) {
            vo.setBusinessModelCode(this.findDictValue(mapDict, "mdm_business_model", String.valueOf(vo.getBusinessModelCode())));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessName() {
        return "TPM\u8d39\u7528\u8fdb\u5ea6\u76d1\u63a7\u5bfc\u51fa";
    }
}

