/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanTableFormRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanTableFormDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PromotionPlanTableFormProcess
implements ExportProcess<PromotionPlanTableFormExportVo> {
    @Autowired(required=false)
    private PromotionPlanTableFormRepository promotionPlanTableFormRepository;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        PromotionPlanTableFormDto dto = this.convertParams(params);
        Page<PromotionPlanTableFormExportVo> pageResult = this.promotionPlanTableFormRepository.findExportByConditions((Page<PromotionPlanTableFormDto>)new Page(0L, 1L), dto);
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return (int)pageResult.getTotal();
    }

    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        if (processVo.getPageNo() == null || processVo.getPageSize() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        processVo.setPageNo(Integer.valueOf(processVo.getPageNo() + 1));
        PromotionPlanTableFormDto dto = this.convertParams(params);
        Page pageable = new Page((long)(processVo.getPageNo() + 1), (long)this.getPageSize().intValue());
        Page<PromotionPlanTableFormExportVo> page = this.promotionPlanTableFormRepository.findExportByConditions((Page<PromotionPlanTableFormDto>)pageable, dto);
        return JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()));
    }

    public Class<PromotionPlanTableFormExportVo> findCrmExcelVoClass() {
        return PromotionPlanTableFormExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_PROMOTION_PLAN_TABLE_FORM";
    }

    public String getBusinessName() {
        return "TPM-\u5e73\u53f0\u7ef4\u5ea6\u7535\u5546\u7684\u4fc3\u9500\u89c4\u5212\u4e00\u89c8\u6c47\u603b\u8868\u5bfc\u51fa";
    }

    private PromotionPlanTableFormDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
        PromotionPlanTableFormDto dto = (PromotionPlanTableFormDto)JSON.parseObject((String)JSON.toJSONString(map), PromotionPlanTableFormDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }
}

