/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.service.process;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.PurchaseSalePromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.ActivityApplyRulesService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesPromotionPlanAmountVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PurchaseSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PurchaseSaleImportsProcess
implements ImportProcess<PurchaseSaleImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSaleImportsProcess.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityApplyRulesService activityApplyRulesService;
    @Autowired(required=false)
    private PurchaseSaleService purchaseSaleService;

    public Integer getBatchCount() {
        return 10000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, PurchaseSaleImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Validate.notNull((Object)params.get("platformCode"), (String)"\u5e73\u53f0\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("platformName"), (String)"\u5e73\u53f0\u540d\u79f0\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("salesOrgCode"), (String)"\u7ec4\u7ec7\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("businessModelCode"), (String)"\u4e1a\u52a1\u6a21\u5f0f\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("customerCode"), (String)"\u5ba2\u6237\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("startDate"), (String)"\u5f00\u59cb\u65f6\u95f4\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        for (Map.Entry<Integer, PurchaseSaleImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            PurchaseSaleImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getProductCode()), "\u4ea7\u54c1\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getMonthInventoryEnd() != null, "\u672c\u6708\u671f\u672b\u5e93\u5b58\uff08\u7bb1\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getPromotionPrice() != null, "\u672c\u6708\u5e93\u5b58\u9884\u4f30\u4ef7\uff08\u5143\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtil.isNotEmpty((String)vo.getNextMonthInventoryAmountStr()), "\u6b21\u6708\u5e93\u5b58\u9884\u4f30\u552e\u4ef7\uff08\u5143\uff09\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, PurchaseSaleImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            log.info("\u5f00\u59cb\u5bfc\u5165......");
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
            String cacheKey = (String)params.get("cacheKey");
            log.info("\u5f00\u59cb\u5bfc\u5165\u6821\u9a8c......");
            this.validate(data, params, errMap);
            log.info("\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f......\u9519\u8bef\u4fe1\u606f[{}]\u6761", (Object)errMap.size());
            if (errMap.isEmpty()) {
                log.info("\u5f00\u59cb\u5bfc\u5165\u7f13\u5b58......");
                List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), PurchaseSaleImportsVo.class, PurchaseSaleDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                this.purchaseSaleService.addListCache(cacheKey, dtoList);
                log.info("\u7ed3\u675f\u5bfc\u5165\u7f13\u5b58......");
            }
        }
        catch (Exception e) {
            log.error("\u4fc3\u9500\u89c4\u5212-\u91c7\u9500\u5e93\u5b58\u5bfc\u5165\u5f02\u5e38");
            errMap.put(1, errMap.getOrDefault(1, "") + " | " + e.getMessage());
            log.error("", (Throwable)e);
        }
        return errMap;
    }

    private void validate(LinkedHashMap<Integer, PurchaseSaleImportsVo> data, Map<String, Object> params, Map<Integer, String> errMap) {
        List productVos;
        String platformCode = (String)params.get("platformCode");
        String platformName = (String)params.get("platformName");
        String salesOrgCode = (String)params.get("salesOrgCode");
        String businessModelCode = (String)params.get("businessModelCode");
        String customerCode = (String)params.get("customerCode");
        DateTime startDate = DateUtil.parse((CharSequence)((String)params.get("startDate")));
        String startDateStr = DateUtil.format((Date)startDate, (String)"yyyy-MM-dd");
        String cacheKeySale = (String)params.get("cacheKeySale");
        String cacheKeyGeneral = params.get("cacheKeyGeneral") == null ? null : (String)params.get("cacheKeyGeneral");
        log.info("\u5f00\u59cb\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        Set productCodeSet = data.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getProductCode())).map(PurchaseSaleImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap customerVoMap = new HashMap();
        HashMap productVoMap = new HashMap();
        List customerVos = this.customerVoService.findByCustomerCodes(Collections.singletonList(customerCode));
        if (!CollectionUtils.isEmpty((Collection)customerVos)) {
            customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (n, o) -> n)));
        }
        if (!CollectionUtils.isEmpty((Collection)(productVos = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (n, o) -> n)));
        }
        log.info("\u7ed3\u675f\u5173\u8054\u6570\u636e\u5c01\u88c5......");
        log.info("\u5f00\u59cb\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        data.forEach((arg_0, arg_1) -> this.lambda$validate$3(customerVoMap, customerCode, productVoMap, businessModelCode, (Date)startDate, startDateStr, errMap, platformCode, salesOrgCode, cacheKeySale, cacheKeyGeneral, arg_0, arg_1));
        log.info("\u7ed3\u675f\u6821\u9a8c\u5173\u8054\u6570\u636e\u6821\u9a8c......");
    }

    private void resetRulesAmount(PurchaseSaleImportsVo dto, ActivityApplyRulesPromotionPlanAmountVo amountVo) {
        if (dto.getFeePoolDifference() == null) {
            dto.setFeePoolDifference(amountVo.getFeePoolDifference());
        }
        if (dto.getFeePoolSaleCommission() == null) {
            dto.setFeePoolSaleCommission(amountVo.getFeePoolSaleCommission());
        }
        if (dto.getFeePoolPurchaseRebate() == null) {
            dto.setFeePoolPurchaseRebate(amountVo.getFeePoolPurchaseRebate());
        }
        if (dto.getFeePoolPut() == null) {
            dto.setFeePoolPut(amountVo.getFeePoolPut());
        }
        if (dto.getFeePoolGrossProtection() == null) {
            dto.setFeePoolGrossProtection(amountVo.getFeePoolGrossProtection());
        }
    }

    public Class<PurchaseSaleImportsVo> findCrmExcelVoClass() {
        return PurchaseSaleImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_PP_PURCHASE_SALE_IMPORT";
    }

    public String getTemplateName() {
        return "\u4fc3\u9500\u89c4\u5212-\u91c7\u9500\u5e93\u5b58\u5bfc\u5165";
    }

    private /* synthetic */ void lambda$validate$3(Map customerVoMap, String customerCode, Map productVoMap, String businessModelCode, Date startDate, String startDateStr, Map errMap, String platformCode, String salesOrgCode, String cacheKeySale, String cacheKeyGeneral, Integer index, PurchaseSaleImportsVo dto) {
        try {
            if (customerVoMap.containsKey(customerCode)) {
                CustomerVo customerVo = (CustomerVo)customerVoMap.get(customerCode);
                dto.setErpCode(customerVo.getErpCode());
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + customerCode + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (productVoMap.containsKey(dto.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(dto.getProductCode());
                dto.setProductName(productVo.getProductName());
                dto.setProductBrandCode(productVo.getProductBrandCode());
                dto.setProductBrandName(productVo.getProductBrandName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u3010" + dto.getProductCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            log.info("dto.getProductCode()=" + dto.getProductCode() + "\u3001getErpCode=" + dto.getErpCode() + "\u3001businessModelCode=" + businessModelCode + "\u3001getStartDate=" + startDate);
            ProductPlanningDetailsVo feeVo = null;
            try {
                feeVo = this.productVoService.findByProductPlanningDetails(dto.getProductCode(), dto.getErpCode(), businessModelCode, startDateStr);
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u4ef7\u683c\u7ba1\u7406\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728!");
            }
            if (StringUtil.isNotEmpty((String)dto.getNextMonthEndInventoryStr())) {
                try {
                    dto.setNextMonthEndInventory(new BigDecimal(dto.getNextMonthEndInventoryStr()));
                }
                catch (Exception e) {
                    this.validateIsTrue(false, "\u6b21\u6708\u671f\u672b\u5e93\u5b58\uff08\u7bb1\uff09\u683c\u5f0f\u9519\u8bef!");
                }
            }
            if (StringUtil.isNotEmpty((String)dto.getNextMonthInventoryAmountStr())) {
                try {
                    dto.setNextMonthInventoryAmount(new BigDecimal(dto.getNextMonthInventoryAmountStr()));
                }
                catch (Exception e) {
                    this.validateIsTrue(false, "\u6b21\u6708\u5e93\u5b58\u9884\u4f30\u552e\u4ef7\uff08\u5143\uff09\u683c\u5f0f\u9519\u8bef!");
                }
            }
            if (Objects.nonNull(feeVo)) {
                dto.setSupplyPrice(feeVo.getPlatformSupplyPrice());
                dto.setStandardRetailPrice(feeVo.getStandardRetailPrice());
                dto.setRedLinePrice(feeVo.getRedLinePrice());
                dto.setCostPrice(feeVo.getCostPrice());
            }
            this.validateIsTrue(dto.getSupplyPrice() != null, "\u4ea7\u54c1\u3010" + dto.getProductCode() + "\u3011\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(index, errInfo);
                return;
            }
            log.info("\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97......");
            log.info("\u5f00\u59cb\u7533\u8bf7\u89c4\u5219\u63a5\u53e3\u81ea\u52a8\u8ba1\u7b97......");
            PurchaseSalePromotionPlanAmountDto amountDto = (PurchaseSalePromotionPlanAmountDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PurchaseSalePromotionPlanAmountDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            amountDto.setPlatformCode(platformCode);
            amountDto.setSalesOrgCode(salesOrgCode);
            amountDto.setCustomerCode(customerCode);
            amountDto.setMonthSaleCacheKey(cacheKeySale);
            amountDto.setGeneralExpensesCacheKey(cacheKeyGeneral);
            ActivityApplyRulesPromotionPlanAmountVo amountVo = this.activityApplyRulesService.calAmountPurchaseSale(amountDto);
            BeanUtils.copyProperties((Object)amountVo, (Object)dto);
            this.resetRulesAmount(dto, amountVo);
            log.info("\u7ed3\u675f\u7533\u8bf7\u89c4\u5219\u63a5\u53e3\u81ea\u52a8\u8ba1\u7b97......");
            log.info("\u7ed3\u675f\u81ea\u52a8\u8ba1\u7b97......");
            dto.setId(UUID.randomUUID().toString().replace("-", ""));
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        catch (Exception e) {
            log.error("=====>   \u4fc3\u9500\u89c4\u5212-\u91c7\u9500\u5e93\u5b58 \u5f02\u5e38\u6570\u636e[{}]   <=====", (Object)JSON.toJSONString((Object)dto));
            log.error("", (Throwable)e);
        }
    }
}

