/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.plan.local.workFlowListener;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.promotion.plan.local.entity.PromotionPlanEntity;
import com.biz.crm.tpm.business.promotion.plan.local.repository.PromotionPlanRepository;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PromotionPlanProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanProcessCallBackListener.class);
    @Autowired(required=false)
    private PromotionPlanRepository promotionPlanRepository;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public String getBusinessCode() {
        return "promotion_plan_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        PromotionPlanEntity one = (PromotionPlanEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.promotionPlanRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(PromotionPlanEntity::getPromotionPlanCode, (Object)dto.getBusinessNo())).one());
        Validate.notNull((Object)((Object)one), (String)"\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        this.promotionPlanRepository.updateProcessStatusById(one.getId(), processStatus);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            String businessNo = one.getPromotionPlanCode();
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_PROMOTION_PLAN_PASS_DETAILED_FORECAST");
            this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            PromotionPlanDto promotionPlanDto = (PromotionPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, PromotionPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.promotionPlanService.rejectRecover(promotionPlanDto);
        }
    }
}

