package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 当月送货
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:52
 */
@Getter
@Setter
@ApiModel(value = "CurrentMonthDeliveryDto", description = "当月送货dto")
public class CurrentMonthDeliveryDto extends CurrentMonthDto {

    /**
     * 预计销售额（元）
     */
    @ApiModelProperty("预计销售额（元）")
    private BigDecimal estimatedAmount;
    /**
     * 采购返点（元）
     */
    @ApiModelProperty("采购返点（元）")
    private BigDecimal purchaseRebate;
    /**
     * 物流费用（元）
     */
    @ApiModelProperty("物流费用（元）")
    private BigDecimal logistics;
}
