package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 其他费用
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:54
 */
@Getter
@Setter
@ApiModel(value = "OtherExpensesDto", description = "其他费用dto")
public class OtherExpensesDto extends TenantFlagOpDto {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 市场费用-预算（千元）
     */
    @ApiModelProperty("市场费用-预算（千元）")
    private BigDecimal marketAmountBudget;

    /**
     * 市场费用-规划（千元）
     */
    @ApiModelProperty("市场费用-规划（千元）")
    private BigDecimal marketAmountPlan;

    /**
     * 物流费用-预算（千元）
     */
    @ApiModelProperty("物流费用-预算（千元）")
    private BigDecimal logisticsAmountBudget;

    /**
     * 物流费用-规划（千元）
     */
    @ApiModelProperty("物流费用-规划（千元）")
    private BigDecimal logisticsAmountPlan;

    /**
     * 行政管理费用-预算（千元）
     */
    @ApiModelProperty("行政管理费用-预算（千元）")
    private BigDecimal adminAmountBudget;

    /**
     * 行政管理费用-规划（千元）
     */
    @ApiModelProperty("行政管理费用-规划（千元）")
    private BigDecimal adminAmountPlan;

    /**
     * 人力成本-预算（千元）
     */
    @ApiModelProperty("人力成本-预算（千元）")
    private BigDecimal humanAmountBudget;

    /**
     * 人力成本-规划（千元）
     */
    @ApiModelProperty("人力成本-规划（千元）")
    private BigDecimal humanAmountPlan;

    /**
     * 是否选中，0否1是
     */
    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 费用归属年月
     */
    @ApiModelProperty("费用归属年月")
    private String yearMonthLy;

    /**
     * 业务模式
     */
    @ApiModelProperty("业务模式")
    private String businessModelCode;
}
