package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 促销规划dto
 *
 * @author: yaoyongming
 * @date: 2022/11/3 9:51
 */
@Getter
@Setter
@ApiModel(value = "PromotionPlanDto", description = "促销规划dto")
public class PromotionAllResultDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "年月", notes = "年月")
    private String yearAndMonth;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    private BigDecimal plan;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    private BigDecimal planVsBudget;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    private BigDecimal planTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    private BigDecimal budgetTotal;

    /**
     * 累计实际&规划(当月)
     */
    @ApiModelProperty("累计实际&规划(当月)")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划(当月+上月)
     */
    @ApiModelProperty("累计实际&规划(当月+上月)")
    private BigDecimal actualPlanMonth;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    private BigDecimal actualPlanVsBudget;

    /**
     * 使用进度
     */
    @ApiModelProperty("使用进度")
    private BigDecimal useProgress;

}
