package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/8/29 16:00
 */
@Data
@ApiModel(value = "PromotionFeeApportionDto", description = "促销费用分摊dto")
public class PromotionFeeApportionDto extends TenantFlagOpDto {

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    private String uniqueKey;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构ERP编码
     */
    @ApiModelProperty("销售机构ERP编码")
    private String salesInstitutionErpCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 分摊比例
     */
    @ApiModelProperty("分摊比例")
    private BigDecimal ratio;

    /**
     * 促销费用分摊总额(元)
     */
    @ApiModelProperty("促销费用分摊总额(元)")
    private BigDecimal feeApportionTotal;

    /**
     * 分摊销售额
     */
    @ApiModelProperty("分摊销售额")
    private BigDecimal feeApportion;
}
