package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author: yaoyongming
 * @date: 2023/7/28 14:48
 */
@Getter
@Setter
@ApiModel(value = "PromotionPlanDto", description = "费用进度监控查询dto")
public class PromotionPlanCostProgressDto extends TenantFlagOpDto {

    /**
     * 费用归属年月
     */
    @ApiModelProperty("费用归属年月")
    private String yearMonthLy;

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String platformName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;
}
