package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 促销规划dto
 *
 * @author: yaoyongming
 * @date: 2022/11/3 9:51
 */
@Getter
@Setter
@ApiModel(value = "PromotionPlanDto", description = "促销规划dto")
public class PromotionPlanDto extends TenantFlagOpDto {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划时间开始
     */
    @ApiModelProperty("促销规划时间开始")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 促销规划时间结束
     */
    @ApiModelProperty("促销规划时间结束")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 业务模式
     */
    @ApiModelProperty("业务模式")
    private String businessModelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesOrgCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesOrgName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String platformName;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 预算所属客户编码
     */
    @ApiModelProperty("预算所属客户编码")
    private String customerProfitLossCode;

    /**
     * 预算所属客户ERP编码
     */
    @ApiModelProperty("预算所属客户ERP编码")
    private String customerProfitLossErpCode;

    /**
     * 预算所属客户名称
     */
    @ApiModelProperty("预算所属客户名称")
    private String customerProfitLossName;

    /**
     * 总申请金额
     */
    @ApiModelProperty("总申请金额")
    private BigDecimal totalApplyAmount;

    /**
     * 费用申请
     */
    @ApiModelProperty("费用申请")
    private List<GeneralExpensesDto> generalExpensesDtos;

    /**
     * 当月销售
     */
    @ApiModelProperty("当月销售")
    private List<CurrentMonthSaleDto> currentMonthSaleDtos;

    /**
     * 当月送货
     */
    @ApiModelProperty("当月送货")
    private List<CurrentMonthDeliveryDto> currentMonthDeliveryDtos;

    /**
     * 采销库存
     */
    @ApiModelProperty("采销库存")
    private List<PurchaseSaleDto> purchaseSaleDtos;

    /**
     * 其他费用
     */
    @ApiModelProperty("其他费用")
    private List<OtherExpensesDto> otherExpensesDtos;

    /**
     * 审批流程编码
     */
    @ApiModelProperty("审批流程编码")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("结案方式")
    private String auditWayCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    private String erpCode;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;


    @ApiModelProperty(value = "业务单元编码")
    private String businessUnitCode;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String positionCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String positionName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty("销售部门编码")
    private String salesDepartmentCode;

    /**
     * 销售部门名称
     */
    @ApiModelProperty("销售部门名称")
    private String salesDepartmentName;

    /**
     * 销售组编码
     */
    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    /**
     * 销售组名称
     */
    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    /**
     * 核销查询标识
     */
    @ApiModelProperty("核销查询标识")
    private String auditQuery;

    @ApiModelProperty("是否完全结案")
    private String wholeAudit;
    /**
     * 查询标记
     */
    private String auditVerification;

    @ApiModelProperty("预付年月")
    private String advanceYearMonth;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;


    @ApiModelProperty("促销规划时间开始")
    private String startDateStr;

    @ApiModelProperty("促销规划时间结束")
    private String endDateStr;
}
