package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 平台维度电商的促销规划一览汇总表dto
 *
 * @author: cyj
 * @date: 2022/12/23 11:04
 */
@Data
@ApiModel("平台维度电商的促销规划一览汇总表dto")
public class PromotionPlanTableFormDto extends TenantFlagOpDto {

    @ApiModelProperty("销售部门编码")
    private String salesDepartmentCode;

    @ApiModelProperty("销售部门名称")
    private String salesDepartmentName;

    @ApiModelProperty("平台编码")
    private String platformCode;

    @ApiModelProperty("平台名称")
    private String platformName;

    @ApiModelProperty("同期净收入")
    private BigDecimal netIncomeContemporaneous;

    @ApiModelProperty("预算净收入")
    private BigDecimal netIncomeBudget;

    @ApiModelProperty("规划净收入")
    private BigDecimal netIncomePlan;

    @ApiModelProperty("净收入达成")
    private BigDecimal incomeAchievement;

    @ApiModelProperty("VS同期（净收入）")
    private BigDecimal vsContemporaneous;

    @ApiModelProperty("VS预算（净收入）")
    private BigDecimal vsBudget;

    @ApiModelProperty("同期专项费用率")
    private BigDecimal contemporaneousSpecialExpenseRate;

    @ApiModelProperty("预算专项费用率")
    private BigDecimal budgetSpecialExpenseRate;

    @ApiModelProperty("规划专项费用率")
    private BigDecimal planSpecialExpenseRate;

    @ApiModelProperty("VS同期（费用率）")
    private BigDecimal expenseRateVsContemporaneous;

    @ApiModelProperty("VS预算（费用率）")
    private BigDecimal expenseRateVsBudget;

    @ApiModelProperty("预算净利润")
    private BigDecimal budgetNetProfit;

    @ApiModelProperty("规划净利润")
    private BigDecimal plannedNetProfit;

    @ApiModelProperty("预算净利率")
    private BigDecimal budgetProfitMargin;

    @ApiModelProperty("规划净利率")
    private BigDecimal plannedProfitMargin;

    @ApiModelProperty("净利率达成")
    private BigDecimal profitMarginReached;

    @ApiModelProperty(name = "年月", notes = "年月")
    private String yearAndMonth;

    @ApiModelProperty(name = "唯一键", notes = "唯一键")
    private String onlyKey;

    @ApiModelProperty(name = "层级", notes = "1=部门,2=平台")
    private String levelCode;
}
