package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 18:30
 */
@Data
@ApiModel("dto")
public class PromotionPlanWholeSummaryDto extends TenantFlagOpDto {

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String wholeSummaryName;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;
    /**
     * 工作流参数
     */
    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;

    /**
     * 文件唯一识别号
     */
    @ApiModelProperty(value = "文件唯一识别号")
    private String fileCode;

    /**
     * 原始文件名
     */
    @ApiModelProperty(name="originalFileName" , value="原始文件名")
    private String originalFileName;
}
