package com.biz.crm.tpm.business.promotion.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 采销库存dto
 *
 * @author: yaoyongming
 * @date: 2022/11/26 14:19
 */
@Getter
@Setter
@ApiModel(value = "PurchaseSaleDto", description = "采销库存dto")
public class PurchaseSaleDto extends TenantFlagOpDto {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;

    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 供货价
     */
    @ApiModelProperty("供货价")
    private BigDecimal supplyPrice;

    /**
     * 促销售价（元）
     */
    @ApiModelProperty("促销售价（元）")
    private BigDecimal promotionPrice;

    /**
     * 本月期末库存（箱）
     */
    @ApiModelProperty("本月期末库存（箱）")
    private BigDecimal monthInventoryEnd;

    /**
     * 费用池-补差
     */
    @ApiModelProperty("费用池-补差")
    private BigDecimal feePoolDifference;

    /**
     * 费用池-销售返
     */
    @ApiModelProperty("费用池-销售返")
    private BigDecimal feePoolSaleCommission;

    /**
     * 费用池-采购返
     */
    @ApiModelProperty("费用池-采购返")
    private BigDecimal feePoolPurchaseRebate;

    /**
     * 费用池-投放
     */
    @ApiModelProperty("费用池-投放")
    private BigDecimal feePoolPut;

    /**
     * 费用池-毛保
     */
    @ApiModelProperty("费用池-毛保")
    private BigDecimal feePoolGrossProtection;

    /**
     * 是否选中，0否1是
     */
    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    private String erpCode;

    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    private BigDecimal redLinePrice;

    /**
     * 次月期末库存（箱）
     */
    @ApiModelProperty("次月期末库存（箱）")
    private BigDecimal nextMonthEndInventory;

    /**
     * 次月库存预估售价（元）
     */
    @ApiModelProperty("次月库存预估售价（元）")
    private BigDecimal nextMonthInventoryAmount;

    /**
     * 成本价
     */
    @ApiModelProperty("成本价")
    private BigDecimal costPrice;

}
