package com.biz.crm.tpm.business.promotion.plan.sdk.event.log;

import com.biz.crm.tpm.business.promotion.plan.sdk.dto.log.PromotionPlanLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 * 
 * @author: yaoyongming
 * @date: 2022/11/4 16:44
 */
public interface PromotionPlanLogEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(PromotionPlanLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(PromotionPlanLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(PromotionPlanLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(PromotionPlanLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(PromotionPlanLogEventDto eventDto);
}
