package com.biz.crm.tpm.business.promotion.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthSaleVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 当月销售实体类(CurrentMonthSaleVo)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
public interface CurrentMonthSaleService {

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param currentMonthSale 实体对象
     * @return
     */
    Page<CurrentMonthSaleVo> findByConditions(Pageable pageable, CurrentMonthSaleDto currentMonthSale);

    /**
     * 1、获取明细列表分页接口
     *
     * @param pageable     分页参数
     * @param cacheKey     缓存key
     * @param purchaseCode 促销规划编码
     * @return
     */
    Page<CurrentMonthSaleVo> findCachePageList(Pageable pageable, String cacheKey, String purchaseCode);

    /**
     * 获取缓存中的所有明细行
     *
     * @param cacheKey 缓存key
     */
    List<CurrentMonthSaleDto> findCacheList(String cacheKey);

    /**
     * 获取所有明细行
     *
     * @param code 促销规划编码
     */
    List<CurrentMonthSaleDto> findList(String code);

    /**
     * 2、新增一行接口，在缓存中行首插入一条数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void addItemCache(String cacheKey, List<CurrentMonthSaleDto> itemList);

    /**
     * 3、复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void copyItemListCache(String cacheKey, List<CurrentMonthSaleDto> itemList);

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void saveCurrentPageCache(String cacheKey, List<CurrentMonthSaleDto> saveList);

    /**
     * 7、多行删除并保存当前页数据并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void deleteCacheList(String cacheKey, List<CurrentMonthSaleDto> itemList);

    /**
     * 6、清理缓存接口
     *
     * @param cacheKey 缓存key
     */
    void clearCache(String cacheKey);

    /**
     * 获取总条数
     *
     * @param cacheKey
     * @return
     */
    Integer getTotal(String cacheKey);

    /**
     * 在缓存中加入多条数据
     *
     * @param cacheKey
     * @param itemList
     */
    void addListCache(String cacheKey, List<CurrentMonthSaleDto> itemList);

    /**
     * 自动计算费用
     *
     * @param dto
     */
    void calculationFee(CurrentMonthSaleDto dto, String platformName);
}

