package com.biz.crm.tpm.business.promotion.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用申请实体类(GeneralExpensesVo)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-03 09:32:22
 */
public interface GeneralExpensesService {

    /**
     * 分页查询数据
     *
     * @param pageable        分页对象
     * @param generalExpenses 实体对象
     * @return
     */
    Page<GeneralExpensesVo> findByConditions(Pageable pageable, GeneralExpensesDto generalExpenses);

    /**
     * 1、获取明细列表分页接口
     *
     * @param pageable     分页参数
     * @param cacheKey     缓存key
     * @param purchaseCode 促销规划编码
     * @return
     */
    Page<GeneralExpensesVo> findCachePageList(Pageable pageable, String cacheKey, String purchaseCode);

    /**
     * 获取缓存中的所有明细行
     *
     * @param cacheKey 缓存key
     */
    List<GeneralExpensesDto> findCacheList(String cacheKey);

    /**
     * 获取所有明细行
     *
     * @param code 促销规划编码
     */
    List<GeneralExpensesDto> findList(String code);

    /**
     * 根据促销规划明细编码获取明细集合
     *
     * @param codes 促销规划明细编号
     */
    List<GeneralExpensesDto> findByDetailCodeList(List<String> codes);

    /**
     * 2、新增一行接口，在缓存中行首插入一条数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void addItemCache(String cacheKey, List<GeneralExpensesDto> itemList);

    /**
     * 3、复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void copyItemListCache(String cacheKey, List<GeneralExpensesDto> itemList);

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void saveCurrentPageCache(String cacheKey, List<GeneralExpensesDto> saveList);

    /**
     * 7、多行删除并保存当前页数据并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void deleteCacheList(String cacheKey, List<GeneralExpensesDto> itemList);

    /**
     * 6、清理缓存接口
     *
     * @param cacheKey 缓存key
     */
    void clearCache(String cacheKey);

    /**
     * 新增缓存
     *
     * @param cacheKey
     * @param saveList
     */
    void addItemListCache(String cacheKey, List<GeneralExpensesDto> saveList);

    /**
     * 更新结案金额
     *
     * @param dtoList
     */
    void updateAuditAmount(List<GeneralExpensesDto> dtoList);

    /**
     * 根据明细编码查询
     *
     * @param expensesCodeList
     * @return
     */
    List<GeneralExpensesVo> findByExpensesCode(List<String> expensesCodeList);

    Page<GeneralExpensesVo> findForWithholding(Pageable pageable, String dictCode, String capital);

    /**
     * 获取总条数
     *
     * @param cacheKey
     * @return
     */
    Integer getTotal(String cacheKey);

    /**
     * 在缓存中加入多条数据
     *
     * @param cacheKey
     * @param itemList
     */
    void addListCache(String cacheKey, List<GeneralExpensesDto> itemList);

    /**
     * 获取合同金额
     * @param promotionPlanCode 促销规划编码
     * @return BigDecimal
     */
    BigDecimal getContractAmount(String promotionPlanCode);

    /**
     * 根据商务政策查询
     *
     * @param businessPolicyCodeList
     * @return
     */
    List<GeneralExpensesVo> findByBusinessPolicyCode(List<String> businessPolicyCodeList);

    boolean isOtherDetailWholeAudit(String businessPolicyCode, List<String> expensesCodes);
}

