package com.biz.crm.tpm.business.promotion.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.OtherExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.OtherExpensesVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * 其他费用实体类(OtherExpensesVo)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-03 09:32:22
 */
public interface OtherExpensesService {

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param otherExpenses 实体对象
     * @return
     */
    Page<OtherExpensesVo> findByConditions(Pageable pageable, OtherExpensesDto otherExpenses);


    /**
     * 1、获取明细列表分页接口
     *
     * @param pageable     分页参数
     * @param cacheKey     缓存key
     * @param purchaseCode 促销规划编码
     * @return
     */
    Page<OtherExpensesVo> findCachePageList(Pageable pageable, String cacheKey, String purchaseCode);

    /**
     * 获取缓存中的所有明细行
     *
     * @param cacheKey 缓存key
     */
    List<OtherExpensesDto> findCacheList(String cacheKey);

    /**
     * 2、新增一行接口，在缓存中行首插入一条数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void addItemCache(String cacheKey, String businessModelCode, String customerCode, String yearMonthLy, List<OtherExpensesDto> itemList);

    /**
     * 3、复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     *
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void copyItemListCache(String cacheKey, List<OtherExpensesDto> itemList);

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void saveCurrentPageCache(String cacheKey, List<OtherExpensesDto> saveList);

    /**
     * 7、多行删除并保存当前页数据并返回指定页数据接口
     *
     * @param cacheKey 缓存key
     */
    void deleteCacheList(String cacheKey, List<OtherExpensesDto> itemList);

    /**
     * 6、清理缓存接口
     *
     * @param cacheKey 缓存key
     */
    void clearCache(String cacheKey);

    /**
     * 获取行政规划+人力成本汇总
     *
     * @param cacheKey
     * @param purchaseCode
     * @return
     */
    BigDecimal getAdminHumanTotal(String cacheKey, String purchaseCode);

    /**
     * 获取所有明细行
     *
     * @param code 促销规划编码
     */
    List<OtherExpensesDto> findList(String code);
}

