package com.biz.crm.tpm.business.promotion.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanForEventPrepaymentDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanSubmitDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 促销规划实体类(PromotionPlanVo)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-02 18:14:37
 */
public interface PromotionPlanService {

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param promotionPlan 实体对象
     * @return
     */
    Page<PromotionPlanVo> findByConditions(Pageable pageable, PromotionPlanDto promotionPlan);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    PromotionPlanVo findById(String id);

    /**
     * 通过编码查询单条数据
     *
     * @param promotionPlanCode 编码
     * @return 单条数据
     */
    PromotionPlanVo findByCode(String promotionPlanCode);


    List<PromotionPlanVo> findByCodes(List<String> promotionPlanCodes);

    /**
     * 新增数据
     *
     * @param promotionPlan    dto对象
     * @param cacheKeySale     当月销售缓存键
     * @param cacheKeyDelivery 当月送货缓存键
     * @param cacheKeyPurchase 采销库存缓存键
     * @param cacheKeyGeneral  费用申请缓存键
     * @param cacheKeyOther    其他费用缓存键
     */
    void create(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther);

    /**
     * 修改新据
     *
     * @param promotionPlan    dto对象
     * @param cacheKeySale     当月销售缓存键
     * @param cacheKeyDelivery 当月送货缓存键
     * @param cacheKeyPurchase 采销库存缓存键
     * @param cacheKeyGeneral  费用申请缓存键
     * @param cacheKeyOther    其他费用缓存键
     */
    void update(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 分页查询费用申请
     *
     * @param pageable
     * @param promotionPlan
     * @return
     */
    Page<GeneralExpensesVo> findByConditionsGeneral(Pageable pageable, PromotionPlanDto promotionPlan);

    /**
     * 分页查询促销规划及其费用申请信息
     * @param pageable 分页对象
     * @param promotionPlan 实体对象
     * @return
     */
    Page<PromotionPlanVo> findByConditionsWithGeneralExpenses(Pageable pageable, PromotionPlanDto promotionPlan);


    /**
     * 通过明细编码查询费用申请
     *
     * @param detailCode 明细编码
     * @return 单条数据
     */
    GeneralExpensesVo findByDetailCodeGeneral(String detailCode);

    /**
     * 通过活动明细编码查询费用申请
     * @param detailCodes
     * @return
     */
    List<GeneralExpensesVo> findByDetailCodes(Set<String> detailCodes);

    /**
     * 修改费用申请
     *
     * @param vo
     * @return
     */
    void updateGeneral(GeneralExpensesVo vo);

    /**
     * 根据预估计算费用
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyGeneral
     */
    void generateGeneralExpenses(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral);

    /**
     * 提交审批
     *
     * @param promotionPlanSubmitDto
     */
    void submitApproval(PromotionPlanSubmitDto promotionPlanSubmitDto);

    /**
     * 保存并提交审批
     *
     * @param promotionPlanSubmitDto
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    void submitAndSetPass(PromotionPlanSubmitDto promotionPlanSubmitDto, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther);

    /**
     * 获取预算信息
     *
     * @param cacheKeyGeneral
     * @param cacheKeySale
     * @return
     */
    List<MonthBudgetBusinessPolicyQueryVo> getMonthBudget(String cacheKeyGeneral, String cacheKeySale, String promotionPlanCode);

    /**
     * 驳回追回
     *
     * @param promotionPlan
     */
    void rejectRecover(PromotionPlanDto promotionPlan);

    /**
     * 结果呈现
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyDelivery
     * @param cacheKeyPurchase
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    List<PromotionPlanResultVoStr> calculationResult(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther, String type);

    /**
     * 当月销售计算折扣、销管报销、行政+人力
     *
     * @param promotionPlan
     * @param cacheKeySale
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    void calculationCurrentMonthSaleFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyDelivery, String cacheKeyPurchase, String cacheKeyGeneral, String cacheKeyOther);

    /**
     * 当月送货计算折扣、销管报销、行政+人力
     *
     * @param promotionPlan
     * @param cacheKeyDelivery
     * @param cacheKeyGeneral
     * @param cacheKeyOther
     */
    void calculationCurrentMonthDeliveryFee(PromotionPlanDto promotionPlan, String cacheKeySale, String cacheKeyPurchase, String cacheKeyDelivery, String cacheKeyGeneral, String cacheKeyOther);

    List<PromotionPlanVo> findByCodeList(List<String> codeList);

    /**
     * 活动预付电商选择活动明细
     * @param pageable
     * @param dto
     * @return
     */
    Page<PromotionPlanForEventPrepaymentVo> findPromotionPlanPageListForEventPrepayment(Pageable pageable, PromotionPlanForEventPrepaymentDto dto);

    /**
     * 查询总条数
     * @param promotionPlanDto
     * @return
     */
    int findTotalByConditionsGeneral(PromotionPlanDto promotionPlanDto);

    /**
     * 根据活动明细编码查询
     * @param activityDetailCodes
     * @return
     */
    List<GeneralExpensesVo> findListByDetailCodeGeneral(Set<String> activityDetailCodes);

    /**
     * 查询活动最低价
     */
    BigDecimal getMinActivityBasePrice(CurrentMonthSaleDto currentMonthSaleDto);

    /**
     * 查询维度查询促销规划
     * @param promotionPlanDto
     * @return
     */
    List<PromotionPlanVo> findByDateConditions(PromotionPlanDto promotionPlanDto);

    /**
     * 自动核销查询电商要自动核销的数据
     * @param pageable
     * @param autoAuditParams
     * @return
     */
    Page<GeneralExpensesVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams);

    void updateAutoAuditFlag(List<String> activityDetailCodes, String falg);

    /**
     * 按客户加产品汇总
     * @return
     */
    List<CurrentMonthSaleVo> findCustomerProductMonthSaleSumList(CurrentMonthSaleDto dto);

}

