package com.biz.crm.tpm.business.promotion.plan.sdk.service;


import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PromotionPlanWholeSummaryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailStrVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanWholeSummaryDetailVo;

import java.util.LinkedHashMap;
import java.util.List;

public interface PromotionPlanWholeSummaryService {

    /**
     * 生成促销规划整体一览表
     *
     * @param yearMonthLy
     */
    void createPromotionPlanWholeSummary(String yearMonthLy);

    /**
     * 提交审批
     *
     * @param dto
     */
    void submitApproval(PromotionPlanWholeSummaryDto dto);

    /**
     * 根据年月获取一览表明细
     *
     * @param yearMonthLy
     * @return
     */
    List<PromotionPlanWholeSummaryDetailStrVo>  getPromotionPlanWholeSummaryDetail(String yearMonthLy);
}
