package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 损益预算导入vo
 *
 * @author: yaoyongming
 * @date: 2023/2/16 10:30
 */
@Data
@CrmExcelImport(startRow = 2)
public class BudgetProfitLossImportsVo extends CrmExcelVo {

    @CrmExcelColumn("*业态")
    private String businessFormatName;

    @CrmExcelColumn("*业务单元")
    private String businessUnitName;

    @CrmExcelColumn("*年月")
    private String yearMonthly;

    @CrmExcelColumn("*部门编码")
    private String departmentCode;

    @CrmExcelColumn("部门名称")
    private String departmentName;

    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    @CrmExcelColumn("销售机构")
    private String salesInstitutionName;

    @CrmExcelColumn("销售部门编码")
    private String salesOrgCode;

    @CrmExcelColumn("销售部门")
    private String salesOrgName;

    @CrmExcelColumn("销售组编码")
    private String salesGroupCode;

    @CrmExcelColumn("销售组名称")
    private String salesGroupName;

    @CrmExcelColumn("客户编码")
    private String customerCode;

    @CrmExcelColumn("客户名称")
    private String customerName;

    @CrmExcelColumn("*前台/账面")
    private String type;

    @CrmExcelColumn("销量（吨）")
    private BigDecimal salesTon;

    @CrmExcelColumn("销售额")
    private BigDecimal saleAmount;

    @CrmExcelColumn("减：增值税")
    private BigDecimal vatSub;

    @CrmExcelColumn("加：增值税-折扣税金")
    private BigDecimal vatAdd;

    @CrmExcelColumn("销售收入")
    private BigDecimal saleIncome;

    @CrmExcelColumn("减：折扣")
    private BigDecimal discountSub;

    @CrmExcelColumn("净收入")
    private BigDecimal netIncome;

    @CrmExcelColumn("减：主营税金及附加")
    private BigDecimal mainTaxSub;

    @CrmExcelColumn("直接材料")
    private BigDecimal directMaterial;

    @CrmExcelColumn("包材折扣")
    private BigDecimal packageDiscount;

    @CrmExcelColumn("变动制造费用")
    private BigDecimal variableManufacturing;

    @CrmExcelColumn("运输装卸费用")
    private BigDecimal transportHandling;

    @CrmExcelColumn("销售费用-销管报销(含税)")
    private BigDecimal saleFeeReimburse;

    @CrmExcelColumn("销售费用-销管折扣(含税)")
    private BigDecimal saleFeeSaleDiscount;

    @CrmExcelColumn("销管结案批复差异")
    private BigDecimal reimburseDiff;

    @CrmExcelColumn("销售费用-市场折扣")
    private BigDecimal saleFeeMarketDiscount;

    @CrmExcelColumn("销售费用-行销折扣（含税）")
    private BigDecimal saleFeeOperateDiscount;

    @CrmExcelColumn("边际贡献")
    private BigDecimal marginalContribution;

    @CrmExcelColumn("减：销售费用-市场报销（含税）")
    private BigDecimal saleFeeMarketReimburseSub;

    @CrmExcelColumn("市场结案批复差异")
    private BigDecimal marketDiff;

    @CrmExcelColumn("销售费用-行销报销（含税)")
    private BigDecimal saleFeeOperateReimburse;

    @CrmExcelColumn("行销批复与结案差")
    private BigDecimal operateDiff;

    @CrmExcelColumn("固定制造费用")
    private BigDecimal fixedManufacture;

    @CrmExcelColumn("销售费用--仓储费用")
    private BigDecimal saleFeeInventory;

    @CrmExcelColumn("销售费用--行政性费用")
    private BigDecimal saleFeeAdmin;

    @CrmExcelColumn("销售费用--行政性费用（人力成本）")
    private BigDecimal saleFeeAdminHuman;

    @CrmExcelColumn("公共事务专项费用")
    private BigDecimal affair;

    @CrmExcelColumn("营改增税金")
    private BigDecimal businessTaxReplacedVat;

    @CrmExcelColumn("管理费用")
    private BigDecimal manage;

    @CrmExcelColumn("管理费用（人力成本）")
    private BigDecimal manageHuman;

    @CrmExcelColumn("研发费用")
    private BigDecimal development;

    @CrmExcelColumn("研发费用（人力成本）")
    private BigDecimal developmentHuman;

    @CrmExcelColumn("其他")
    private BigDecimal others;

    @CrmExcelColumn("加：其他业务收入")
    private BigDecimal othersAdd;

    @CrmExcelColumn("减：其他业务支出")
    private BigDecimal othersSub;

    @CrmExcelColumn("经营利润")
    private BigDecimal operateProfit;

    @CrmExcelColumn("加：其他收益")
    private BigDecimal othersProfitAdd;

    @CrmExcelColumn("加：投资收益")
    private BigDecimal incomeFromInvestmentAdd;

    @CrmExcelColumn("加：净敞口套期收益")
    private BigDecimal netExposureAdd;

    @CrmExcelColumn("加：公允价值变动收益")
    private BigDecimal fairChangeAdd;

    @CrmExcelColumn("加：信用减值损失（反号）")
    private BigDecimal creditLossAdd;

    @CrmExcelColumn("加：资产减值损失（反号）")
    private BigDecimal assetLossAdd;

    @CrmExcelColumn("加：资产处置收益")
    private BigDecimal assetDisposeAdd;

    @CrmExcelColumn("加：营业外收入")
    private BigDecimal nonbusinessIncomeAdd;

    @CrmExcelColumn("减：营业外支出")
    private BigDecimal nonbusinessCostSub;

    @CrmExcelColumn("息前税前利润")
    private BigDecimal ebit;

    @CrmExcelColumn("减：财务费用")
    private BigDecimal financialExpensesSub;

    @CrmExcelColumn("所得税")
    private BigDecimal incomeTax;

    @CrmExcelColumn("净利润")
    private BigDecimal netProfit;

    @CrmExcelColumn("GMV")
    private BigDecimal gmv;

    @CrmExcelColumn("价格力度")
    private BigDecimal intensity;

    @CrmExcelColumn("消费者费用（千元）")
    private BigDecimal consumer;

    @CrmExcelColumn("渠道费用（千元）")
    private BigDecimal channel;

    @CrmExcelColumn("投放费用（千元）")
    private BigDecimal put;

    @CrmExcelColumn("平台运营费用（千元）")
    private BigDecimal platformOperate;

    @CrmExcelColumn("费用池（千元）")
    private BigDecimal feePool;
}
