package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 当月送货导出vo
 *
 * @author: yaoyongming
 * @date: 2023/2/6 15:30
 */
@Data
@CrmExcelExport
public class CurrentMonthDeliveryExportsVo extends CrmExcelVo {

    /**
     * 开始时间
     */
    @CrmExcelColumn("开始时间")
    private String startDateStr;

    /**
     * 结束时间
     */
    @CrmExcelColumn("结束时间")
    private String endDateStr;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;

    /**
     * 税率
     */
    @CrmExcelColumn("税率")
    private BigDecimal taxRate;

    /**
     * 系数
     */
    @CrmExcelColumn("净重（kg)")
    private BigDecimal ratio;

    /**
     * 标准零售价
     */
    @CrmExcelColumn("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 红线价
     */
    @CrmExcelColumn("红线价")
    private BigDecimal redLinePrice;

    /**
     * 平台供货价（元）
     */
    @CrmExcelColumn("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    /**
     * 组合数量
     */
    @CrmExcelColumn("组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 预计销量（箱）
     */
    @CrmExcelColumn("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 预计销量（吨）
     */
    @CrmExcelColumn("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    /**
     * 预计销售额（元）
     */
    @CrmExcelColumn("预计销售额（元）")
    private BigDecimal estimatedAmount;

    /**
     * 增值税（元）
     */
    @CrmExcelColumn("增值税（元）")
    private BigDecimal vat;

    /**
     * 渠道推广费（元）
     */
    @CrmExcelColumn("渠道推广费（元）")
    private BigDecimal channelPromotionFee;

    /**
     * 采购返点（元）
     */
    @CrmExcelColumn("采购返点（元）")
    private BigDecimal purchaseRebate;

    /**
     * 折扣（元）
     */
    @CrmExcelColumn("折扣（元）")
    private BigDecimal discount;

    /**
     * 净收入（元）
     */
    @CrmExcelColumn("净收入（元）")
    private BigDecimal netIncome;

    /**
     * 毛利（元）
     */
    @CrmExcelColumn("毛利（元）")
    private BigDecimal grossProfit;

    /**
     * 销管报销（元）
     */
    @CrmExcelColumn("销管报销（元）")
    private BigDecimal saleReimburse;

    /**
     * 行政+人力（元）
     */
    @CrmExcelColumn("行政+人力（元）")
    private BigDecimal adminHuman;

    /**
     * 经营利润（元）
     */
    @CrmExcelColumn("经营利润（元）")
    private BigDecimal operateProfit;

    /**
     * 所得税（元）
     */
    @CrmExcelColumn("所得税（元）")
    private BigDecimal incomeTax;

    /**
     * 净利润（元）
     */
    @CrmExcelColumn("净利润（元）")
    private BigDecimal netProfit;

    /**
     * 净利率
     */
    @CrmExcelColumn("净利率")
    private BigDecimal netProfitRate;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;
}
