package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 当月送货导入vo
 *
 * @author: yaoyongming
 * @date: 2023/1/11 9:21
 */
@Data
@CrmExcelImport(startRow = 2)
public class CurrentMonthDeliveryImportsVo extends CrmExcelVo {

    /**
     * 开始时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn("*开始时间")
    private Date startDate;

    /**
     * 结束时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn("*结束时间")
    private Date endDate;

    /**
     * 客户编码
     */
    @CrmExcelColumn("*客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 电商渠道
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("*产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 组合数量
     */
    @CrmExcelColumn("*组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 预计销量（箱）
     */
    @CrmExcelColumn("*预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;

    private Integer index;
}
