package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 当月销售-分销导出vo
 *
 * @author: yaoyongming
 * @date: 2023/2/6 14:05
 */
@Data
@CrmExcelExport
public class CurrentMonthSaleDistributionExportsVo extends CrmExcelVo {

    /**
     * 开始时间
     */
    @CrmExcelColumn("开始时间")
    private String startDateStr;

    /**
     * 结束时间
     */
    @CrmExcelColumn("结束时间")
    private String endDateStr;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;

    /**
     * 税率
     */
    @CrmExcelColumn("税率")
    private BigDecimal taxRate;

    /**
     * 系数
     */
    @CrmExcelColumn("净重（kg)")
    private BigDecimal ratio;

    /**
     * 标准零售价
     */
    @CrmExcelColumn("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 红线价
     */
    @CrmExcelColumn("红线价")
    private BigDecimal redLinePrice;

    /**
     * 平台供货价（元）
     */
    @CrmExcelColumn("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    /**
     * 活动底价（元）
     */
    @CrmExcelColumn("活动底价（元）")
    private BigDecimal activityBasePrice;

    /**
     * 组合数量
     */
    @CrmExcelColumn("组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 促销类型编码
     */
    @CrmExcelColumn("促销类型")
    private String promotionTypeCode;

    /**
     * 预计销量（箱）
     */
    @CrmExcelColumn("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 预计销量（吨）
     */
    @CrmExcelColumn("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    /**
     * 预计折前销售额（元）
     */
    @CrmExcelColumn("预计折前销售额（元）")
    private BigDecimal estimatedAmountBefore;

    /**
     * 预计折后销售额（元）
     */
    @CrmExcelColumn("预计折后销售额（元）")
    private BigDecimal estimatedAmountAfter;

    /**
     * GMV（元）
     */
    @CrmExcelColumn("GMV（元）")
    private BigDecimal gmv;

    /**
     * 增值税（元）
     */
    @CrmExcelColumn("增值税（元）")
    private BigDecimal vat;

    /**
     * 分销基础返点（旬返）-点数
     */
    @CrmExcelColumn("分销基础返点（旬返）-点数")
    private BigDecimal distributionBaseTenPoint;

    /**
     * 分销基础返点（月返）-点数
     */
    @CrmExcelColumn("分销基础返点（月返）-点数")
    private BigDecimal distributionBaseMonthPoint;

    /**
     * 目标达成返点数
     */
    @CrmExcelColumn("目标达成返点数")
    private BigDecimal monthGoalAchievementPoint;

    /**
     * 百利包（分销）-点数
     */
    @CrmExcelColumn("百利包-点数")
    private BigDecimal prePackPoint;

    /**
     * 人员点数
     */
    @CrmExcelColumn("人员点数")
    private BigDecimal staffFeePoint;

    /**
     * 投放点数
     */
    @CrmExcelColumn("投放点数")
    private BigDecimal putFeePoint;

    /**
     * 物流点数
     */
    @CrmExcelColumn("物流点数")
    private BigDecimal logisticsSupportPoint;

    /**
     * 年返点数
     */
    @CrmExcelColumn("年返点数")
    private BigDecimal yearGoalAchievementPoint;

    /**
     * 分销基础返点（旬返）
     */
    @CrmExcelColumn("分销基础返点（旬返）")
    private BigDecimal distributionBaseTen;

    /**
     * 分销基础返点（月返）
     */
    @CrmExcelColumn("分销基础返点（月返）")
    private BigDecimal distributionBaseMonth;

    /**
     * 月度目标达成返点（分销）
     */
    @CrmExcelColumn("月度目标达成返点（分销）")
    private BigDecimal monthGoalAchievement;

    /**
     * 百利包（分销）
     */
    @CrmExcelColumn("百利包（分销）")
    private BigDecimal prePack;

    /**
     * 人员费用（分销）
     */
    @CrmExcelColumn("人员费用（分销）")
    private BigDecimal staffFee;

    /**
     * 投放费用（分销）
     */
    @CrmExcelColumn("投放费用（分销）")
    private BigDecimal putFee;

    /**
     * 物流支持（分销）
     */
    @CrmExcelColumn("物流支持（分销）")
    private BigDecimal logisticsSupport;

    /**
     * 年度目标达成返点（分销）
     */
    @CrmExcelColumn("年度目标达成返点（分销）")
    private BigDecimal yearGoalAchievement;

    /**
     * 折扣（元）
     */
    @CrmExcelColumn("折扣（元）")
    private BigDecimal discount;

    /**
     * 净收入（元）
     */
    @CrmExcelColumn("净收入（元）")
    private BigDecimal netIncome;

    /**
     * 毛利（元）
     */
    @CrmExcelColumn("毛利（元）")
    private BigDecimal grossProfit;

    /**
     * 销管报销（元）
     */
    @CrmExcelColumn("销管报销（元）")
    private BigDecimal saleReimburse;

    /**
     * 行政+人力（元）
     */
    @CrmExcelColumn("行政+人力（元）")
    private BigDecimal adminHuman;

    /**
     * 经营利润（元）
     */
    @CrmExcelColumn("经营利润（元）")
    private BigDecimal operateProfit;

    /**
     * 所得税（元）
     */
    @CrmExcelColumn("所得税（元）")
    private BigDecimal incomeTax;

    /**
     * 净利润（元）
     */
    @CrmExcelColumn("净利润（元）")
    private BigDecimal netProfit;

    /**
     * 净利率
     */
    @CrmExcelColumn("净利率")
    private BigDecimal netProfitRate;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;

    /**
     * 到手政策价
     */
    @CrmExcelColumn("到手政策价")
    private BigDecimal takeHomePricePolicy;
}
