package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 当月销售分销导入vo
 *
 * @author: yaoyongming
 * @date: 2023/1/11 9:20
 */
@Data
@CrmExcelImport(startRow = 2)
public class CurrentMonthSaleDistributionImportsVo extends CrmExcelVo {


    /**
     * 开始时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn("*开始时间")
    private Date startDate;

    /**
     * 结束时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn("*结束时间")
    private Date endDate;

    /**
     * 客户编码
     */
    @CrmExcelColumn("*客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 电商渠道
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("*产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 活动底价（元）
     */
    @CrmExcelColumn("*活动底价（元）")
    private BigDecimal activityBasePrice;

    /**
     * 组合数量
     */
    @CrmExcelColumn("*组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 促销类型
     */
    @CrmExcelColumn("*促销类型")
    private String promotionTypeCode;

    /**
     * 预计销量（箱）
     */
    @CrmExcelColumn("*预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 分销基础返点（旬返）-点数
     */
    @CrmExcelColumn("分销基础返点（旬返）-点数（%）")
    private BigDecimal distributionBaseTenPoint;

    /**
     * 分销基础返点（月返）-点数
     */
    @CrmExcelColumn("分销基础返点（月返）-点数（%）")
    private BigDecimal distributionBaseMonthPoint;

    /**
     * 目标达成返点数
     */
    @CrmExcelColumn("月度目标达成返点数（%）")
    private BigDecimal monthGoalAchievementPoint;

    /**
     * 百利包（分销）-点数
     */
    @CrmExcelColumn("百利包（%）")
    private BigDecimal prePackPoint;

    /**
     * 人员点数
     */
    @CrmExcelColumn("人员费用点数（%）")
    private BigDecimal staffFeePoint;

    /**
     * 投放点数
     */
    @CrmExcelColumn("投放费用点数（%）")
    private BigDecimal putFeePoint;

    /**
     * 物流点数
     */
    @CrmExcelColumn("物流支持点数（%）")
    private BigDecimal logisticsSupportPoint;

    /**
     * 年返点数
     */
    @CrmExcelColumn("年返点数（%）")
    private BigDecimal yearGoalAchievementPoint;

    /**
     * 到手政策价
     */
    @CrmExcelColumn("到手政策价")
    private BigDecimal takeHomePricePolicy;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;

    private Integer index;

}
