package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 当月销售导出vo
 *
 * @author: yaoyongming
 * @date: 2023/2/6 12:01
 */
@Data
@CrmExcelExport
public class CurrentMonthSaleExportsVo extends CrmExcelVo {

    /**
     * 开始时间
     */
    @CrmExcelColumn("开始时间")
    private String startDateStr;

    /**
     * 结束时间
     */
    @CrmExcelColumn("结束时间")
    private String endDateStr;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;

    /**
     * 税率
     */
    @CrmExcelColumn("税率")
    private BigDecimal taxRate;

    /**
     * 系数
     */
    @CrmExcelColumn("净重（kg)")
    private BigDecimal ratio;

    /**
     * 标准零售价
     */
    @CrmExcelColumn("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 红线价
     */
    @CrmExcelColumn("红线价")
    private BigDecimal redLinePrice;

    /**
     * 平台供货价（元）
     */
    @CrmExcelColumn("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    /**
     * 活动底价（元）
     */
    @CrmExcelColumn("活动底价（元）")
    private BigDecimal activityBasePrice;

    /**
     * 组合数量
     */
    @CrmExcelColumn("组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 促销类型编码
     */
    @CrmExcelColumn("促销类型")
    private String promotionTypeCode;

    /**
     * 预计销量（箱）
     */
    @CrmExcelColumn("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 预计销量（吨）
     */
    @CrmExcelColumn("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    /**
     * 预计折前销售额（元）
     */
    @CrmExcelColumn("预计折前销售额（元）")
    private BigDecimal estimatedAmountBefore;

    /**
     * 预计折后销售额（元）
     */
    @CrmExcelColumn("预计折后销售额（元）")
    private BigDecimal estimatedAmountAfter;

    /**
     * GMV（元）
     */
    @CrmExcelColumn("GMV（元）")
    private BigDecimal gmv;

    /**
     * 增值税（元）
     */
    @CrmExcelColumn("增值税（元）")
    private BigDecimal vat;

    /**
     * 产品促销（元）
     */
    @CrmExcelColumn("产品促销（元）")
    private BigDecimal productPromotion;

    /**
     * 大日期处理（元）
     */
    @CrmExcelColumn("大日期处理（元）")
    private BigDecimal largeDateProcess;

    /**
     * 新客专享（元）
     */
    @CrmExcelColumn("新客专享（元）")
    private BigDecimal newCustomer;

    /**
     * 老客留存（元）
     */
    @CrmExcelColumn("老客留存（元）")
    private BigDecimal oldCustomer;

    /**
     * 达人佣金（抖音）（元）
     */
    @CrmExcelColumn("达人佣金（抖音）（元）")
    private BigDecimal tiktokMaster;

    /**
     * 仓间不均（元）
     */
    @CrmExcelColumn("仓间不均（元）")
    private BigDecimal uneven;

    /**
     * 高周转（元）
     */
    @CrmExcelColumn("高周转（元）")
    private BigDecimal highTurnover;

    /**
     * 平台毛保（元）
     */
    @CrmExcelColumn("平台毛保（元）")
    private BigDecimal platformGrossProtection;

    /**
     * 平台服务费（元）
     */
    @CrmExcelColumn("平台服务费（元）")
    private BigDecimal platformService;

    /**
     * 平台返点费用（元）
     */
    @CrmExcelColumn("平台返点费用（元）")
    private BigDecimal platformRebate;

    /**
     * 平台佣金扣点（元）
     */
    @CrmExcelColumn("平台佣金扣点（元）")
    private BigDecimal platformCommission;

    /**
     * 销售返点（元）
     */
    @CrmExcelColumn("销售返点（元）")
    private BigDecimal saleCommission;

    /**
     * 京东采购返（元）
     */
    @CrmExcelColumn("京东采购返（元）")
    private BigDecimal jd;

    /**
     * 物流费用（元）
     */
    @CrmExcelColumn("物流费用（元）")
    private BigDecimal logistics;

    /**
     * 定额费用合计
     */
    @CrmExcelColumn("定额费用合计")
    private BigDecimal quotaTotal;

    /**
     * 折扣（元）
     */
    @CrmExcelColumn("折扣（元）")
    private BigDecimal discount;

    /**
     * 净收入（元）
     */
    @CrmExcelColumn("净收入（元）")
    private BigDecimal netIncome;

    /**
     * 毛利（元）
     */
    @CrmExcelColumn("毛利（元）")
    private BigDecimal grossProfit;

    /**
     * 销管报销（元）
     */
    @CrmExcelColumn("销管报销（元）")
    private BigDecimal saleReimburse;

    /**
     * 行政+人力（元）
     */
    @CrmExcelColumn("行政+人力（元）")
    private BigDecimal adminHuman;

    /**
     * 经营利润（元）
     */
    @CrmExcelColumn("经营利润（元）")
    private BigDecimal operateProfit;

    /**
     * 所得税（元）
     */
    @CrmExcelColumn("所得税（元）")
    private BigDecimal incomeTax;

    /**
     * 净利润（元）
     */
    @CrmExcelColumn("净利润（元）")
    private BigDecimal netProfit;

    /**
     * 净利率
     */
    @CrmExcelColumn("净利率")
    private BigDecimal netProfitRate;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;
}
