package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 当月实体
 *
 * @author: yaoyongming
 * @date: 2022/11/2 16:27
 */
@Getter
@Setter
@NoArgsConstructor
public class CurrentMonthVo extends ExpensesVo {

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 系数
     */
    @ApiModelProperty("系数")
    private BigDecimal ratio;

    /**
     * 建议零售价（元）
     */
    @ApiModelProperty("建议零售价（元）")
    private BigDecimal suggestedRetailPrice;

    /**
     * 平台供货价（元）
     */
    @ApiModelProperty("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    /**
     * 组合数量
     */
    @ApiModelProperty("组合数量")
    private BigDecimal combinationQuantity;

    /**
     * 预计销量（箱）
     */
    @ApiModelProperty("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    /**
     * 预计销量（吨）
     */
    @ApiModelProperty("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    /**
     * 增值税（元）
     */
    @ApiModelProperty("增值税（元）")
    private BigDecimal vat;

    /**
     * 渠道推广费（元）
     */
    @ApiModelProperty("渠道推广费（元）")
    private BigDecimal channelPromotionFee;

    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    private String erpCode;

    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    private BigDecimal redLinePrice;

    /**
     * 成本价
     */
    @ApiModelProperty("成本价")
    private BigDecimal costPrice;

    /**
     * 折扣（元）
     */
    @ApiModelProperty("折扣（元）")
    private BigDecimal discount;

    /**
     * 净收入（元）
     */
    @ApiModelProperty("净收入（元）")
    private BigDecimal netIncome;

    /**
     * 毛利（元）
     */
    @ApiModelProperty("毛利（元）")
    private BigDecimal grossProfit;

    /**
     * 销管报销（元）
     */
    @ApiModelProperty("销管报销（元）")
    private BigDecimal saleReimburse;

    /**
     * 行政+人力（元）
     */
    @ApiModelProperty("行政+人力（元）")
    private BigDecimal adminHuman;

    /**
     * 其他收益（元）
     */
    @ApiModelProperty("其他收益（元）")
    private BigDecimal otherProfit;

    /**
     * 经营利润（元）
     */
    @ApiModelProperty("经营利润（元）")
    private BigDecimal operateProfit;

    /**
     * 所得税（元）
     */
    @ApiModelProperty("所得税（元）")
    private BigDecimal incomeTax;

    /**
     * 净利润（元）
     */
    @ApiModelProperty("净利润（元）")
    private BigDecimal netProfit;

    /**
     * 净利率
     */
    @ApiModelProperty("净利率")
    private BigDecimal netProfitRate;

    /**
     * 开始时间(导出)
     */
    @ApiModelProperty("开始时间(导出)")
    private String startDateStr;

    /**
     * 结束时间(导出)
     */
    @ApiModelProperty("结束时间(导出)")
    private String endDateStr;
}
