package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 费用申请导入vo
 *
 * @author: yaoyongming
 * @date: 2023/1/11 9:18
 */
@Data
@CrmExcelImport
public class GeneralExpensesImportsVo extends CrmExcelVo {

    /**
     * 主键ID
     */
    @CrmExcelColumn("行ID")
    private String id;

    /**
     * 活动类型编码
     */
    @CrmExcelColumn("*活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @CrmExcelColumn("*活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    /**
     * 开始时间
     */
    @CrmExcelColumn("*开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束时间
     */
    @CrmExcelColumn("*结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 商务政策编码
     */
    @CrmExcelColumn("关联商务政策")
    private String commercePolicyCode;

    /**
     * 月度预算编码
     */
    @CrmExcelColumn("关联预算")
    private String monthBudgetCode;

    /**
     * 三级预算项目名称
     */
    @CrmExcelColumn("三级预算项目")
    private String budgetItemName3;

    /**
     * 二级预算项目名称
     */
    @CrmExcelColumn("二级预算项目")
    private String budgetItemName2;

    /**
     * 一级预算项目名称
     */
    @CrmExcelColumn("一级预算项目")
    private String budgetItemName1;

    /**
     * 客户编码
     */
    @CrmExcelColumn("*客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("电商渠道")
    private String channelName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;

    /**
     * 促销类型编码
     */
    @CrmExcelColumn("促销类型")
    private String promotionTypeCode;

    /**
     * 活动底价（元）
     */
    @CrmExcelColumn("活动底价（元）")
    private BigDecimal activityBasePrice;

    /**
     * 申请金额
     */
    @CrmExcelColumn("*申请金额")
    private BigDecimal applyAmount;

    /**
     * 结案方式
     */
    @CrmExcelColumn("*结案方式")
    private String auditWayName;

    /**
     * 核销条件类型
     */
    @CrmExcelColumn("*核销条件")
    private String auditConditionType;

    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销公式编码")
    private String auditConditionCode;

    /**
     * 核销条件名称
     */
    @CrmExcelColumn("核销公式名称")
    private String auditConditionName;

    /**
     * 合同编码
     */
    @CrmExcelColumn("关联合同编码")
    private String contractCode;

    /**
     * 费用归属年月
     */
    @CrmExcelColumn("费用归属年月")
    private String yearMonthLy;

    /**
     * 备注
     */
    @CrmExcelColumn("备注")
    private String remark;

    private Integer index;

}
