package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 费用申请
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:49
 */
@Getter
@Setter
@ApiModel(value = "GeneralExpensesVo", description = "费用申请vo")
public class GeneralExpensesVo extends ExpensesVo {

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String platformName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 商务政策编码
     */
    @ApiModelProperty("商务政策编码")
    private String commercePolicyCode;

    /**
     * 商务政策名称
     */
    @ApiModelProperty("商务政策名称")
    private String businessPolicyName;

    /**
     * 月度预算编码
     */
    @ApiModelProperty("月度预算编码")
    private String monthBudgetCode;

    /**
     * 三级预算项目
     */
    @ApiModelProperty("三级预算项目")
    private String budgetItemCode3;

    /**
     * 二级预算项目
     */
    @ApiModelProperty("二级预算项目")
    private String budgetItemCode2;

    /**
     * 一级预算项目
     */
    @ApiModelProperty("一级预算项目")
    private String budgetItemCode1;

    /**
     * 三级预算项目名称
     */
    @ApiModelProperty("三级预算项目名称")
    private String budgetItemName3;

    /**
     * 二级预算项目名称
     */
    @ApiModelProperty("二级预算项目名称")
    private String budgetItemName2;

    /**
     * 一级预算项目名称
     */
    @ApiModelProperty("一级预算项目名称")
    private String budgetItemName1;


    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    /**
     * 可用余额
     */
    @ApiModelProperty("可用余额")
    private BigDecimal balance;

    /**
     * 支付方式
     */
    @ApiModelProperty("支付方式")
    private String payType;

    /**
     * 入账方式
     */
    @ApiModelProperty("入账方式")
    private String accountType;

    /**
     * 核销条件类型
     */
    @ApiModelProperty("核销条件类型")
    private String auditConditionType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;

    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;

    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    private String contractCode;

    /**
     * 合同名称
     */
    @ApiModelProperty(name = "合同名称")
    private String contractName;

    /**
     * 活动底价（元）
     */
    @ApiModelProperty("活动底价（元）")
    private BigDecimal activityBasePrice;

    /**
     * 促销类型编码
     */
    @ApiModelProperty("促销类型编码")
    private String promotionTypeCode;

    /**
     * 是否自动生成
     */
    @ApiModelProperty("是否自动生成")
    private Boolean beGenerate = false;

    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("完全结案日期")
    private String wholeAuditDate;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;

    /**
     * 本次结案金额
     */
    @ApiModelProperty("本次结案金额")
    private BigDecimal lastAuditAmount;

    /**
     * 结案方式
     */
    @ApiModelProperty(name = "结案方式", notes = "结案方式")
    private String auditWayCode;

    /**
     * 结案方式名称
     */
    @ApiModelProperty(name = "结案方式名称", notes = "结案方式名称")
    private String auditWayName;

    /**
     * 费用归属年月
     */
    @ApiModelProperty(name = "费用归属年月", notes = "费用归属年月")
    private String yearMonthLy;

    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    private String wholeUpAccount;

    @ApiModelProperty("是否自动结案")
    private String autoAudit;

    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    private BigDecimal alreadyUpAccountAmount;

    /**
     * 开始时间(导出)
     */
    @ApiModelProperty("开始时间(导出)")
    private String startDateStr;

    /**
     * 结束时间(导出)
     */
    @ApiModelProperty("结束时间(导出)")
    private String endDateStr;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    private String erpCode;

    @ApiModelProperty("审批状态")
    private String processStatus;
    @ApiModelProperty("活动申请名称")
    private String activityName;
    @ApiModelProperty(name = "预提金额", notes = "预提金额")
    private BigDecimal withholdingAmount;
    @ApiModelProperty(name = "estimatedWriteOffAmount",notes = "预核销金额")
    private BigDecimal estimatedWriteOffAmount;
    @ApiModelProperty("本次冲销预付金额")
    private BigDecimal thisChargeAgainstPrepayAmount;

    /********************冗余************************/
    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;
    @ApiModelProperty(name = "费用中心", notes = "费用中心")
    private String expenseCenter;
}
