package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 其他费用
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:54
 */
@Getter
@Setter
@ApiModel(value = "OtherExpensesVo", description = "其他费用vo")
public class OtherExpensesVo extends TenantFlagOpVo {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 市场费用-预算（千元）
     */
    @ApiModelProperty("市场费用-预算（千元）")
    private BigDecimal marketAmountBudget;

    /**
     * 市场费用-规划（千元）
     */
    @ApiModelProperty("市场费用-规划（千元）")
    private BigDecimal marketAmountPlan;

    /**
     * 物流费用-预算（千元）
     */
    @ApiModelProperty("物流费用-预算（千元）")
    private BigDecimal logisticsAmountBudget;

    /**
     * 物流费用-规划（千元）
     */
    @ApiModelProperty("物流费用-规划（千元）")
    private BigDecimal logisticsAmountPlan;

    /**
     * 行政管理费用-预算（千元）
     */
    @ApiModelProperty("行政管理费用-预算（千元）")
    private BigDecimal adminAmountBudget;

    /**
     * 行政管理费用-规划（千元）
     */
    @ApiModelProperty("行政管理费用-规划（千元）")
    private BigDecimal adminAmountPlan;

    /**
     * 人力成本-预算（千元）
     */
    @ApiModelProperty("人力成本-预算（千元）")
    private BigDecimal humanAmountBudget;

    /**
     * 人力成本-规划（千元）
     */
    @ApiModelProperty("人力成本-规划（千元）")
    private BigDecimal humanAmountPlan;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 费用归属年月
     */
    @ApiModelProperty("费用归属年月")
    private String yearMonthLy;

    /**
     * 业务模式
     */
    @ApiModelProperty("业务模式")
    private String businessModelCode;
}
