package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/2/13 16:30
 */
@Getter
@Setter
@NoArgsConstructor
public class ProfitLossVo extends TenantFlagOpVo {

    /**
     * 数据字典:mdm_business_format
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

    /**
     * 数据字典:mdm_business_unit
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("业务单元名称")
    private String businessUnitName;

    @ApiModelProperty("年月")
    private String yearMonthly;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty("销售部门")
    private String salesOrgName;

    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("前台/账面")
    private String type;

    @ApiModelProperty("销量（吨）")
    private BigDecimal salesTon;

    @ApiModelProperty("销售额")
    private BigDecimal saleAmount;

    @ApiModelProperty("减：增值税")
    private BigDecimal vatSub;

    @ApiModelProperty("加：增值税-折扣税金")
    private BigDecimal vatAdd;

    @ApiModelProperty("销售收入")
    private BigDecimal saleIncome;

    @ApiModelProperty("减：折扣")
    private BigDecimal discountSub;

    @ApiModelProperty("净收入")
    private BigDecimal netIncome;

    @ApiModelProperty("减：主营税金及附加")
    private BigDecimal mainTaxSub;

    @ApiModelProperty("直接材料")
    private BigDecimal directMaterial;

    @ApiModelProperty("包材折扣")
    private BigDecimal packageDiscount;

    @ApiModelProperty("变动制造费用")
    private BigDecimal variableManufacturing;

    @ApiModelProperty("运输装卸费用")
    private BigDecimal transportHandling;

    @ApiModelProperty("销售费用-销管报销(含税)")
    private BigDecimal saleFeeReimburse;

    @ApiModelProperty("销售费用-销管折扣(含税)")
    private BigDecimal saleFeeSaleDiscount;

    @ApiModelProperty("销管结案批复差异")
    private BigDecimal reimburseDiff;

    @ApiModelProperty("销售费用-市场折扣")
    private BigDecimal saleFeeMarketDiscount;

    @ApiModelProperty("销售费用-行销折扣（含税）")
    private BigDecimal saleFeeOperateDiscount;

    @ApiModelProperty("边际贡献")
    private BigDecimal marginalContribution;

    @ApiModelProperty("减：销售费用-市场报销（含税）")
    private BigDecimal saleFeeMarketReimburseSub;

    @ApiModelProperty("市场结案批复差异")
    private BigDecimal marketDiff;

    @ApiModelProperty("销售费用-行销报销（含税)")
    private BigDecimal saleFeeOperateReimburse;

    @ApiModelProperty("行销批复与结案差")
    private BigDecimal operateDiff;

    @ApiModelProperty("固定制造费用")
    private BigDecimal fixedManufacture;

    @ApiModelProperty("销售费用--仓储费用")
    private BigDecimal saleFeeInventory;

    @ApiModelProperty("销售费用--行政性费用")
    private BigDecimal saleFeeAdmin;

    @ApiModelProperty("销售费用--行政性费用（人力成本）")
    private BigDecimal saleFeeAdminHuman;

    @ApiModelProperty("公共事务专项费用")
    private BigDecimal affair;

    @ApiModelProperty("营改增税金")
    private BigDecimal businessTaxReplacedVat;

    @ApiModelProperty("管理费用")
    private BigDecimal manage;

    @ApiModelProperty("管理费用（人力成本）")
    private BigDecimal manageHuman;

    @ApiModelProperty("研发费用")
    private BigDecimal development;

    @ApiModelProperty("研发费用（人力成本）")
    private BigDecimal developmentHuman;

    @ApiModelProperty("其他")
    private BigDecimal others;

    @ApiModelProperty("加：其他业务收入")
    private BigDecimal othersAdd;

    @ApiModelProperty("减：其他业务支出")
    private BigDecimal othersSub;

    @ApiModelProperty("经营利润")
    private BigDecimal operateProfit;

    @ApiModelProperty("加：其他收益")
    private BigDecimal othersProfitAdd;

    @ApiModelProperty("加：投资收益")
    private BigDecimal incomeFromInvestmentAdd;

    @ApiModelProperty("加：净敞口套期收益")
    private BigDecimal netExposureAdd;

    @ApiModelProperty("加：公允价值变动收益")
    private BigDecimal fairChangeAdd;

    @ApiModelProperty("加：信用减值损失（反号）")
    private BigDecimal creditLossAdd;

    @ApiModelProperty("加：资产减值损失（反号）")
    private BigDecimal assetLossAdd;

    @ApiModelProperty("加：资产处置收益")
    private BigDecimal assetDisposeAdd;

    @ApiModelProperty("加：营业外收入")
    private BigDecimal nonbusinessIncomeAdd;

    @ApiModelProperty("减：营业外支出")
    private BigDecimal nonbusinessCostSub;

    @ApiModelProperty("息前税前利润")
    private BigDecimal ebit;

    @ApiModelProperty("减：财务费用")
    private BigDecimal financialExpensesSub;

    @ApiModelProperty("所得税")
    private BigDecimal incomeTax;

    @ApiModelProperty("净利润")
    private BigDecimal netProfit;

    @ApiModelProperty("GMV")
    private BigDecimal gmv;

    @ApiModelProperty("价格力度")
    private BigDecimal intensity;

    @ApiModelProperty("消费者费用（千元）")
    private BigDecimal consumer;

    @ApiModelProperty("渠道费用（千元）")
    private BigDecimal channel;

    @ApiModelProperty("投放费用（千元）")
    private BigDecimal put;

    @ApiModelProperty("平台运营费用（千元）")
    private BigDecimal platformOperate;

    @ApiModelProperty("费用池（千元）")
    private BigDecimal feePool;
}
