package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 促销费用分摊导入vo
 *
 * @author: yaoyongming
 * @date: 2023/8/29 16:30
 */
@Data
@CrmExcelImport(startRow = 2)
public class PromotionFeeApportionImportsVo extends CrmExcelVo {

    /**
     * 唯一标识
     */
    private String uniqueKey;

    /**
     * 业态编码
     */
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("渠道名称")
    private String channelName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构ERP编码
     */
    private String salesInstitutionErpCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户ERP编码
     */
    private String customerErpCode;

    /**
     * 平台编码
     */
    private String platformCode;

    /**
     * 年月
     */
    @CrmExcelColumn("年月")
    private String yearMonthLy;

    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    private String activityFormName;

    /**
     * 分摊比例
     */
    @CrmExcelColumn("分摊比例")
    private BigDecimal ratio;

    /**
     * 促销费用分摊总额(元)
     */
    @CrmExcelColumn("促销费用分摊总额(元)")
    private BigDecimal feeApportionTotal;

    /**
     * 分摊销售额
     */
    private BigDecimal feeApportion;

    private String tenantCode;
    private String delFlag;
    private String enableStatus;
}
