package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: yaoyongming
 * @date: 2023/7/28 14:52
 */
@Data
@CrmExcelExport
public class PromotionPlanCostProgressExportsVo extends CrmExcelVo {

    /**
     * 费用归属年月
     */
    @CrmExcelColumn("费用归属年月")
    private String yearMonthLy;

    /**
     * 促销规划编码
     */
    @CrmExcelColumn("促销规划编码")
    private String promotionPlanCode;

    /**
     * 促销规划名称
     */
    @CrmExcelColumn("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划明细编码
     */
    @CrmExcelColumn("促销规划明细编码")
    private String expensesCode;

    /**
     * 活动类型编码
     */
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    /**
     * 平台编码
     */
    @CrmExcelColumn("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @CrmExcelColumn("平台名称")
    private String platformName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户MDG编码
     */
    @CrmExcelColumn("客户MDG编码")
    private String customerMdgCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 业态编码
     */
    @CrmExcelColumn("业态编码")
    private String businessFormatCode;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesOrgCode;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;



    /**
     * 业务模式
     */
    @CrmExcelColumn("业务模式")
    private String businessModelCode;

    /**
     * 开始时间
     */
    @CrmExcelColumn("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束时间
     */
    @CrmExcelColumn("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 申请金额
     */
    @CrmExcelColumn("申请金额")
    private BigDecimal applyAmount;

    /**
     * 月预计销售额
     */
    @CrmExcelColumn("月预计销售额")
    private BigDecimal monthSaleAmount;

    /**
     * 规划费率
     */
    @CrmExcelColumn("规划费率")
    private BigDecimal planRate;

    /**
     * 费用实际消耗
     */
    @CrmExcelColumn("费用实际消耗")
    private BigDecimal actualCost;

    /**
     * 实际销售额
     */
    @CrmExcelColumn("实际销售额")
    private BigDecimal actualSaleAmount;

    /**
     * 实际费率
     */
    @CrmExcelColumn("实际费率")
    private BigDecimal actualRate;

    /**
     * 销售进度
     */
    @CrmExcelColumn("销售进度")
    private BigDecimal saleAmountProgress;

    /**
     * 费用消耗进度
     */
    @CrmExcelColumn("费用消耗进度")
    private BigDecimal costProgress;
}
