package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName PromotionPlanForEventPrepaymentVo
 * @Description 电商获取活动细案Vo
 * @AUTHOR WangJJ
 * @DATE 2023/3/5 17:05
 **/
@Data
public class PromotionPlanForEventPrepaymentVo {

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("活动明细编码")
    private String expensesCode;

    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("结案方式编码")
    private String auditWayCode;

    @ApiModelProperty("结案方式名称")
    private String auditWayName;

    @ApiModelProperty("申请金额")
    private String applyAmount;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String platformName;


}
