package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划结果呈现表vo
 *
 * @author: cyj
 * @date: 2023/1/14 16:35
 */
@Getter
@Setter
@ApiModel(value = "PromotionPlanParamVo", description = "促销规划结果呈现表vo")
public class PromotionPlanParamVo extends TenantFlagOpVo {

    @ApiModelProperty("销售部门编码")
    private String salesDepartmentCode;

    @ApiModelProperty("销售部门名称")
    private String salesDepartmentName;

    @ApiModelProperty("hr部门编码")
    private String orgCode;

    @ApiModelProperty("hr部门名称")
    private String orgName;

    @ApiModelProperty("平台编码")
    private String platformCode;

    @ApiModelProperty("平台名称")
    private String platformName;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("同期")
    private BigDecimal contemporaneous;

    @ApiModelProperty("预算")
    private BigDecimal budget;

    @ApiModelProperty("规划")
    private BigDecimal plan;

    @ApiModelProperty("累计同期")
    private BigDecimal contemporaneousTotal;

    @ApiModelProperty("累计预算")
    private BigDecimal budgetTotal;

    @ApiModelProperty("累计规划")
    private BigDecimal planTotal;

    @ApiModelProperty("规划VS同期")
    private BigDecimal planVsContemporaneous;

    @ApiModelProperty("规划VS预算")
    private BigDecimal planVsBudget;

    @ApiModelProperty("累计实际&规划")
    private BigDecimal actualPlan;

    @ApiModelProperty("累计实际&规划VS预算")
    private BigDecimal actualPlanVsBudget;

    @ApiModelProperty("前台/账面")
    private String type;

    @ApiModelProperty(name = "年月", notes = "年月")
    private String startDate;

    @ApiModelProperty("业务模式")
    private String businessModelCode;
}
