package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划结果呈现表vo
 *
 * @author: yaoyongming
 * @date: 2023/1/14 16:35
 */
@Getter
@Setter
@ApiModel(value = "PromotionPlanResultVo", description = "促销规划结果呈现表vo")
public class PromotionPlanResultVo extends TenantFlagOpVo {
    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    public PromotionPlanResultVo(String promotionPlanCode, String promotionPlanName, Date startDate, Date endDate, String projectCode, String projectName, String type) {
        this.promotionPlanCode = promotionPlanCode;
        this.promotionPlanName = promotionPlanName;
        this.startDate = startDate;
        this.endDate = endDate;
        this.projectCode = projectCode;
        this.projectName = projectName;
        this.type = type;
    }

    public PromotionPlanResultVo() {

    }

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划时间开始
     */
    @ApiModelProperty("促销规划时间开始")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 促销规划时间结束
     */
    @ApiModelProperty("促销规划时间结束")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 月份
     */
    @ApiModelProperty("月份")
    private String yearMonthLy;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    private BigDecimal plan;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    private BigDecimal budgetTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    private BigDecimal planTotal;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    private BigDecimal planVsBudget;

    /**
     * 累计实际&规划
     */
    @ApiModelProperty("累计实际&规划")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    private BigDecimal actualPlanVsBudget;

    /**
     * 前台/账面
     */
    @ApiModelProperty("前台/账面")
    private String type;
}
