package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import javax.jws.HandlerChain;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划结果呈现表vo
 *
 * @author: yaoyongming
 * @date: 2023/1/14 16:35
 */
@Data
@ApiModel(value = "PromotionPlanResultVoStr", description = "促销规划结果呈现表vo")
@Accessors(chain = true)
public class PromotionPlanResultVoStr extends TenantFlagOpVo {
    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    public PromotionPlanResultVoStr(String promotionPlanCode, String promotionPlanName, Date startDate, Date endDate, String projectCode, String projectName) {
        this.promotionPlanCode = promotionPlanCode;
        this.promotionPlanName = promotionPlanName;
        this.startDate = startDate;
        this.endDate = endDate;
        this.projectCode = projectCode;
        this.projectName = projectName;
    }

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划时间开始
     */
    @ApiModelProperty("促销规划时间开始")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 促销规划时间结束
     */
    @ApiModelProperty("促销规划时间结束")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    private String contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    private String budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    private String plan;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    private String contemporaneousTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    private String budgetTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    private String planTotal;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    private String planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    private String planVsBudget;

    /**
     * 累计实际&规划
     */
    @ApiModelProperty("累计实际&规划")
    private String actualPlan;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    private String actualPlanVsBudget;

    /**
     * 前台/账面
     */
    @ApiModelProperty("前台/账面")
    private String type;

    public PromotionPlanResultVoStr() {

    }
}
