package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 平台维度电商的促销规划一览汇总表Vo
 *
 * @author: cyj
 * @date: 2022/12/23 11:04
 */
@Data
@CrmExcelExport
public class PromotionPlanTableFormExportVo extends CrmExcelVo {

    @CrmExcelColumn("销售部门编码")
    private String salesDepartmentCode;

    @CrmExcelColumn("销售部门名称")
    private String salesDepartmentName;

    @CrmExcelColumn("平台编码")
    private String platformCode;

    @CrmExcelColumn("平台名称")
    private String platformName;

    @CrmExcelColumn("同期净收入")
    private BigDecimal netIncomeContemporaneous;

    @CrmExcelColumn("预算净收入")
    private BigDecimal netIncomeBudget;

    @CrmExcelColumn("规划净收入")
    private BigDecimal netIncomePlan;

    @CrmExcelColumn("净收入达成")
    private BigDecimal incomeAchievement;

    @CrmExcelColumn("VS同期（净收入）")
    private BigDecimal vsContemporaneous;

    @CrmExcelColumn("VS预算（净收入）")
    private BigDecimal vsBudget;

    @CrmExcelColumn("同期专项费用率")
    private BigDecimal contemporaneousSpecialExpenseRate;

    @CrmExcelColumn("预算专项费用率")
    private BigDecimal budgetSpecialExpenseRate;

    @CrmExcelColumn("规划专项费用率")
    private BigDecimal planSpecialExpenseRate;

    @CrmExcelColumn("VS同期（费用率）")
    private BigDecimal expenseRateVsContemporaneous;

    @CrmExcelColumn("VS预算（费用率）")
    private BigDecimal expenseRateVsBudget;

    @CrmExcelColumn("预算净利润")
    private BigDecimal budgetNetProfit;

    @CrmExcelColumn("规划净利润")
    private BigDecimal plannedNetProfit;

    @CrmExcelColumn("预算净利率")
    private BigDecimal budgetProfitMargin;

    @CrmExcelColumn("规划净利率")
    private BigDecimal plannedProfitMargin;

    @CrmExcelColumn("净利率达成")
    private BigDecimal profitMarginReached;

    @CrmExcelColumn("年月")
    private String yearAndMonth;

    @CrmExcelColumn("0=部门,1=平台")
    private String levelCode;
}
