package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;


/**
 * @author: yaoyongming
 * @date: 2023/9/11 17:43
 */
@Accessors(chain = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PromotionPlanWholeSummaryDetailStrVo {

    /**
     * 项目名称
     */
    @ExcelProperty("项目名称")
    private String projectName;

    /**
     * 同期
     */
    @ExcelProperty("同期")
    private String contemporaneous;

    /**
     * 预算
     */
    @ExcelProperty("预算")
    private String budget;

    /**
     * 规划
     */
    @ExcelProperty("规划")
    private String plan;

    /**
     * 累计同期
     */
    @ExcelProperty("累计同期")
    private String contemporaneousTotal;

    /**
     * 累计预算
     */
    @ExcelProperty("累计预算")
    private String budgetTotal;

    /**
     * 累计规划
     */
    @ExcelProperty("累计规划")
    private String planTotal;

    /**
     * 规划VS同期
     */
    @ExcelProperty("规划VS同期")
    private String planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ExcelProperty("规划VS预算")
    private String planVsBudget;

    /**
     * 累计实际&规划（当月）
     */
    @ExcelProperty("累计实际&规划（当月）")
    private String actualPlan;

    /**
     * 累计实际&规划（当月+上月）
     */
    @ExcelProperty("累计实际&规划（当月+上月）")
    private String actualPlanLast;

    /**
     * 累计实际&规划VS预算
     */
    @ExcelProperty("累计实际&规划VS预算")
    private String actualPlanVsBudget;

    /**
     * 年累计预算
     */
    @ExcelProperty("年累计预算")
    private String budgetTotalYear;

    /**
     * 使用进度
     */
    @ExcelProperty("使用进度")
    private String useProgress;
}
