package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 17:43
 */
@Data
public class PromotionPlanWholeSummaryDetailVo extends TenantFlagOpVo {

    @ApiModelProperty("排序值(值越小越靠前)")
    private Integer sortIndex;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    private BigDecimal plan;

    /**
     * 规划（当月-1）
     */
    @ApiModelProperty("规划（当月-1）")
    private BigDecimal planSub1;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    private BigDecimal budgetTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    private BigDecimal planTotal;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    private BigDecimal planVsBudget;

    /**
     * 累计实际（当月-1）
     */
    @ApiModelProperty("累计实际（当月-1）")
    private BigDecimal actualSub1;

    /**
     * 累计实际（当月-2）
     */
    @ApiModelProperty("累计实际（当月-2）")
    private BigDecimal actualSub2;

    /**
     * 累计实际&规划（当月）
     */
    @ApiModelProperty("累计实际&规划（当月）")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划（当月+上月）
     */
    @ApiModelProperty("累计实际&规划（当月+上月）")
    private BigDecimal actualPlanLast;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    private BigDecimal actualPlanVsBudget;

    /**
     * 年累计预算
     */
    @ApiModelProperty("年累计预算")
    private BigDecimal budgetTotalYear;

    /**
     * 使用进度
     */
    @ApiModelProperty("使用进度")
    private BigDecimal useProgress;
}
