package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 采销库存导出vo
 *
 * @author: yaoyongming
 * @date: 2023/2/6 15:55
 */
@Data
@CrmExcelExport
public class PurchaseSaleExportsVo extends CrmExcelVo {

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;

    /**
     * 标准零售价
     */
    @CrmExcelColumn("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 红线价
     */
    @CrmExcelColumn("红线价")
    private BigDecimal redLinePrice;

    /**
     * 平台供货价（元）
     */
    @CrmExcelColumn("平台供货价（元）")
    private BigDecimal supplyPrice;

    /**
     * 本月期末库存（箱）
     */
    @CrmExcelColumn("本月期末库存（箱）")
    private BigDecimal monthInventoryEnd;

    /**
     * 本月库存预估价（元）
     */
    @CrmExcelColumn("本月库存预估价（元）")
    private BigDecimal promotionPrice;

    /**
     * 次月期末库存（箱）
     */
    @CrmExcelColumn("次月期末库存（箱）")
    private BigDecimal nextMonthEndInventory;

    /**
     * 次月库存预估售价（元）
     */
    @CrmExcelColumn("次月库存预估售价（元）")
    private BigDecimal nextMonthInventoryAmount;

    /**
     * 费用池-补差
     */
    @CrmExcelColumn("费用池-补差")
    private BigDecimal feePoolDifference;

    /**
     * 费用池-销售返
     */
    @CrmExcelColumn("费用池-销售返")
    private BigDecimal feePoolSaleCommission;

    /**
     * 费用池-采购返
     */
    @CrmExcelColumn("费用池-采购返")
    private BigDecimal feePoolPurchaseRebate;

    /**
     * 费用池-投放
     */
    @CrmExcelColumn("费用池-投放")
    private BigDecimal feePoolPut;

    /**
     * 费用池-毛保
     */
    @CrmExcelColumn("费用池-毛保")
    private BigDecimal feePoolGrossProtection;
}
